<?php

include "utils.php";

$dbConn = connect($db);

/*
listar todos los posts o solo uno
 */
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    if (isset($_GET['id_proyecto_empleado_archivos'])) {
        $id_proyecto_empleado = $_GET["id_proyecto_empleado_archivos"];
        $images = glob('../archivos/proyecto_empleado/' . $id_proyecto_empleado . '/*.{png,jpg,pdf}', GLOB_BRACE);
        $fileObjects = array();

        foreach ($images as $image) {
            $fileInfo = pathinfo($image);
            $fileObject = new stdClass(); // Crear un objeto vacío para almacenar los datos
            $fileObject->url = $image; // Almacenar la URL del archivo
            $fileObject->extension = $fileInfo['extension']; // Almacenar la extensión del archivo
            $fileObject->nombre = $fileInfo['basename']; // Almacenar la extensión del archivo

            $fileObjects[] = $fileObject; // Agregar el objeto al arreglo
        }
        header("HTTP/1.1 200 OK");
        echo json_encode($fileObjects);
        exit();
    }

    if (isset($_GET['id_proyecto_empleado'])) {
        //Mostrar un post
        $sql = $dbConn->prepare("SELECT * FROM proyecto_empleado where id_proyecto_empleado=:id_proyecto_empleado");
        $sql->bindValue(':id_proyecto_empleado', $_GET['id_proyecto_empleado']);
        $sql->execute();
        $proyecto_empleado = $sql->fetch(PDO::FETCH_ASSOC);
        if ($proyecto_empleado["id_proyecto"] != null) {
            $id = $proyecto_empleado["id_proyecto"];
            $sql = "SELECT * FROM proyectos where id_proyecto=:id_proyecto";
            $stmt = $dbConn->prepare($sql);
            $stmt->bindParam(':id_proyecto', $id, PDO::PARAM_INT);
            $stmt->execute();
            // Obtener el resultado como un objeto
            $proyecto = $stmt->fetch(PDO::FETCH_ASSOC);
            $proyecto_empleado["proyecto"] = $proyecto;
        } else {
            $proyecto_empleado["proyecto"] = null;
        }
        if ($proyecto_empleado["id_empleado"] != null) {
            $id = $proyecto_empleado["id_empleado"];
            $sql = "SELECT * FROM empleados where id_empleado=:id_empleado";
            $stmt = $dbConn->prepare($sql);
            $stmt->bindParam(':id_empleado', $id, PDO::PARAM_INT);
            $stmt->execute();
            // Obtener el resultado como un objeto
            $empleado = $stmt->fetch(PDO::FETCH_ASSOC);
            $proyecto_empleado["empleado"] = $empleado;
        } else {
            $proyecto_empleado["empleado"] = null;
        }
        if ($proyecto_empleado["id_grupo2"] != null) {
            $id = $proyecto_empleado["id_grupo2"];
            $sql = "SELECT * FROM grupos2 where id_grupo2=:id_grupo2";
            $stmt = $dbConn->prepare($sql);
            $stmt->bindParam(':id_grupo2', $id, PDO::PARAM_INT);
            $stmt->execute();
            // Obtener el resultado como un objeto
            $grupo = $stmt->fetch(PDO::FETCH_ASSOC);

            $sql = "SELECT e.*
        FROM empleados e
        INNER JOIN empleado_grupo2 eg ON e.id_empleado = eg.id_empleado
        WHERE eg.id_grupo2 = :id_grupo2";
            $stmt = $dbConn->prepare($sql);
            $stmt->bindParam(':id_grupo2', $id, PDO::PARAM_INT);
            $stmt->execute();
            $empleados = $stmt->fetchAll(PDO::FETCH_OBJ);
            $grupo["empleados"] = $empleados;


            $proyecto_empleado["grupo"] = $grupo;
        } else {
            $proyecto_empleado["grupo"] = null;
        }



        header("HTTP/1.1 200 OK");
        echo json_encode($proyecto_empleado);
        exit();
    }

    if (isset($_GET['id_proyecto'])) {

        try {
            if ($_GET['id_proyecto'] === "No") {
                // Si id_proyecto es "No", devolver todos los proyectos
                $sql = "SELECT * FROM proyectos";
                $stmt = $dbConn->prepare($sql);
            } else {
                // Si id_proyecto es diferente de "No", devolver solo ese proyecto
                $id_p = $_GET['id_proyecto'];
                $sql = "SELECT * FROM proyectos WHERE id_proyecto = :id_proyecto";
                $stmt = $dbConn->prepare($sql);
                $stmt->bindParam(':id_proyecto', $id_p, PDO::PARAM_INT);
            }

            $stmt->execute();
            // Obtener el resultado como un objeto
            $proyectos = $stmt->fetchAll(PDO::FETCH_ASSOC);
            $proyectosActualizados = [];
            foreach ($proyectos as $proyecto) {
                $id_p = $proyecto["id_proyecto"];
                if (isset($_GET['fecha_i']) && isset($_GET['fecha_f'])) {
                    $fecha_i = $_GET['fecha_i'];
                    $fecha_f = $_GET['fecha_f'];
                    $sql = $dbConn->prepare("SELECT * FROM proyecto_empleado 
                WHERE (DATE_FORMAT(fecha_i, '%Y-%m-%d') BETWEEN :fecha_i AND :fecha_f) 
                AND id_proyecto=:id_proyecto;");
                    $sql->bindParam(':fecha_i', $fecha_i);
                    $sql->bindParam(':fecha_f', $fecha_f);
                } else {
                    $sql = $dbConn->prepare("SELECT * 
                FROM proyecto_empleado where id_proyecto=:id_proyecto;");
                }

                $sql->bindValue(':id_proyecto', $id_p);
                $sql->execute();
                $sql->setFetchMode(PDO::FETCH_ASSOC);
                $proyectos_empleado = $sql->fetchAll(PDO::FETCH_OBJ);

                if (isset($_GET['fecha_i']) && isset($_GET['fecha_f'])) {
                    $fecha_i = $_GET['fecha_i'];
                    $fecha_f = $_GET['fecha_f'];
                    $sql = $dbConn->prepare("SELECT * FROM gasto_proyecto 
                WHERE (DATE_FORMAT(fecha, '%Y-%m-%d') BETWEEN :fecha_i AND :fecha_f) 
                AND id_proyecto=:id_proyecto;");
                    $sql->bindParam(':fecha_i', $fecha_i);
                    $sql->bindParam(':fecha_f', $fecha_f);
                } else {
                    $sql = $dbConn->prepare("SELECT * 
                FROM gasto_proyecto where id_proyecto=:id_proyecto;");
                }

                $sql->bindValue(':id_proyecto', $id_p);
                $sql->execute();
                $sql->setFetchMode(PDO::FETCH_ASSOC);
                $gastos_proyecto = $sql->fetchAll(PDO::FETCH_OBJ);
                $proyecto["gastos_proyecto"] = $gastos_proyecto;

                $minutos_totales = 0;
                $coste_total = 0.00;
                $gasto_adicional = 0.00;
                foreach ($gastos_proyecto as $gasto) {
                    $gasto_adicional += $gasto->importe;
                }
                $proyecto["gastos_adicionales"] = $gasto_adicional;
                foreach ($proyectos_empleado as $proyecto_empleado) {
                    $fechaInicio = new DateTime($proyecto_empleado->fecha_i);
                    $fechaFin = new DateTime($proyecto_empleado->fecha_f);

                    // Diferencia entre las fechas
                    $diferencia = $fechaInicio->diff($fechaFin);
                    $horas = intval($diferencia->h);

                    $minutos = intval($diferencia->i);
                    $minutos_totales += $horas * 60 + $minutos;
                    // Si deseas obtener la cantidad total de minutos
                    //$totalMinutos = $horas * 60 + $minutos;
                    if ($proyecto_empleado->id_empleado != null) {
                        $id = $proyecto_empleado->id_empleado;
                        $sql = "SELECT * FROM empleados where id_empleado=:id_empleado";
                        $stmt = $dbConn->prepare($sql);
                        $stmt->bindParam(':id_empleado', $id, PDO::PARAM_INT);
                        $stmt->execute();
                        // Obtener el resultado como un objeto
                        $empleado = $stmt->fetch(PDO::FETCH_ASSOC);
                        $coste_total += floatval($empleado["precio_dia"] * $horas);
                        $proyecto_empleado->empleado = $empleado;
                    } else {
                        $proyecto_empleado->empleado = null;
                    }
                    if ($proyecto_empleado->id_grupo2 != null) {
                        $id = $proyecto_empleado->id_grupo2;
                        $sql = "SELECT * FROM grupos2 where id_grupo2=:id_grupo2";
                        $stmt = $dbConn->prepare($sql);
                        $stmt->bindParam(':id_grupo2', $id, PDO::PARAM_INT);
                        $stmt->execute();
                        // Obtener el resultado como un objeto
                        $grupo = $stmt->fetch(PDO::FETCH_ASSOC);

                        $sql = "SELECT e.*
                        FROM empleados e
                        INNER JOIN empleado_grupo2 eg ON e.id_empleado = eg.id_empleado
                        WHERE eg.id_grupo2 = :id_grupo2";
                        $stmt = $dbConn->prepare($sql);
                        $stmt->bindParam(':id_grupo2', $id, PDO::PARAM_INT);
                        $stmt->execute();
                        $empleados = $stmt->fetchAll(PDO::FETCH_OBJ);
                        $grupo["empleados"] = $empleados;

                        foreach ($empleados as $emp) {
                            $coste_total += floatval($emp->precio_dia * $horas);
                        }


                        $proyecto_empleado->grupo = $grupo;
                    } else {
                        $proyecto_empleado->grupo = null;
                    }
                }
                $proyecto['coste_total'] = $coste_total;
                $proyecto['tiempo_total'] = $minutos_totales;
                $proyecto['horarios_asignados'] = $proyectos_empleado;

                $id_p;
                //Mostrar lista de post
                if (isset($_GET['fecha_i']) && isset($_GET['fecha_f'])) {
                    $fecha_i = $_GET['fecha_i'];
                    $fecha_f = $_GET['fecha_f'];
                    $sql = $dbConn->prepare("SELECT f.*, 
                    COALESCE(SUM(a.cantidad * a.precio_unitario * (a.igic / 100)), 0) AS igic_sumado,
                    (COALESCE(SUM(a.cantidad * a.precio_unitario * (a.igic / 100)), 0) + f.importe - 
        COALESCE(f.importe * (f.irpf / 100), 0)) AS importe_calculado
                    FROM factura_manual f
                    LEFT JOIN apartado_factura_manual a ON f.id_factura_manual = a.id_factura_manual
                    WHERE (DATE_FORMAT(f.fecha, '%Y-%m-%d') BETWEEN :fecha_i AND :fecha_f) AND (f.id_proyecto = :id_proyecto)");
                    $sql->bindParam(':fecha_i', $fecha_i);
                    $sql->bindParam(':fecha_f', $fecha_f);
                } else {
                    $sql = $dbConn->prepare("SELECT f.*, 
                    COALESCE(SUM(a.cantidad * a.precio_unitario * (a.igic / 100)), 0) AS igic_sumado,
                    (COALESCE(SUM(a.cantidad * a.precio_unitario * (a.igic / 100)), 0) + f.importe - 
        COALESCE(f.importe * (f.irpf / 100), 0)) AS importe_calculado
                    FROM factura_manual f
                    LEFT JOIN apartado_factura_manual a ON f.id_factura_manual = a.id_factura_manual
                        
                WHERE (f.id_proyecto = :id_proyecto)");
                }
                $sql->bindValue(':id_proyecto', $id_p);
                $sql->execute();
                $sql->setFetchMode(PDO::FETCH_ASSOC);
                $facturas = $sql->fetchAll(PDO::FETCH_OBJ);

                $proyecto["facturas"] = $facturas;
                $total_cobrado = 0.00;

                // Suponiendo que $objeto es tu objeto principal con un atributo 'facturas'
                foreach ($proyecto["facturas"] as $f) {
                    $id_factura_manual = $f->id_factura_manual;


                    $sql = "SELECT * FROM facturas_rectificadas WHERE id_factura_manual = :id_factura_manual;";
                    $stmt = $dbConn->prepare($sql);
                    $stmt->bindParam(':id_factura_manual', $id_factura_manual, PDO::PARAM_INT);
                    $stmt->execute();
                    // Obtener el resultado como un objeto
                    $factura_rectificada = $stmt->fetch(PDO::FETCH_OBJ);
                    $f->factura_rectificada = $factura_rectificada;
                    $id_factura_rectificada = $f->factura_rectificada->id_factura_rectificada;

                    $sql = "SELECT a.*, 
                COALESCE(m.cantidad, 'Ninguno') AS cantidad_original,
                COALESCE(m.precio_unitario, 'Ninguno') AS precio_unitario_original,
                m.igic AS igic_original,
                m.codigo,
                ROUND(
                    CASE 
                        WHEN TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) <> '' 
                        THEN 
                            CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario +
                            (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100)
                        ELSE 0
                    END
                , 2) AS total,
                ROUND(
                    CASE 
                        WHEN TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) <> '' 
                        THEN 
                            CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario +
                            (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100)
                        ELSE 0
                    END
                , 2) AS total_original,
                ROUND(
                    CASE 
                        WHEN TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) <> '' 
                        THEN 
                            CASE 
                                WHEN TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) <> '' 
                                THEN 
                                    CASE 
                                        WHEN 
                                            (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario + 
                                            CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100) >
                                            (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario + 
                                            CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100)
                                        THEN 
                                            (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario + 
                                            CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100) -
                                            (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario + 
                                            CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100)
                                        ELSE 
                                            (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario + 
                                            CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100) -
                                            (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario + 
                                            CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100)
                                    END
                                ELSE 
                                    0
                            END
                        ELSE 
                            0
                    END
                    , 2) AS diferencia_total_total_original
            FROM apartado_factura_rectificada a
            LEFT JOIN apartado_factura_manual m ON a.id_apartado_factura_manual = m.id_apartado_factura_manual
            WHERE id_factura_rectificada = :id_factura_rectificada;";
                    $stmt = $dbConn->prepare($sql);
                    $stmt->bindParam(':id_factura_rectificada', $id_factura_rectificada, PDO::PARAM_INT);
                    $stmt->execute();
                    // Obtener el resultado como un objeto
                    $apartados = $stmt->fetchAll(PDO::FETCH_OBJ);
                    $factura_rectificada->apartados = $apartados;
                    $sumaDiferencias = 0;
                    $total_rectificado = null;
                    $suma_irpf = ($f->irpf != null) ? ($f->irpf / 100) : 0;

                    // Iterar sobre los apartados de cada factura
                    foreach ($apartados as $apartado) {
                        // Calcular la diferencia entre 'total' y 'total_original'
                        $diferencia = floatval($apartado->total) - floatval($apartado->total_original);
                        $diferencia_sin_ig = floatval($apartado->precio_unitario * $apartado->cantidad) - floatval($apartado->precio_unitario_original * $apartado->cantidad_original);
                        // Sumar la diferencia a 'sumaDiferencias'
                        $sumaDiferencias += $diferencia;
                        $sumaDiferenciasSinIg += $diferencia_sin_ig;
                    }

                    $f->importe_calculado = floatval($f->importe_calculado);
                    // Agregar 'sumaDiferencias' como un nuevo atributo al objeto principal
                    $total_rectificado = $f->importe_calculado + $sumaDiferencias;
                    $f->suma_diferencias = $sumaDiferencias;
                    $f->suma_diferencias_sin_ig = $sumaDiferenciasSinIg;
                    $f->total_rectificado = $total_rectificado;

                    // Asumiendo que 'importe_calculado' es un atributo de cada factura
                    $total_cobrado += floatval($f->total_rectificado);
                }

                // Almacenar el total en un nuevo atributo 'total_cobrado' en el objeto principal
                $proyecto["total_cobrado"] = number_format((float) $total_cobrado, 2, '.', '');

                $proyectosActualizados[] = $proyecto;
            }





            header("HTTP/1.1 200 OK");
            echo json_encode($proyectosActualizados);

            exit();
        } catch (PDOException $e) {
            // Manejar el error
            header("HTTP/1.1 200 OK");
            echo "Error al ejecutar la consulta: " . $e->getMessage();
            exit();
        }
    } else {
        //Mostrar lista de post
        $sql = $dbConn->prepare("SELECT * 
        FROM proyecto_empleado;");
        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        $proyectos_empleado = $sql->fetchAll(PDO::FETCH_OBJ);
        foreach ($proyectos_empleado as $proyecto_empleado) {
            if ($proyecto_empleado->id_proyecto != null) {
                $id = $proyecto_empleado->id_proyecto;
                $sql = "SELECT * FROM proyectos where id_proyecto=:id_proyecto";
                $stmt = $dbConn->prepare($sql);
                $stmt->bindParam(':id_proyecto', $id, PDO::PARAM_INT);
                $stmt->execute();
                // Obtener el resultado como un objeto
                $proyecto = $stmt->fetch(PDO::FETCH_ASSOC);
                $proyecto_empleado->proyecto = $proyecto;
            } else {
                $proyecto_empleado->proyecto = null;
            }
            if ($proyecto_empleado->id_empleado != null) {
                $id = $proyecto_empleado->id_empleado;
                $sql = "SELECT * FROM empleados where id_empleado=:id_empleado";
                $stmt = $dbConn->prepare($sql);
                $stmt->bindParam(':id_empleado', $id, PDO::PARAM_INT);
                $stmt->execute();
                // Obtener el resultado como un objeto
                $empleado = $stmt->fetch(PDO::FETCH_ASSOC);
                $proyecto_empleado->empleado = $empleado;
            } else {
                $proyecto_empleado->empleado = null;
            }
            if ($proyecto_empleado->id_grupo2 != null) {
                $id = $proyecto_empleado->id_grupo2;
                $sql = "SELECT * FROM grupos2 where id_grupo2=:id_grupo2";
                $stmt = $dbConn->prepare($sql);
                $stmt->bindParam(':id_grupo2', $id, PDO::PARAM_INT);
                $stmt->execute();
                // Obtener el resultado como un objeto
                $grupo = $stmt->fetch(PDO::FETCH_ASSOC);

                $sql = "SELECT e.*
                FROM empleados e
                INNER JOIN empleado_grupo2 eg ON e.id_empleado = eg.id_empleado
                WHERE eg.id_grupo2 = :id_grupo2";
                $stmt = $dbConn->prepare($sql);
                $stmt->bindParam(':id_grupo2', $id, PDO::PARAM_INT);
                $stmt->execute();
                $empleados = $stmt->fetchAll(PDO::FETCH_OBJ);
                $grupo["empleados"] = $empleados;


                $proyecto_empleado->grupo = $grupo;
            } else {
                $proyecto_empleado->grupo = null;
            }
        }

        header("HTTP/1.1 200 OK");
        echo json_encode($proyectos_empleado);

        exit();
    }
}
// Crear un nuevo post
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (
        isset($_POST["id_proyecto"]) &&
        isset($_POST["id_grupo2"]) &&
        isset($_POST["id_empleado"]) &&
        isset($_POST["fecha_i"]) &&
        isset($_POST["fecha_f"])
    ) {

        foreach ($_POST as $key => $value) {
            $value = ($value == "") ? null : $value;
            $$key = $value;
        }


        if (isset($_POST["id_proyecto_empleado"])) {
            $id_proyecto_empleado = $_POST["id_proyecto_empleado"];
            $sql = "UPDATE proyecto_empleado SET
            id_proyecto = :id_proyecto,
            id_grupo2 = :id_grupo2,
            id_empleado = :id_empleado,
            fecha_i = :fecha_i,
            fecha_f = :fecha_f
            WHERE
            id_proyecto_empleado = :id_proyecto_empleado";
            $statement = $dbConn->prepare($sql);
            $statement->bindValue(':id_proyecto_empleado', $id_proyecto_empleado);
        } else {
            $sql = "INSERT INTO proyecto_empleado
                (id_proyecto,id_grupo2,id_empleado,fecha_i,fecha_f)
                VALUES
                (:id_proyecto,:id_grupo2,:id_empleado,:fecha_i,:fecha_f)";
            $statement = $dbConn->prepare($sql);
        }



        $statement->bindValue(':id_proyecto', $id_proyecto);
        $statement->bindValue(':id_grupo2', $id_grupo2);
        $statement->bindValue(':id_empleado', $id_empleado);
        $statement->bindValue(':fecha_i', $fecha_i);
        $statement->bindValue(':fecha_f', $fecha_f);
        $statement->execute();

        if (!isset($_POST["id_proyecto_empleado"])) {
            $id_proyecto_empleado = $dbConn->lastInsertId();
            $carpetaNuevaAlumno = '../archivos/proyecto_empleado/' . $id_proyecto_empleado;

            mkdir($carpetaNuevaAlumno, 0777, true);
        }


        if ($id_empleado != null) {
            $id = $id_empleado;
            $sql = "SELECT * FROM empleados where id_empleado=:id_empleado";
            $stmt = $dbConn->prepare($sql);
            $stmt->bindParam(':id_empleado', $id, PDO::PARAM_INT);
            $stmt->execute();
            // Obtener el resultado como un objeto
            $empleado = $stmt->fetch(PDO::FETCH_ASSOC);
            $input["empleado"] = $empleado;
        } else {
            $input["empleado"] = null;
        }
        if ($id_grupo2 != null) {
            $id = $id_grupo2;
            $sql = "SELECT * FROM grupos2 where id_grupo2=:id_grupo2";
            $stmt = $dbConn->prepare($sql);
            $stmt->bindParam(':id_grupo2', $id, PDO::PARAM_INT);
            $stmt->execute();
            // Obtener el resultado como un objeto
            $grupo = $stmt->fetch(PDO::FETCH_ASSOC);

            $sql = "SELECT e.*
        FROM empleados e
        INNER JOIN empleado_grupo2 eg ON e.id_empleado = eg.id_empleado
        WHERE eg.id_grupo2 = :id_grupo2";
            $stmt = $dbConn->prepare($sql);
            $stmt->bindParam(':id_grupo2', $id, PDO::PARAM_INT);
            $stmt->execute();
            $empleados = $stmt->fetchAll(PDO::FETCH_OBJ);
            $grupo["empleados"] = $empleados;


            $input["grupo"] = $grupo;
        } else {
            $input["grupo"] = null;
        }




        $input["id_proyecto_empleado"] = $id_proyecto_empleado;
        $input["id_proyecto"] = $id_proyecto;
        $input["id_grupo2"] = $id_grupo2;
        $input["id_empleado"] = $id_empleado;
        $input["fecha_i"] = $fecha_i;
        $input["fecha_f"] = $fecha_f;


        header("HTTP/1.1 200 OK");
        echo json_encode($input);
        exit();
    }
    if (
        isset($_POST["id_proyecto_empleado_archivo"]) && isset($_FILES['archivo']) && isset($_POST['extension'])
        && isset($_POST['nombre'])
    ) {
        $nombre = $_POST["nombre"];
        $extension = $_POST["extension"];
        $id_proyecto_empleado = $_POST["id_proyecto_empleado_archivo"];
        $archivo = $_FILES['archivo'];
        $baseUrl = ($_SERVER['HTTPS'] ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/';
        $rutaArchivoTemporal = isset($_FILES['archivo']) ? $_FILES['archivo']['tmp_name'] : null;
        $Archivo = '../archivos/proyecto_empleado/' . $id_proyecto_empleado . '/' . $nombre . '.' . $extension;
        if (file_exists($Archivo)) {

            header("HTTP/1.1 200 OK");
            echo 0;
            exit();
        } else {
            if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal)) {
                move_uploaded_file($rutaArchivoTemporal, $Archivo);
            }
            header("HTTP/1.1 200 OK");
            exit();
        }
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {
    if (isset($_GET['id'])) {
        $id = $_GET['id'];
        $statement = $dbConn->prepare("DELETE FROM proyecto_empleado where id_proyecto_empleado =:id");
        $statement->bindValue(':id', $id);
        $statement->execute();
        $carpetaEliminar = '../archivos/proyecto_empleado/' . $id;
        eliminarCarpeta($carpetaEliminar);
        header("HTTP/1.1 200 OK");
        echo json_encode($id);
        exit();
    }
    if (isset($_GET["url"])) {
        $url = $_GET['url'];
        $carpetaEliminar = '.' . $url;

        header("HTTP/1.1 200 OK");
        unlink($carpetaEliminar);
        echo $carpetaEliminar;
        exit();
    }
}

//Actualizar
if ($_SERVER['REQUEST_METHOD'] == 'PUT') {
    $input = $_GET;
    $postId = $input['id'];
    $fields = getParams($input);

    $sql = "
          UPDATE posts
          SET $fields
          WHERE id='$postId'
           ";

    $statement = $dbConn->prepare($sql);
    bindAllValues($statement, $input);

    $statement->execute();
    header("HTTP/1.1 200 OK");
    exit();
}
function eliminarCarpeta($rutaCarpeta)
{
    // Obtener una lista de archivos y subcarpetas dentro de la carpeta
    $archivos = glob($rutaCarpeta . '/*');

    // Eliminar cada archivo encontrado
    foreach ($archivos as $archivo) {
        if (is_file($archivo)) {
            unlink($archivo);
        } elseif (is_dir($archivo)) {
            eliminarCarpeta($archivo);
        }
    }

    // Eliminar la carpeta
    if (is_dir($rutaCarpeta)) {
        rmdir($rutaCarpeta);
    }
}
//En caso de que ninguna de las opciones anteriores se haya ejecutado
header("HTTP/1.1 400 Bad Request");