/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.11.11-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: ooswyzyu_centro
-- ------------------------------------------------------
-- Server version	10.11.11-MariaDB-cll-lve

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `acciones`
--

DROP TABLE IF EXISTS `acciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `acciones` (
  `numero_aaff` int(11) NOT NULL,
  `denominacion` varchar(255) DEFAULT NULL,
  `modalidad` varchar(2) DEFAULT NULL,
  `prioridad` varchar(20) DEFAULT NULL,
  `tipo_programa` varchar(50) DEFAULT NULL,
  `horas_totales` int(11) DEFAULT NULL,
  `horas_p` int(11) DEFAULT NULL,
  `costo_por_hora_por_participante` decimal(10,2) DEFAULT NULL,
  `participantes_en_centros` int(11) DEFAULT NULL,
  `costo_centro_af` decimal(10,2) DEFAULT NULL,
  `profesor` int(11) DEFAULT NULL,
  `licencia` decimal(10,2) DEFAULT NULL,
  `total` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`numero_aaff`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acciones`
--

LOCK TABLES `acciones` WRITE;
/*!40000 ALTER TABLE `acciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `acciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actividad`
--

DROP TABLE IF EXISTS `actividad`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `actividad` (
  `id_actividad` int(11) NOT NULL AUTO_INCREMENT,
  `actividad` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `ip` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `user_id` int(11) NOT NULL,
  `fecha` datetime NOT NULL,
  PRIMARY KEY (`id_actividad`),
  KEY `actividad` (`actividad`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actividad`
--

LOCK TABLES `actividad` WRITE;
/*!40000 ALTER TABLE `actividad` DISABLE KEYS */;
/*!40000 ALTER TABLE `actividad` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `administraciones`
--

DROP TABLE IF EXISTS `administraciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `administraciones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `direccion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `cp` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `ciudad` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `provincia` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `tramitador` tinyint(4) DEFAULT 0,
  `contable` tinyint(4) DEFAULT 0,
  `gestor` tinyint(4) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `administraciones`
--

LOCK TABLES `administraciones` WRITE;
/*!40000 ALTER TABLE `administraciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `administraciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `albaranes`
--

DROP TABLE IF EXISTS `albaranes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `albaranes` (
  `id_albaran` int(11) NOT NULL AUTO_INCREMENT,
  `titulo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `id_cliente` int(11) NOT NULL,
  `fecha` datetime NOT NULL,
  `numero` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `condiciones` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `tipo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `estado` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `detallado` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `importe` decimal(9,2) NOT NULL,
  `id_fase` int(11) DEFAULT NULL,
  `id_sector` int(11) DEFAULT NULL,
  `id_obra` int(11) DEFAULT NULL,
  `cif` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `domicilio` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `cp` int(11) DEFAULT NULL,
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `id_usuario` int(11) NOT NULL,
  `importe_final` decimal(9,2) NOT NULL,
  `irpf` decimal(7,2) DEFAULT NULL,
  `nota_interna` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `nota_externa` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `imagen` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `programado` datetime DEFAULT NULL,
  `lugar` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `fechas` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `invoice_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_albaran`),
  KEY `FK_client_id` (`id_cliente`),
  KEY `FK_fase_id` (`id_fase`),
  KEY `FK_sector_id` (`id_sector`),
  KEY `FK_obra_id` (`id_obra`),
  KEY `FK_user_id` (`id_usuario`),
  KEY `invoice_id` (`invoice_id`),
  CONSTRAINT `albaranes_ibfk_1` FOREIGN KEY (`id_cliente`) REFERENCES `clientes` (`client_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `albaranes_ibfk_2` FOREIGN KEY (`id_usuario`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `albaranes_ibfk_3` FOREIGN KEY (`id_fase`) REFERENCES `fases` (`id_fase`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `albaranes_ibfk_4` FOREIGN KEY (`id_obra`) REFERENCES `obras` (`id_obra`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `albaranes_ibfk_5` FOREIGN KEY (`id_sector`) REFERENCES `sectores` (`id_sector`),
  CONSTRAINT `albaranes_ibfk_6` FOREIGN KEY (`invoice_id`) REFERENCES `factura_manual` (`id_factura_manual`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `albaranes`
--

LOCK TABLES `albaranes` WRITE;
/*!40000 ALTER TABLE `albaranes` DISABLE KEYS */;
INSERT INTO `albaranes` VALUES
(6,'Pan día lunes',31,'2025-05-16 22:32:37','2023/A6','DESDE NUESTRAUHDWQDQDVWF','Particular','Aceptado','[{\"codigo\":\"17\",\"cantidad\":\"11 \",\"descripcion\":\"Descripción 19\",\"precio_unitario\":\"13.00\",\"titulo\":null,\"igic\":\"7.00\"},{\"codigo\":\"14\",\"cantidad\":\"11 \",\"descripcion\":\"Descripción 15\",\"precio_unitario\":\"13.00\",\"titulo\":null,\"igic\":\"7.00\"}]',286.00,NULL,NULL,NULL,'45394193J',NULL,35011,'928252167','11@limidata.com',13,306.02,0.00,NULL,NULL,'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2',NULL,NULL,NULL,NULL),
(7,'Pan día lunes',31,'2025-05-16 22:36:44','2023/A7','DESDE NUESTRAUHDWQDQDVWF','Particular','Aceptado','[{\"codigo\":\"19\",\"cantidad\":\"1 \",\"descripcion\":\"sd\",\"precio_unitario\":\"0.00\",\"titulo\":null,\"igic\":\"7.00\"}]',0.00,NULL,NULL,NULL,'45394193J',NULL,35011,'928252167','11@limidata.com',13,0.00,NULL,NULL,NULL,'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2',NULL,NULL,NULL,NULL),
(8,'Pan día lunes',38,'2025-05-16 23:38:22','2023/A8',NULL,'Particular','Aceptado','[{\"codigo\":\"3352\",\"cantidad\":\"1 dfgh\",\"descripcion\":\"Arrticulo 7\",\"precio_unitario\":\"10.00\",\"titulo\":null,\"igic\":\"0.00\"}]',10.00,NULL,NULL,NULL,'37847226','rendon 540',7400,'02284728052','fede.gundel@gmail.com',13,10.00,NULL,NULL,NULL,'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2',NULL,NULL,NULL,NULL),
(9,'erwer',38,'2025-05-20 19:21:15','2023/A9',NULL,'Particular','No enviado','[{\"codigo\":\"3354\",\"cantidad\":\"1 dfgh\",\"descripcion\":\"Arrticulo 7\",\"precio_unitario\":\"10.00\",\"titulo\":null,\"igic\":\"0.00\"},{\"codigo\":\"3353\",\"cantidad\":\"1 dfgh\",\"descripcion\":\"Arrticulo 7\",\"precio_unitario\":\"10.00\",\"titulo\":null,\"igic\":\"0.00\"},{\"codigo\":\"3351\",\"cantidad\":\"1 dfgh\",\"descripcion\":\"Arrticulo 7\",\"precio_unitario\":\"100.00\",\"titulo\":null,\"igic\":\"0.00\"}]',120.00,NULL,NULL,NULL,'37847226','rendon 540',7400,'02284728052','fede.gundel@gmail.com',13,120.00,NULL,NULL,NULL,'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `albaranes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alergeno_alumno`
--

DROP TABLE IF EXISTS `alergeno_alumno`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alergeno_alumno` (
  `id_alergeno_alumno` int(11) NOT NULL AUTO_INCREMENT,
  `id_alergeno` int(11) NOT NULL,
  `id_alumno` int(11) NOT NULL,
  PRIMARY KEY (`id_alergeno_alumno`),
  KEY `id_alergeno` (`id_alergeno`),
  CONSTRAINT `alergeno_alumno_ibfk_1` FOREIGN KEY (`id_alergeno`) REFERENCES `alergenos` (`id_alergeno`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alergeno_alumno`
--

LOCK TABLES `alergeno_alumno` WRITE;
/*!40000 ALTER TABLE `alergeno_alumno` DISABLE KEYS */;
/*!40000 ALTER TABLE `alergeno_alumno` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alergenos`
--

DROP TABLE IF EXISTS `alergenos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alergenos` (
  `id_alergeno` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `icono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  PRIMARY KEY (`id_alergeno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alergenos`
--

LOCK TABLES `alergenos` WRITE;
/*!40000 ALTER TABLE `alergenos` DISABLE KEYS */;
/*!40000 ALTER TABLE `alergenos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `almacenes`
--

DROP TABLE IF EXISTS `almacenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `almacenes` (
  `id_almacen` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_almacen`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `almacenes`
--

LOCK TABLES `almacenes` WRITE;
/*!40000 ALTER TABLE `almacenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `almacenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alumno_curso`
--

DROP TABLE IF EXISTS `alumno_curso`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alumno_curso` (
  `id_alumno_curso` int(11) NOT NULL AUTO_INCREMENT,
  `id_alumno` int(11) NOT NULL,
  `id_curso` int(11) NOT NULL,
  `estado` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT 'Interesado',
  PRIMARY KEY (`id_alumno_curso`),
  KEY `id_alumno` (`id_alumno`),
  KEY `id_curso` (`id_curso`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alumno_curso`
--

LOCK TABLES `alumno_curso` WRITE;
/*!40000 ALTER TABLE `alumno_curso` DISABLE KEYS */;
/*!40000 ALTER TABLE `alumno_curso` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alumnos`
--

DROP TABLE IF EXISTS `alumnos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alumnos` (
  `id_alumno` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `nif` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `niss` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `apellidos` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_nacimiento` date DEFAULT NULL,
  `domicilio` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigo_postal` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `municipio` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discapacitado` tinyint(1) DEFAULT NULL,
  `sexo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estudios` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_incorporacion` date DEFAULT NULL,
  `iban` varchar(34) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `colectivo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `categoria` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `area_funcional` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entidad_trabajo_actual` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `es_pyme` tinyint(1) DEFAULT NULL,
  `sector_convenio` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `razon_social` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cif_empresa` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `num_inscripcion_seguridad_social` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `datos_centro_trabajo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `domicilio_trabajo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigo_postal_trabajo` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `municipio_trabajo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `situacion_laboral` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `programa_prepara` tinyint(1) DEFAULT NULL,
  `programa_activacion` tinyint(1) DEFAULT NULL,
  `oficina_empleo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_demanda` date DEFAULT NULL,
  PRIMARY KEY (`id_alumno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alumnos`
--

LOCK TABLES `alumnos` WRITE;
/*!40000 ALTER TABLE `alumnos` DISABLE KEYS */;
/*!40000 ALTER TABLE `alumnos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anomalia`
--

DROP TABLE IF EXISTS `anomalia`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `anomalia` (
  `id_fichaje` int(11) DEFAULT NULL,
  `anomalia` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `id_miembro` int(11) NOT NULL,
  `id_anomalia` int(11) NOT NULL AUTO_INCREMENT,
  `fecha` datetime NOT NULL,
  `justificacion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_danish_ci DEFAULT NULL,
  PRIMARY KEY (`id_anomalia`),
  KEY `id_miembro` (`id_miembro`),
  KEY `anomalia_ibfk_1` (`id_fichaje`),
  CONSTRAINT `anomalia_ibfk_1` FOREIGN KEY (`id_fichaje`) REFERENCES `fichajes` (`id_fichaje`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=309 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anomalia`
--

LOCK TABLES `anomalia` WRITE;
/*!40000 ALTER TABLE `anomalia` DISABLE KEYS */;
INSERT INTO `anomalia` VALUES
(194,'Entrada marcada pasados 10 minutos del horario de entrada. Hora prevista: 14:00:00, hora registrada: 17:46:04.',44,304,'2025-05-20 21:48:40',NULL),
(194,'Entrada marcada demasiado lejos de la dirección de trabajo',44,305,'2025-05-20 21:48:40',NULL),
(194,'Salida registrada antes del horario previsto del segundo turno. Hora prevista: 20:00:00, hora registrada: 17:46:14.',44,306,'2025-05-20 21:48:51',NULL),
(195,'Entrada marcada pasados 10 minutos del horario de entrada. Hora prevista: 14:00:00, hora registrada: 19:57:22.',44,307,'2025-05-20 23:59:59',NULL),
(195,'Entrada marcada demasiado lejos de la dirección de trabajo',44,308,'2025-05-20 23:59:59',NULL);
/*!40000 ALTER TABLE `anomalia` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `apartado_factura_manual`
--

DROP TABLE IF EXISTS `apartado_factura_manual`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `apartado_factura_manual` (
  `id_apartado_factura_manual` int(11) NOT NULL AUTO_INCREMENT,
  `cantidad` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `titulo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `descripcion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `precio_unitario` decimal(9,2) NOT NULL,
  `id_factura_manual` int(11) NOT NULL,
  `id_medida` int(11) NOT NULL,
  `codigo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `igic` decimal(10,2) DEFAULT NULL,
  `id_albaran` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_apartado_factura_manual`),
  KEY `id_factura_manual` (`id_factura_manual`),
  KEY `id_medida` (`id_medida`),
  KEY `id_albaran` (`id_albaran`),
  CONSTRAINT `apartado_factura_manual_ibfk_1` FOREIGN KEY (`id_factura_manual`) REFERENCES `factura_manual` (`id_factura_manual`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `apartado_factura_manual_ibfk_2` FOREIGN KEY (`id_albaran`) REFERENCES `albaranes` (`id_albaran`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=113 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `apartado_factura_manual`
--

LOCK TABLES `apartado_factura_manual` WRITE;
/*!40000 ALTER TABLE `apartado_factura_manual` DISABLE KEYS */;
INSERT INTO `apartado_factura_manual` VALUES
(102,'11 ',NULL,'Descripción 19',13.00,79,0,'17',21.00,NULL),
(103,'1','Ticket de compra','',32.00,80,0,'23',7.00,NULL),
(104,'1 ',NULL,'sd',0.00,81,0,'19',0.00,NULL),
(106,'11 ',NULL,'Descripción 19',13.00,83,0,'17',0.00,NULL),
(107,'11 ','3333','Descripción 20',13.00,84,0,'18',0.00,NULL),
(108,'1 dfgh','Arrticulo 7','Arrticulo 7',10.00,86,0,'3350',0.00,NULL),
(109,'1 dfgh','Arrticulo 7','Arrticulo 7',10.00,86,0,'3351',0.00,NULL),
(110,'1 dfgh','Arrticulo 7','Arrticulo 7',10.00,86,0,'3352',0.00,NULL),
(111,'1 dfgh','Arrticulo 7','Arrticulo 7',10.00,86,0,'3353',0.00,NULL),
(112,'1 dfgh','Arrticulo 7','Arrticulo 7',10.00,86,0,'3354',0.00,NULL);
/*!40000 ALTER TABLE `apartado_factura_manual` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `apartado_factura_rectificada`
--

DROP TABLE IF EXISTS `apartado_factura_rectificada`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `apartado_factura_rectificada` (
  `id_apartado_factura_rectificada` int(11) NOT NULL AUTO_INCREMENT,
  `cantidad` varchar(255) DEFAULT NULL,
  `titulo` varchar(255) DEFAULT NULL,
  `descripcion` varchar(10000) DEFAULT NULL,
  `precio_unitario` decimal(9,2) DEFAULT NULL,
  `igic` decimal(9,2) DEFAULT NULL,
  `id_factura_rectificada` int(11) DEFAULT NULL,
  `id_apartado_factura_manual` int(11) NOT NULL,
  PRIMARY KEY (`id_apartado_factura_rectificada`),
  KEY `apartado_factura_rectificada_ibfk_1` (`id_factura_rectificada`),
  KEY `id_apartado_factura_manual` (`id_apartado_factura_manual`),
  CONSTRAINT `apartado_factura_rectificada_ibfk_1` FOREIGN KEY (`id_factura_rectificada`) REFERENCES `facturas_rectificadas` (`id_factura_rectificada`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `apartado_factura_rectificada_ibfk_2` FOREIGN KEY (`id_apartado_factura_manual`) REFERENCES `apartado_factura_manual` (`id_apartado_factura_manual`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `apartado_factura_rectificada`
--

LOCK TABLES `apartado_factura_rectificada` WRITE;
/*!40000 ALTER TABLE `apartado_factura_rectificada` DISABLE KEYS */;
INSERT INTO `apartado_factura_rectificada` VALUES
(8,'11 ',NULL,'Descripción 19',12.00,0.00,6,106),
(9,'1 dfgh','Arrticulo 7','Arrticulo 7',10.00,0.00,7,108),
(10,'1 dfgh','Arrticulo 7','Arrticulo 7',10.00,0.00,7,109),
(11,'1 dfgh','Arrticulo 7','Arrticulo 7',2.00,0.00,7,110),
(12,'1 dfgh','Arrticulo 7','Arrticulo 7',2.00,0.00,7,111),
(13,'1 dfgh','Arrticulo 7','Arrticulo 7',10.00,0.00,7,112);
/*!40000 ALTER TABLE `apartado_factura_rectificada` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `apartados`
--

DROP TABLE IF EXISTS `apartados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `apartados` (
  `apartado_id` int(11) NOT NULL AUTO_INCREMENT,
  `titulo` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `descripcion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `cantidad` int(11) NOT NULL,
  `precio_unitario` decimal(9,2) NOT NULL,
  `fecha` date NOT NULL DEFAULT current_timestamp(),
  `id_medida` int(11) DEFAULT NULL,
  `codigo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `precio_coste` double(10,2) DEFAULT NULL,
  `id_ubicacion` int(11) DEFAULT NULL,
  `ean` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `id_familia` int(11) DEFAULT NULL,
  `id_subfamilia` int(11) DEFAULT NULL,
  `id_igic` int(11) DEFAULT NULL,
  `fecha_caducidad` date DEFAULT NULL,
  `numero_lote` varchar(15) DEFAULT NULL,
  `stock` int(255) NOT NULL DEFAULT 0,
  PRIMARY KEY (`apartado_id`),
  UNIQUE KEY `codigo_unico` (`codigo`),
  KEY `id_medida` (`id_medida`),
  KEY `fk_apartados_ubicaciones` (`id_ubicacion`),
  KEY `fk_apartados_familias` (`id_familia`),
  KEY `fk_apartados_subfamilias` (`id_subfamilia`),
  KEY `id_igic` (`id_igic`),
  CONSTRAINT `apartados_ibfk_1` FOREIGN KEY (`id_medida`) REFERENCES `medidas` (`id_medida`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `apartados_ibfk_2` FOREIGN KEY (`id_igic`) REFERENCES `igic` (`id_igic`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `fk_apartados_familias` FOREIGN KEY (`id_familia`) REFERENCES `familias` (`id_familia`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `fk_apartados_subfamilias` FOREIGN KEY (`id_subfamilia`) REFERENCES `subfamilias` (`id_subfamilia`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `fk_apartados_ubicaciones` FOREIGN KEY (`id_ubicacion`) REFERENCES `ubicaciones` (`id_ubicacion`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `apartados`
--

LOCK TABLES `apartados` WRITE;
/*!40000 ALTER TABLE `apartados` DISABLE KEYS */;
INSERT INTO `apartados` VALUES
(31,'Artículo 11','Descripción 1',1,200.00,'2025-04-18',NULL,'1',200.00,NULL,'1',NULL,NULL,NULL,NULL,'1112',10),
(32,'Artículo 21','Descripción 2',1,0.00,'2025-04-18',NULL,'2',100.00,NULL,'2',NULL,NULL,NULL,NULL,'123',2147483647),
(33,'Artículo 31','Descripción 3',1,10.00,'2025-04-18',NULL,'3',10.00,NULL,'3',NULL,NULL,NULL,NULL,'3213',100000),
(34,'Artículo 41','Descripción 4',1,13.00,'2025-04-18',NULL,'4',9.00,NULL,'4',NULL,NULL,NULL,NULL,'3123',0),
(35,'Artículo 5','Descripción 5',1,13.00,'2025-04-18',NULL,'5',9.00,NULL,'4',NULL,NULL,NULL,NULL,'3123',0),
(36,'Artículo 6','Descripción 6',1,13.00,'2025-04-18',NULL,'6',9.00,NULL,'4',NULL,NULL,NULL,NULL,'3123',0),
(37,'Arrticulo 7','Arrticulo 7',1,10.00,'2025-04-18',1,'7',0.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100000),
(38,'Arrticulo 7','Arrticulo 7',1,10.00,'2025-04-18',1,'8',0.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100000),
(39,'Arrticulo 7','Arrticulo 7',1,10.00,'2025-04-18',1,'9',0.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100000),
(40,'Arrticulo 17','Arrticulo 17',1,10.00,'2025-04-18',1,'10',0.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100000),
(41,'asdfasdf','sdfasdf',1,10.00,'2025-04-18',NULL,'11',0.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100000),
(42,'ertw','ertwert',2,20.00,'2025-04-18',NULL,'12',0.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100000),
(43,'wertwer','sdfgws',2,20.00,'2025-04-18',NULL,'13',0.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100000),
(44,'Artículo 15','Descripción 15',11,13.00,'2025-04-18',NULL,'14',0.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100000),
(45,'nuevo','nuevo',1,10.00,'2025-04-18',NULL,'15',0.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100000),
(46,'Artículo 18','Descripción 18',11,13.00,'2025-04-18',NULL,'16',0.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100000),
(47,'Artículo 19','Descripción 19',11,13.00,'2025-04-27',NULL,'17',0.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100000),
(48,'3333','Descripción 20',11,13.00,'2025-04-27',NULL,'18',0.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100000),
(49,'sd','sd',1,0.00,'2025-05-13',NULL,'19',0.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100000),
(50,'Masaje','Masajes',1,12.00,'2025-05-16',NULL,'44',12.00,NULL,NULL,NULL,NULL,1,NULL,NULL,0),
(51,'Maderitas 10','Esto es pura madera',2,1.00,'2025-05-16',NULL,'3339',1.00,NULL,'1',NULL,NULL,NULL,NULL,'1',0),
(52,'Maderitas 20','Esto es pura madera',2,1.00,'2025-05-16',NULL,'3340',1.00,NULL,'1',NULL,NULL,NULL,NULL,'1',0),
(53,'Maderitas 3','Esto es pura madera',2,1.00,'2025-05-16',NULL,'3341',1.00,NULL,'1',NULL,NULL,NULL,NULL,'1',0),
(54,'Maderitas 4','Esto es pura madera',2,1.00,'2025-05-16',NULL,'3342',1.00,NULL,'1',NULL,NULL,NULL,NULL,'1',0),
(55,'Maderitas 5','Esto es pura madera',2,1.00,'2025-05-16',NULL,'3343',1.00,NULL,'1',NULL,NULL,NULL,NULL,'1',0),
(56,'Maderitas 6','Esto es pura madera',2,1.00,'2025-05-16',NULL,'3344',1.00,NULL,'1',NULL,NULL,NULL,NULL,'1',0),
(57,'Maderitas 7','Esto es pura madera',2,1.00,'2025-05-16',NULL,'3345',1.00,NULL,'1',NULL,NULL,NULL,NULL,'1',0),
(58,'Maderitas 8','Esto es pura madera',2,1.00,'2025-05-16',NULL,'3346',1.00,NULL,'1',NULL,NULL,NULL,NULL,'1',0),
(59,'Maderitas 9','Esto es pura madera',2,1.00,'2025-05-16',NULL,'3347',1.00,NULL,'1',NULL,NULL,NULL,NULL,'1',0),
(60,'Maderitas 10','Esto es pura madera',2,1.00,'2025-05-16',NULL,'3348',1.00,NULL,'1',NULL,NULL,NULL,NULL,'1',0),
(61,'Maderitas 11','Esto es pura madera',2,1.00,'2025-05-16',NULL,'3349',1.00,NULL,'1',NULL,NULL,NULL,NULL,'1',0),
(62,'Arrticulo 7','Arrticulo 7',1,10.00,'2025-05-16',1,'3350',0.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100000),
(63,'Arrticulo 7','Arrticulo 7',1,10.00,'2025-05-16',1,'3351',0.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100000),
(64,'Arrticulo 7','Arrticulo 7',1,10.00,'2025-05-16',1,'3352',0.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100000),
(65,'Arrticulo 7','Arrticulo 7',1,10.00,'2025-05-16',1,'3353',0.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100000),
(66,'Arrticulo 7','Arrticulo 7',1,10.00,'2025-05-16',1,'3354',0.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100000);
/*!40000 ALTER TABLE `apartados` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER before_insert_apartados
BEFORE INSERT ON apartados
FOR EACH ROW
BEGIN
    IF NEW.codigo IS NULL OR NEW.codigo = '' THEN
        SET NEW.codigo = (
            SELECT IFNULL(MAX(CAST(codigo AS UNSIGNED)), 0) + 1 FROM apartados
        );
    END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `archivos`
--

DROP TABLE IF EXISTS `archivos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `archivos` (
  `id_archivo` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `url` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `fecha` timestamp NOT NULL DEFAULT current_timestamp(),
  `tipo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `carpeta_id` int(11) DEFAULT NULL,
  `extension` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  PRIMARY KEY (`id_archivo`),
  KEY `id_carpeta` (`carpeta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `archivos`
--

LOCK TABLES `archivos` WRITE;
/*!40000 ALTER TABLE `archivos` DISABLE KEYS */;
/*!40000 ALTER TABLE `archivos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `articulos`
--

DROP TABLE IF EXISTS `articulos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `articulos` (
  `id_articulo` int(11) NOT NULL AUTO_INCREMENT,
  `titulo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `descripcion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `precio_unitario` decimal(10,2) DEFAULT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT 1,
  `descuento` decimal(10,2) DEFAULT NULL,
  `stock` int(11) DEFAULT NULL,
  `ean` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `codigo_proveedor` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `precio_coste` decimal(10,2) DEFAULT NULL,
  `id_marca` int(11) DEFAULT NULL,
  `id_familia` int(11) DEFAULT NULL,
  `id_subfamilia` int(11) DEFAULT NULL,
  `uds_caja` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `campo_1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `campo_2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `campo_3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `campo_4` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `igic` decimal(9,2) DEFAULT NULL,
  `codigo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `id_ubicacion` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_articulo`),
  KEY `articulos_ibfk_1` (`id_marca`),
  KEY `articulos_ibfk_2` (`id_familia`),
  KEY `articulos_ibfk_3` (`id_subfamilia`),
  KEY `fk_ubicacion` (`id_ubicacion`),
  CONSTRAINT `articulos_ibfk_1` FOREIGN KEY (`id_marca`) REFERENCES `marcas` (`id_marca`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `articulos_ibfk_2` FOREIGN KEY (`id_familia`) REFERENCES `familias` (`id_familia`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `articulos_ibfk_3` FOREIGN KEY (`id_subfamilia`) REFERENCES `subfamilias` (`id_subfamilia`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `fk_ubicacion` FOREIGN KEY (`id_ubicacion`) REFERENCES `ubicaciones` (`id_ubicacion`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `articulos`
--

LOCK TABLES `articulos` WRITE;
/*!40000 ALTER TABLE `articulos` DISABLE KEYS */;
/*!40000 ALTER TABLE `articulos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `id_backup` int(11) NOT NULL AUTO_INCREMENT,
  `fecha` date NOT NULL,
  PRIMARY KEY (`id_backup`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` VALUES
(2,'2025-04-03'),
(3,'2025-04-03'),
(4,'2025-05-08'),
(5,'2025-05-08'),
(6,'2025-05-10'),
(7,'2025-05-16');
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `baldas`
--

DROP TABLE IF EXISTS `baldas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `baldas` (
  `id_balda` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_balda`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `baldas`
--

LOCK TABLES `baldas` WRITE;
/*!40000 ALTER TABLE `baldas` DISABLE KEYS */;
/*!40000 ALTER TABLE `baldas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bancos`
--

DROP TABLE IF EXISTS `bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `bancos` (
  `id_banco` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `direccion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `iban` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `beneficiario` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `divisa` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `swift` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  PRIMARY KEY (`id_banco`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bancos`
--

LOCK TABLES `bancos` WRITE;
/*!40000 ALTER TABLE `bancos` DISABLE KEYS */;
INSERT INTO `bancos` VALUES
(4,'BBVA','Alcalde Jose Ramirez Bethencourt n13','ES6801820769920201671575','1','(€) Euro','BBVAXXXXX'),
(5,'SANTANDER',NULL,NULL,NULL,'(€) Euro',NULL);
/*!40000 ALTER TABLE `bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `carpetas`
--

DROP TABLE IF EXISTS `carpetas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `carpetas` (
  `id_carpeta` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `carpeta_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_carpeta`),
  KEY `carpeta_id` (`carpeta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `carpetas`
--

LOCK TABLES `carpetas` WRITE;
/*!40000 ALTER TABLE `carpetas` DISABLE KEYS */;
/*!40000 ALTER TABLE `carpetas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categoria`
--

DROP TABLE IF EXISTS `categoria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categoria` (
  `id_categoria` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_categoria`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categoria`
--

LOCK TABLES `categoria` WRITE;
/*!40000 ALTER TABLE `categoria` DISABLE KEYS */;
INSERT INTO `categoria` VALUES
(1,'Fiestas');
/*!40000 ALTER TABLE `categoria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cliente_subvencion`
--

DROP TABLE IF EXISTS `cliente_subvencion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cliente_subvencion` (
  `id_cliente_subvencion` int(11) NOT NULL AUTO_INCREMENT,
  `id_cliente` int(11) NOT NULL,
  `id_subvencion` int(11) NOT NULL,
  `fecha_envio` datetime DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `estado` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `email_marketing` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `id_estado_subvencion` int(11) DEFAULT NULL,
  `tag` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL,
  `url_portada` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `condiciones` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_cliente_subvencion`),
  KEY `id_cliente` (`id_cliente`),
  KEY `id_subvencion` (`id_subvencion`),
  KEY `id_estado_subvencion` (`id_estado_subvencion`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cliente_subvencion`
--

LOCK TABLES `cliente_subvencion` WRITE;
/*!40000 ALTER TABLE `cliente_subvencion` DISABLE KEYS */;
/*!40000 ALTER TABLE `cliente_subvencion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clientes`
--

DROP TABLE IF EXISTS `clientes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clientes` (
  `client_id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `direccion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `cp` int(11) DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL,
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `cif` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `estado` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT 'Potencial',
  `imagen` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT 'assets/images/clientes/user-default.png',
  `email_marketing` tinyint(1) NOT NULL DEFAULT 0,
  `subvencionado` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT 'No',
  `fecha_nacimiento` date DEFAULT NULL,
  `sms_habilitado` tinyint(1) NOT NULL DEFAULT 0,
  `felicitado` tinyint(1) NOT NULL DEFAULT 0,
  `peluqueria` varchar(255) NOT NULL DEFAULT 'No',
  `tipo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT 'Particular',
  `sexo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT 'Otro',
  `emails` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `descuento` decimal(10,2) DEFAULT 0.00,
  `codigo` int(11) DEFAULT NULL,
  `id_sector` int(11) DEFAULT NULL,
  `linkedin` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `instagram` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tiktok` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `x` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facebook` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `forma_juridica` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nombre_juridico` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cif_juridico` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `domicilio_fiscal` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `activo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT 'Activo',
  `codigo_tramitador` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `codigo_gestor` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `codigo_contable` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `web` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `terminos` tinyint(1) NOT NULL DEFAULT 0,
  `movil` varchar(20) DEFAULT NULL,
  `id_poblacion` int(11) DEFAULT NULL,
  PRIMARY KEY (`client_id`),
  KEY `FK_user_id` (`user_id`) USING BTREE,
  KEY `id_poblacion` (`id_poblacion`),
  CONSTRAINT `clientes_ibfk_1` FOREIGN KEY (`id_poblacion`) REFERENCES `poblaciones` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clientes`
--

LOCK TABLES `clientes` WRITE;
/*!40000 ALTER TABLE `clientes` DISABLE KEYS */;
INSERT INTO `clientes` VALUES
(31,'Paco Sanz 1',NULL,35011,'11@limidata.com','928252167','45394193J','2025-05-08',6707,'Potencial','assets/images/clientes/user-default.png',0,'No',NULL,0,0,'No','Particular','Hombre',NULL,0.00,1,NULL,'jvs','IG','Tiktok','X','FB',NULL,NULL,NULL,NULL,'Activo',NULL,NULL,NULL,'https://limidata.com',1,'34739988922',NULL),
(37,'Andres Gracida','Alcalde Jose Ramirez Bethencourt n13',NULL,'llruben_gm@hotmail.com','34634674501','Y1255741R','2025-05-01',13,'Potencial','assets/images/clientes/user-default.png',0,'No',NULL,0,0,'No','Particular','Hombre',NULL,0.00,35017,NULL,NULL,NULL,NULL,NULL,NULL,'Autónomo',NULL,NULL,NULL,'Activo',NULL,NULL,NULL,NULL,1,'34634674501',6),
(38,'Federico Gundel','rendon 540',7400,'fede.gundel@gmail.com','02284728052','37847226','2025-05-08',6707,'Potencial','assets/images/clientes/user-default.png',0,'No','2025-09-06',0,0,'No','Particular','Hombre','fede.gundel@gmail.com',0.00,7400,NULL,NULL,NULL,NULL,NULL,NULL,'Autónomo',NULL,NULL,NULL,'Activo',NULL,NULL,NULL,NULL,1,'34689094468',1),
(40,'Cliente de prueba ','Calle Alejandro Hidalgo, 3',35200,'roberlp6@gmail.com','634827935','555555555P','2025-05-16',6736,'Potencial','assets/images/clientes/user-default.png',0,'No',NULL,0,0,'No','Particular','Hombre',NULL,0.00,456,2,NULL,NULL,NULL,NULL,NULL,'Autónomo',NULL,NULL,NULL,'Activo',NULL,NULL,NULL,NULL,1,'34634827935',NULL);
/*!40000 ALTER TABLE `clientes` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`ooswyzyu_federico`@`localhost`*/ /*!50003 TRIGGER before_insert_clientes 
BEFORE INSERT ON clientes 
FOR EACH ROW 
BEGIN 
  IF NEW.codigo IS NULL OR NEW.codigo = '' THEN
    SET NEW.codigo = (
      SELECT IFNULL(MAX(CAST(codigo AS UNSIGNED)), 0) + 1 FROM clientes
    );
  END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `cnae`
--

DROP TABLE IF EXISTS `cnae`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cnae` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(20) DEFAULT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cnae`
--

LOCK TABLES `cnae` WRITE;
/*!40000 ALTER TABLE `cnae` DISABLE KEYS */;
/*!40000 ALTER TABLE `cnae` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columnas`
--

DROP TABLE IF EXISTS `columnas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columnas` (
  `id_columna` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_columna`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columnas`
--

LOCK TABLES `columnas` WRITE;
/*!40000 ALTER TABLE `columnas` DISABLE KEYS */;
/*!40000 ALTER TABLE `columnas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `combustibles`
--

DROP TABLE IF EXISTS `combustibles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `combustibles` (
  `id_combustible` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id_combustible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `combustibles`
--

LOCK TABLES `combustibles` WRITE;
/*!40000 ALTER TABLE `combustibles` DISABLE KEYS */;
/*!40000 ALTER TABLE `combustibles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `compras`
--

DROP TABLE IF EXISTS `compras`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `compras` (
  `id_compra` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `detallado` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`detallado`)),
  `igic` decimal(7,2) NOT NULL,
  `importe` decimal(9,2) NOT NULL,
  `tipo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `importe_final` decimal(9,2) NOT NULL,
  `fecha` datetime NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `invoice_id` int(11) DEFAULT NULL,
  `numero` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '1',
  PRIMARY KEY (`id_compra`),
  KEY `client_id` (`client_id`),
  KEY `user_id` (`user_id`),
  KEY `invoice_id` (`invoice_id`),
  CONSTRAINT `compras_ibfk_1` FOREIGN KEY (`client_id`) REFERENCES `clientes` (`client_id`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `compras_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `compras_ibfk_3` FOREIGN KEY (`invoice_id`) REFERENCES `factura_manual` (`id_factura_manual`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `compras`
--

LOCK TABLES `compras` WRITE;
/*!40000 ALTER TABLE `compras` DISABLE KEYS */;
INSERT INTO `compras` VALUES
(23,NULL,'[{\"tipo\":\"Servicio\",\"nombre\":\"Mantenimiento\",\"cantidad\":\"1\",\"precio_unitario\":\"32.00\",\"total\":\"32.00\"}]',0.07,32.00,'Efectivo',34.24,'2025-05-15 20:33:01',13,80,'2025/A40');
/*!40000 ALTER TABLE `compras` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones`
--

DROP TABLE IF EXISTS `condiciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `condiciones` (
  `id_condicion` int(11) NOT NULL AUTO_INCREMENT,
  `condicion` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `titulo` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  PRIMARY KEY (`id_condicion`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones`
--

LOCK TABLES `condiciones` WRITE;
/*!40000 ALTER TABLE `condiciones` DISABLE KEYS */;
INSERT INTO `condiciones` VALUES
(3,'DESDE NUESTRAUHDWQDQDVWF','NO NOS HACEMOS CARGO '),
(4,'NUESTRA EMPRES ANO SEIOEÑ','AVISO LEGAL ');
/*!40000 ALTER TABLE `condiciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contratos`
--

DROP TABLE IF EXISTS `contratos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `contratos` (
  `id_contrato` int(11) NOT NULL AUTO_INCREMENT,
  `id_empleado` int(11) DEFAULT NULL,
  `tipo_contrato` varchar(25) DEFAULT NULL,
  `fecha_inicio` date DEFAULT NULL,
  `fecha_fin` date DEFAULT NULL,
  `salario_base` decimal(10,2) DEFAULT NULL,
  `horas_semanales` int(11) DEFAULT NULL,
  `dias_laborales` varchar(20) DEFAULT NULL,
  `horario_entrada` time DEFAULT NULL,
  `horario_salida` time DEFAULT NULL,
  `estado` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id_contrato`),
  KEY `id_empleado` (`id_empleado`),
  CONSTRAINT `contratos_ibfk_1` FOREIGN KEY (`id_empleado`) REFERENCES `empleado` (`id_empleado`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contratos`
--

LOCK TABLES `contratos` WRITE;
/*!40000 ALTER TABLE `contratos` DISABLE KEYS */;
/*!40000 ALTER TABLE `contratos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `convenios`
--

DROP TABLE IF EXISTS `convenios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `convenios` (
  `id_convenio` int(20) NOT NULL AUTO_INCREMENT,
  `id_sector` int(11) DEFAULT NULL,
  `denominacion` varchar(255) DEFAULT NULL,
  `ambito` varchar(255) DEFAULT NULL,
  `codigo` bigint(255) NOT NULL,
  PRIMARY KEY (`id_convenio`),
  KEY `id_sector` (`id_sector`),
  CONSTRAINT `convenios_ibfk_1` FOREIGN KEY (`id_sector`) REFERENCES `sectors` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `convenios`
--

LOCK TABLES `convenios` WRITE;
/*!40000 ALTER TABLE `convenios` DISABLE KEYS */;
/*!40000 ALTER TABLE `convenios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `copia_seguridad`
--

DROP TABLE IF EXISTS `copia_seguridad`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `copia_seguridad` (
  `id_copia_seguridad` int(11) NOT NULL AUTO_INCREMENT,
  `fecha` datetime NOT NULL,
  PRIMARY KEY (`id_copia_seguridad`)
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `copia_seguridad`
--

LOCK TABLES `copia_seguridad` WRITE;
/*!40000 ALTER TABLE `copia_seguridad` DISABLE KEYS */;
INSERT INTO `copia_seguridad` VALUES
(1,'2025-01-15 00:00:00'),
(2,'2025-01-15 00:00:00'),
(3,'2025-01-15 00:00:00'),
(4,'2025-01-16 11:35:00'),
(5,'2025-01-16 11:36:00'),
(6,'2025-01-16 11:37:00'),
(7,'2025-01-19 12:30:00'),
(8,'2025-01-16 11:41:00'),
(9,'2025-01-16 11:42:00'),
(10,'2025-01-16 11:43:00'),
(11,'2025-01-16 11:44:00'),
(12,'2025-01-16 11:45:00'),
(13,'2025-01-16 11:45:00'),
(14,'2025-01-16 11:46:00'),
(15,'2025-01-16 11:47:00'),
(16,'2025-01-16 11:48:00'),
(17,'2025-01-16 11:49:00'),
(18,'2025-01-16 11:50:00'),
(19,'2025-01-16 11:51:00'),
(20,'2025-01-16 11:52:00'),
(21,'2025-01-16 11:53:00'),
(22,'2025-01-16 11:54:00'),
(23,'2025-01-16 11:55:00'),
(24,'2025-01-16 11:56:00'),
(25,'2025-01-16 11:57:00'),
(26,'2025-01-16 11:58:00'),
(27,'2025-01-16 11:59:00'),
(28,'2025-01-16 12:00:00'),
(29,'2025-01-16 12:01:00'),
(30,'2025-01-16 12:02:00'),
(31,'2025-01-16 12:03:00'),
(32,'2025-01-16 12:04:00'),
(33,'2025-01-16 12:05:00'),
(34,'2025-01-16 12:06:00'),
(35,'2025-01-16 12:07:00'),
(36,'2025-01-16 12:08:00'),
(37,'2025-01-16 12:09:00'),
(38,'2025-01-16 12:10:00'),
(39,'2025-01-16 12:11:00'),
(40,'2025-01-16 12:12:00'),
(41,'2025-01-16 12:13:00'),
(42,'2025-01-16 12:14:00'),
(43,'2025-01-16 12:15:00'),
(44,'2025-01-16 12:16:00'),
(45,'2025-01-16 12:17:00'),
(46,'2025-01-16 12:18:00'),
(47,'2025-01-16 12:19:00'),
(48,'2025-01-16 12:20:00'),
(49,'2025-01-16 12:21:00'),
(50,'2025-01-16 12:22:00'),
(51,'2025-01-16 12:23:00'),
(52,'2025-01-16 12:24:00'),
(53,'2025-01-16 12:25:00'),
(54,'2025-01-16 12:26:00'),
(55,'2025-01-16 12:27:00'),
(56,'2025-01-16 12:28:00'),
(57,'2025-01-16 12:29:00'),
(58,'2025-01-16 12:30:00'),
(59,'2025-01-16 12:31:00'),
(60,'2025-01-16 12:32:00'),
(61,'2025-01-16 12:33:00'),
(62,'2025-01-16 12:34:00'),
(63,'2025-01-16 12:35:00'),
(64,'2025-01-16 12:36:00'),
(65,'2025-01-16 12:37:00'),
(66,'2025-01-16 12:38:00'),
(67,'2025-01-16 12:39:00'),
(68,'2025-01-16 12:40:00'),
(69,'2025-01-16 12:41:00'),
(70,'2025-01-16 12:42:00'),
(71,'2025-01-16 12:43:00'),
(72,'2025-01-16 12:44:00'),
(73,'2025-01-16 12:45:00'),
(74,'2025-01-16 12:46:00'),
(75,'2025-01-16 12:47:00'),
(76,'2025-01-16 12:48:00'),
(77,'2025-01-16 12:49:00'),
(78,'2025-01-16 12:50:00'),
(79,'2025-01-16 12:51:00'),
(80,'2025-01-16 12:52:00'),
(81,'2025-01-16 12:53:00'),
(82,'2025-01-16 12:54:00'),
(83,'2025-01-16 12:55:00'),
(84,'2025-01-16 12:56:00'),
(85,'2025-01-16 12:57:00'),
(86,'2025-01-16 12:58:00'),
(87,'2025-01-16 12:59:00'),
(88,'2025-01-16 13:00:00'),
(89,'2025-01-16 13:01:00');
/*!40000 ALTER TABLE `copia_seguridad` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `coverpage`
--

DROP TABLE IF EXISTS `coverpage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `coverpage` (
  `coverpage_id` int(11) NOT NULL AUTO_INCREMENT,
  `coverpage_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `coverpage_url` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  PRIMARY KEY (`coverpage_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `coverpage`
--

LOCK TABLES `coverpage` WRITE;
/*!40000 ALTER TABLE `coverpage` DISABLE KEYS */;
/*!40000 ALTER TABLE `coverpage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos`
--

DROP TABLE IF EXISTS `cursos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cursos` (
  `id_curso` int(11) NOT NULL AUTO_INCREMENT,
  `numero_aaff` int(11) NOT NULL,
  `numero_grupo` int(11) DEFAULT NULL,
  `numero_plaza` int(11) DEFAULT NULL,
  `certificado` tinyint(1) DEFAULT NULL,
  `instalacion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `sede` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `modalidad` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `fecha_i` date DEFAULT NULL,
  `fecha_f` date DEFAULT NULL,
  `horario` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `estado` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `id_plan` int(11) DEFAULT NULL,
  `nivel_estudios` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `id_docente` int(11) DEFAULT NULL,
  `nombre_curso` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  PRIMARY KEY (`id_curso`),
  KEY `id_plan` (`id_plan`),
  KEY `id_docente` (`id_docente`),
  KEY `numero_aaff` (`numero_aaff`),
  CONSTRAINT `cursos_ibfk_2` FOREIGN KEY (`id_plan`) REFERENCES `planes` (`id_plan`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `cursos_ibfk_3` FOREIGN KEY (`id_docente`) REFERENCES `docentes` (`id_docente`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `cursos_ibfk_4` FOREIGN KEY (`numero_aaff`) REFERENCES `acciones` (`numero_aaff`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos`
--

LOCK TABLES `cursos` WRITE;
/*!40000 ALTER TABLE `cursos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `datos_cliente`
--

DROP TABLE IF EXISTS `datos_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `datos_cliente` (
  `cp` int(11) NOT NULL,
  `telefono` int(11) NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `nombre_comercial` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `id_sector` int(11) DEFAULT NULL,
  `id_fase` int(11) DEFAULT NULL,
  `id_zona` int(11) DEFAULT NULL,
  `tipo` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `numero_empleados` int(11) NOT NULL,
  `importe` int(11) NOT NULL,
  `tipo_enlace` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `user_id` int(11) NOT NULL,
  `id_cliente_subvencion` int(11) NOT NULL,
  `cif` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `id_datos_cliente` int(11) NOT NULL AUTO_INCREMENT,
  `domicilio` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `titulo` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  PRIMARY KEY (`id_datos_cliente`),
  KEY `id_sector` (`id_sector`),
  KEY `id_fase` (`id_fase`),
  KEY `id_zona` (`id_zona`),
  KEY `user_id` (`user_id`),
  KEY `id_cliente_subvencion` (`id_cliente_subvencion`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `datos_cliente`
--

LOCK TABLES `datos_cliente` WRITE;
/*!40000 ALTER TABLE `datos_cliente` DISABLE KEYS */;
/*!40000 ALTER TABLE `datos_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `datos_cliente_peluqueria`
--

DROP TABLE IF EXISTS `datos_cliente_peluqueria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `datos_cliente_peluqueria` (
  `id_datos_cliente_peluqueria` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `id_sector` int(11) DEFAULT NULL,
  `id_tipo_pelo` int(11) DEFAULT NULL,
  `id_fase` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `fotos` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_datos_cliente_peluqueria`),
  KEY `client_id` (`client_id`),
  KEY `id_sector` (`id_sector`),
  KEY `id_tipo_pelo` (`id_tipo_pelo`),
  KEY `id_fase` (`id_fase`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `datos_cliente_peluqueria`
--

LOCK TABLES `datos_cliente_peluqueria` WRITE;
/*!40000 ALTER TABLE `datos_cliente_peluqueria` DISABLE KEYS */;
/*!40000 ALTER TABLE `datos_cliente_peluqueria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `docentes`
--

DROP TABLE IF EXISTS `docentes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `docentes` (
  `id_docente` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `dni` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `fecha_alta` date DEFAULT NULL,
  `fecha_baja` date DEFAULT NULL,
  PRIMARY KEY (`id_docente`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `docentes`
--

LOCK TABLES `docentes` WRITE;
/*!40000 ALTER TABLE `docentes` DISABLE KEYS */;
/*!40000 ALTER TABLE `docentes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_custom`
--

DROP TABLE IF EXISTS `email_custom`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_custom` (
  `id_email_custom` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `asunto` varchar(255) NOT NULL,
  `cuerpo` text NOT NULL,
  PRIMARY KEY (`id_email_custom`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_custom`
--

LOCK TABLES `email_custom` WRITE;
/*!40000 ALTER TABLE `email_custom` DISABLE KEYS */;
INSERT INTO `email_custom` VALUES
(1,'Empiresystems','promoción','<p>Hola %nombre%, &iquest;necesitas de un servicio digital? Cada una de nuestras areas se encuentra formado por diversos expertos para m&aacute;ximizar y asegurar el &eacute;xito. Ayudamos a nuestros clientes a ser m&aacute;s competitivos mediante una dedicaci&oacute;n comprometida, innovadora y eficaz basada en la confianza.</p>\n<p>Puede consultar por nuestros servicios&nbsp;<a href=\"https://empiresystems.io/\">empiresystems.io</a></p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<!-- Fallback force center content -->\n<div style=\"text-align: center;\">\n<table style=\"text-align: center; vertical-align: top; width: 592px; max-width: 600px; background-color: #3f3f3f;\" width=\"592\" cellpadding=\"0px\" align=\"center\">\n<tbody>\n<tr>\n<td style=\"width: 592px; vertical-align: top; padding: 0px;\"><!-- Your logo  is here --> <!--\n            <img style=\"width: 200px; max-width: 200px; height: 70px; max-height: 70px; text-align: center; color: #ffffff;\" alt=\"Logo\" src=\"https://64.media.tumblr.com/dfe839d12d891dc4b73f0f29da62fa49/tumblr_inline_sc3yl3BwJh1rfe0n6_500.jpg\" align=\"center\" width=\"600\" height=\"170\">\n            <!-- Your logo 2 is here --> <!--   <img style=\"width: 600px; max-width: 600px; height: 200px; max-height: 200px; text-align: center; color: #fcf6df;\" alt=\"Logo\" src=\"https://64.media.tumblr.com/77b0199f657ba1688b57394272b58e9b/tumblr_inline_sc42vq6ffd1rfe0n6_500.jpg\" align=\"center\" width=\"800\" height=\"300\">\n <!-- Your logo 3 is here --> <img style=\"max-width: 200px; max-height: 100px; text-align: center; color: #ffffff;\" src=\"image.php?id=ix7XQcvhzdaaoqIPXeSEtgIO7\" alt=\"Logo\" width=\"240\" height=\"49\" align=\"middle\" /></td>\n</tr>\n</tbody>\n</table>\n<!-- End container for logo --> <!-- Hero image --> <br /><!-- Hero image --> <!-- Start single column section -->\n<table style=\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #ffffff;\" width=\"600\" align=\"center\">\n<tbody>\n<tr>\n<td style=\"width: 596px; vertical-align: top; padding: 30px 30px 40px 30px;\" width=\"596\">\n<div class=\"caja\">\n<p class=\"pretitulo wow fadeInUp\" data-wow-duration=\"1s\" data-wow-delay=\"0.3s\" data-wow-offset=\"100\">&iexcl;&iexcl;BIENVENIDO!!</p>\n</div>\n<div class=\"centrado centrado relative\">\n<div class=\"caja_h3 caja\">\n<h3 class=\"h3 wow fadeInUp\" data-wow-duration=\"1s\" data-wow-delay=\"0.6s\" data-wow-offset=\"100\">Tenemos el veh&iacute;culo que est&aacute; buscando</h3>\n</div>\n</div>\n<p><strong>Dilucars Autom&oacute;viles, S.L.</strong>&nbsp;empresa dedicada a la venta de&nbsp;<strong>veh&iacute;culos de ocasi&oacute;n</strong>, inicia su actividad el&nbsp;<strong>10 de diciembre de</strong>&nbsp;<strong>2007&nbsp;</strong>abriendo su primera exposici&oacute;n en una de las calles de mayor crecimiento y desarrollo econ&oacute;mico de la ciudad de Las Palmas de G.C en la&nbsp;<strong>Avda. Pintor Felo Monz&oacute;n,17 Portal 9 Bajo - 7 Palmas</strong>.</p>\n<p>Prueba de&nbsp;nuestra profesionalidad, seguridad en la compra a nuestros clientes y garant&iacute;a, nos llevan a seguir en el mercado a&ntilde;os m&aacute;s tarde. En febrero de&nbsp;<strong>2021 abrimos nuevas instalaciones</strong>&nbsp;tambi&eacute;n en Las Palmas de Gran Canaria en la&nbsp;<strong>C/ Arguineg&uuml;&iacute;n, 23 - Pol&iacute;gono Industrial Lomo Blanco - Las Torres (frente a la ITV)</strong>. Entre ambas exposiciones ofrecemos m&aacute;s de&nbsp;<strong>750 metros cuadrados&nbsp;</strong>y un amplio stock de&nbsp;<strong>veh&iacute;culos para elegir</strong>.</p>\n<h3>Le queremos agradecer su tiempo en la visita a nuestra web y le invitamos a conocer nuestro Stock y nuestra pol&iacute;tica de empresa.</h3>\n<p style=\"font-size: 15px; line-height: 24px; font-family: Releway, sans-serif; font-weight: 400; text-decoration: none; color: #919293; text-align: justify;\">Nuestra especialidad, es la venta de veh&iacute;culos seminuevos que han sido seleccionados para usted, por cubrir unos requisitos indispensables de bajo kilometraje, antig&uuml;edad no superior a 40 meses y totalmente revisados y garantizados.</p>\n<h2><span style=\"color: #3366ff;\"><strong><a style=\"color: #3366ff;\" href=\"https://www.empiresystems.io\">empiresystems.io</a></strong><!-- Start container for logo --></span></h2>\n</td>\n</tr>\n</tbody>\n</table>\n<h2><span style=\"color: #3366ff;\"><a style=\"color: #3366ff;\" href=\"https://www.dilucars.com/\"><!-- End single column section --> <!-- Start image --> </a></span></h2>\n<h4><span style=\"color: #3366ff;\"><a style=\"color: #3366ff;\" href=\"https://www.dilucars.com/\"><!-- End image --> <!-- Start footer --></a></span></h4>\n<table style=\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #3f3f3f;\" width=\"600\" cellpadding=\"15px 30px\" align=\"center\">\n<tbody>\n<tr>\n<td style=\"width: 600px; vertical-align: top; padding: 15px 30px 15px 30px;\" width=\"600\">\n<h4><!-- Your inverted logo is here --></h4>\n<span style=\"color: #ffffff;\">infomx@empiresystems.io</span>\n<h4 style=\"font-size: 12px; line-height: 12px; font-family: \'Raleway\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\">&nbsp;</h4>\n<h4 style=\"font-size: 11px; line-height: 20px; font-family: \'Helvetica\', Arial, sans-serif; font-weight: 400; text-decoration: none; color: #000000;\"><span style=\"color: #ffffff;\">No quieres recibir m&aacute;s correos electr&oacute;nicos?</span></h4>\n<p>&nbsp;</p>\n<h4 style=\"margin-bottom: 0; font-size: 17px; line-height: 24px; font-family: \'Releway\', Releway, sans-serif; font-weight: 400; text-decoration: none; color: #ffffff;\">&nbsp;</h4>\n<h4 style=\"font-size: 12px; line-height: 12px; font-family: \'Raleway\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\">&nbsp;</h4>\n</td>\n</tr>\n</tbody>\n</table>\n</div>');
/*!40000 ALTER TABLE `email_custom` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `empleado`
--

DROP TABLE IF EXISTS `empleado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `empleado` (
  `id_empleado` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `apellidos` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `nif` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `direccion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `telefono` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `fecha_contratacion` date DEFAULT NULL,
  `fecha_nacimiento` date DEFAULT NULL,
  `estado` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `numero_seguridad_social` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id_empleado`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `empleado`
--

LOCK TABLES `empleado` WRITE;
/*!40000 ALTER TABLE `empleado` DISABLE KEYS */;
/*!40000 ALTER TABLE `empleado` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `empleado_grupo2`
--

DROP TABLE IF EXISTS `empleado_grupo2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `empleado_grupo2` (
  `id_empleado_grupo2` int(11) NOT NULL AUTO_INCREMENT,
  `id_grupo2` int(11) NOT NULL,
  `id_empleado` int(11) NOT NULL,
  PRIMARY KEY (`id_empleado_grupo2`),
  KEY `id_grupo2` (`id_grupo2`),
  KEY `id_empleado` (`id_empleado`),
  CONSTRAINT `empleado_grupo2_ibfk_1` FOREIGN KEY (`id_empleado`) REFERENCES `empleados` (`id_empleado`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `empleado_grupo2_ibfk_2` FOREIGN KEY (`id_grupo2`) REFERENCES `grupos2` (`id_grupo2`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `empleado_grupo2`
--

LOCK TABLES `empleado_grupo2` WRITE;
/*!40000 ALTER TABLE `empleado_grupo2` DISABLE KEYS */;
INSERT INTO `empleado_grupo2` VALUES
(1,1,1),
(2,1,2);
/*!40000 ALTER TABLE `empleado_grupo2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `empleados`
--

DROP TABLE IF EXISTS `empleados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `empleados` (
  `id_empleado` int(11) NOT NULL AUTO_INCREMENT,
  `dni` varchar(255) DEFAULT NULL,
  `telefono` varchar(255) DEFAULT NULL,
  `direccion` varchar(255) DEFAULT NULL,
  `nombre` varchar(255) DEFAULT NULL,
  `precio_hora` decimal(9,2) DEFAULT NULL,
  `numero` varchar(15) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `nif` varchar(20) DEFAULT NULL,
  `precio_hora_extra` decimal(10,2) DEFAULT NULL,
  `id_usuario` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_empleado`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `empleados`
--

LOCK TABLES `empleados` WRITE;
/*!40000 ALTER TABLE `empleados` DISABLE KEYS */;
INSERT INTO `empleados` VALUES
(1,'2323','2323','232','Pepe',2.00,'33333333333','fede.gundel@gmail.com','123123',23.00,NULL),
(2,'martin','12345678','calle poeta','juan carlods',22.00,'12122222','fede.gundel@gmail.com','2121',12.00,NULL),
(3,'2222','2222','1','Pepe',30.00,'987123',NULL,NULL,NULL,NULL),
(4,'ii','ii','ii','k',12.00,'212121212','fede.gundel@gmail.com','1232',12312.00,NULL),
(5,'000000','6666666','calle 3','Ramiro',8.00,'7','yosoyrubens@gmail.com','88723',99.00,NULL),
(6,'2222','2222','Alcalde Jose Ramirez Bethencourt','Javi Pepito',3.00,'312222','javiervs9797@gmail.com','3',3.00,6690),
(7,'2','3','4','Empleado Limixer',5.00,'6','77','8',9.00,6697),
(10,'3213213123213123','31312','1232132132','Empleado Rubben',213.00,'21321','3123213','21321',99999999.99,13),
(11,'qewqe','wqe','wqewqe','ewqe',321312.00,'3213','213','213213',99999999.99,6684),
(12,'ii','02284728052','rendon 540','k',10.00,'1','fede.gundel@gmail.com','77',123.00,13);
/*!40000 ALTER TABLE `empleados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `envios_cumple`
--

DROP TABLE IF EXISTS `envios_cumple`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `envios_cumple` (
  `id_envios_cumple` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `fecha` datetime NOT NULL,
  `tipo` varchar(255) NOT NULL,
  `estado` varchar(255) NOT NULL,
  PRIMARY KEY (`id_envios_cumple`),
  KEY `client_id` (`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `envios_cumple`
--

LOCK TABLES `envios_cumple` WRITE;
/*!40000 ALTER TABLE `envios_cumple` DISABLE KEYS */;
INSERT INTO `envios_cumple` VALUES
(28,23,'2025-04-27 14:38:36','email','Enviado'),
(29,23,'2025-04-27 14:43:11','email','Enviado'),
(30,23,'2025-04-27 14:50:55','sms','Enviado'),
(31,23,'2025-04-27 21:55:00','sms','Enviado'),
(32,24,'2025-04-27 21:55:01','sms','Enviado'),
(33,23,'2025-04-27 21:55:47','email','Enviado'),
(34,24,'2025-04-27 21:55:50','email','Enviado');
/*!40000 ALTER TABLE `envios_cumple` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `envios_itv`
--

DROP TABLE IF EXISTS `envios_itv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `envios_itv` (
  `id_envio_itv` int(11) NOT NULL AUTO_INCREMENT,
  `tipo` varchar(25) DEFAULT NULL,
  `id_vehiculo` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `numero_email` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `motivo` varchar(20) NOT NULL,
  PRIMARY KEY (`id_envio_itv`),
  KEY `fk_vehiculo` (`id_vehiculo`),
  CONSTRAINT `fk_vehiculo` FOREIGN KEY (`id_vehiculo`) REFERENCES `vehiculos` (`id_vehiculo`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `envios_itv`
--

LOCK TABLES `envios_itv` WRITE;
/*!40000 ALTER TABLE `envios_itv` DISABLE KEYS */;
/*!40000 ALTER TABLE `envios_itv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estado_archivo`
--

DROP TABLE IF EXISTS `estado_archivo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `estado_archivo` (
  `id_estado_archivo` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `color` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_estado_archivo`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estado_archivo`
--

LOCK TABLES `estado_archivo` WRITE;
/*!40000 ALTER TABLE `estado_archivo` DISABLE KEYS */;
INSERT INTO `estado_archivo` VALUES
(1,'Cancelado','#bc5063'),
(2,'PASO 2','#3dba1e'),
(3,'Activo','#ef7afa'),
(4,'TODO OK','#33fd00'),
(5,'TODO PERFECTO','#ff0080'),
(6,'PLAZO FINALIZADO','#f4a200');
/*!40000 ALTER TABLE `estado_archivo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estado_subvencion`
--

DROP TABLE IF EXISTS `estado_subvencion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `estado_subvencion` (
  `nombre` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `id_estado_subvencion` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id_estado_subvencion`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estado_subvencion`
--

LOCK TABLES `estado_subvencion` WRITE;
/*!40000 ALTER TABLE `estado_subvencion` DISABLE KEYS */;
/*!40000 ALTER TABLE `estado_subvencion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estados`
--

DROP TABLE IF EXISTS `estados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `estados` (
  `id_estado` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  PRIMARY KEY (`id_estado`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estados`
--

LOCK TABLES `estados` WRITE;
/*!40000 ALTER TABLE `estados` DISABLE KEYS */;
INSERT INTO `estados` VALUES
(1,'Nuevas'),
(2,'A estrenaer');
/*!40000 ALTER TABLE `estados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eventos`
--

DROP TABLE IF EXISTS `eventos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `eventos` (
  `id_evento` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `fecha_inicio` datetime NOT NULL,
  `descripcion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `id_categoria` int(11) DEFAULT NULL,
  `fecha_final` datetime NOT NULL,
  `cancelado` tinyint(1) NOT NULL DEFAULT 0,
  `horario` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '../horarios/default.pdf',
  PRIMARY KEY (`id_evento`),
  KEY `id_categoria` (`id_categoria`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eventos`
--

LOCK TABLES `eventos` WRITE;
/*!40000 ALTER TABLE `eventos` DISABLE KEYS */;
INSERT INTO `eventos` VALUES
(1,'Fiesta de la primavera','2024-09-01 04:42:00','dfgsdfgdfg',1,'2024-09-24 04:42:00',0,'../horarios/default.pdf'),
(2,'nuevo','2024-09-08 12:02:00','rdtgwet',NULL,'2024-10-03 12:02:00',0,'../horarios/default.pdf');
/*!40000 ALTER TABLE `eventos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `factura_empleado`
--

DROP TABLE IF EXISTS `factura_empleado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `factura_empleado` (
  `id_factura_empleado` int(11) NOT NULL AUTO_INCREMENT,
  `id_empleado` int(11) NOT NULL,
  `fecha_i` date NOT NULL,
  `horas` int(11) NOT NULL,
  `horas_extra` int(11) NOT NULL,
  `importe` decimal(10,2) NOT NULL,
  `precio_hora` decimal(10,2) NOT NULL,
  `precio_horas_extra` decimal(10,2) NOT NULL,
  `fecha_f` date NOT NULL,
  `base` decimal(10,2) DEFAULT NULL,
  `bonus` decimal(10,2) DEFAULT NULL,
  `hora_extra` decimal(10,2) DEFAULT NULL,
  `otros_ingresos` decimal(10,2) DEFAULT NULL,
  `irpf` decimal(10,2) DEFAULT NULL,
  `total_ingresos` decimal(10,2) DEFAULT NULL,
  `total_deducciones` decimal(10,2) DEFAULT NULL,
  `firma` tinyint(1) DEFAULT 0,
  `csrf_token` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id_factura_empleado`),
  KEY `id_empleado` (`id_empleado`),
  CONSTRAINT `factura_empleado_ibfk_1` FOREIGN KEY (`id_empleado`) REFERENCES `empleados` (`id_empleado`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `factura_empleado`
--

LOCK TABLES `factura_empleado` WRITE;
/*!40000 ALTER TABLE `factura_empleado` DISABLE KEYS */;
INSERT INTO `factura_empleado` VALUES
(61,1,'2024-12-30',70,70,1750.00,2.00,23.00,'2025-01-07',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'MTczMzcxNDk4N0YyQUpRbmoxTVAzR0tCbE5wVEw2T0F0QlN5MTFPV3hQ'),
(62,1,'2024-12-24',99,990,922878.00,92.00,923.00,'2025-01-07',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'MTczMzcxNTE0OVZhZGxzNUgxY1lhWTVnbHgzMENIejl0Y2VIaHpYZDVi');
/*!40000 ALTER TABLE `factura_empleado` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `factura_manual`
--

DROP TABLE IF EXISTS `factura_manual`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `factura_manual` (
  `id_factura_manual` int(11) NOT NULL AUTO_INCREMENT,
  `numero` varchar(255) NOT NULL,
  `fecha` date NOT NULL,
  `direccion` varchar(255) DEFAULT NULL,
  `importe` decimal(9,2) NOT NULL,
  `estado` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `imagen` varchar(255) NOT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `nombre` varchar(255) NOT NULL,
  `cif` varchar(255) DEFAULT NULL,
  `cp` varchar(255) DEFAULT NULL,
  `telefono` varchar(255) DEFAULT NULL,
  `irpf` decimal(7,2) DEFAULT NULL,
  `client_id` int(11) NOT NULL,
  `fecha_envio` datetime DEFAULT NULL,
  `titulo` varchar(255) DEFAULT NULL,
  `tipo` varchar(255) NOT NULL DEFAULT 'Empresa',
  `programado` date DEFAULT NULL,
  `id_banco` int(11) DEFAULT NULL,
  `id_banco_2` int(11) DEFAULT NULL,
  `id_banco_3` int(11) DEFAULT NULL,
  `condiciones` longtext DEFAULT NULL,
  `impuesto` longtext DEFAULT NULL,
  `fechas` varchar(255) DEFAULT NULL,
  `lugar` varchar(255) DEFAULT NULL,
  `id_proyecto` int(11) DEFAULT NULL,
  `clase` varchar(255) NOT NULL DEFAULT 'Normal',
  PRIMARY KEY (`id_factura_manual`),
  KEY `client_id` (`client_id`),
  KEY `id_banco` (`id_banco`),
  KEY `id_banco_3` (`id_banco_3`),
  KEY `id_proyecto` (`id_proyecto`),
  KEY `id_banco_2` (`id_banco_2`),
  CONSTRAINT `factura_manual_ibfk_1` FOREIGN KEY (`id_banco`) REFERENCES `bancos` (`id_banco`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `factura_manual_ibfk_2` FOREIGN KEY (`id_proyecto`) REFERENCES `proyectos` (`id_proyecto`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `factura_manual_ibfk_3` FOREIGN KEY (`id_banco_2`) REFERENCES `bancos` (`id_banco`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `factura_manual_ibfk_4` FOREIGN KEY (`client_id`) REFERENCES `clientes` (`client_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `factura_manual`
--

LOCK TABLES `factura_manual` WRITE;
/*!40000 ALTER TABLE `factura_manual` DISABLE KEYS */;
INSERT INTO `factura_manual` VALUES
(79,'2025/A39','2025-04-09',NULL,143.00,'Enviada','fede.gundel@gmail.com','https://centro.factuley.com/image.php?id=ix7XQcvhzdaaoqIPXeSEtgIO7',NULL,'Paco Sanz 1','45394193J','35011','928252167',NULL,31,'2025-05-04 16:38:16','Factura','Particular',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Normal'),
(80,'2025A/40','2025-05-15','rendon 540',32.00,'Pendiente','fede.gundel@gmail.com','https://centro.factuley.com/image.php?id=ix7XQcvhzdaaoqIPXeSEtgIO7',NULL,'Andres Gracida','Y1255741R','7400','02284728052',NULL,37,NULL,'prueba','Particular',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Normal'),
(81,'2025A/41','2025-05-16','rendon 540',0.00,'Enviada','fede.gundel@gmail.com','https://centro.factuley.com/image.php?id=ix7XQcvhzdaaoqIPXeSEtgIO7',NULL,'Federico Gundel','37847226','7400','02284728052',NULL,38,'2025-05-16 18:11:22','Factura','Particular',NULL,4,NULL,NULL,'DESDE NUESTRAUHDWQDQDVWF\\nNUESTRA EMPRES ANO SEIOEÑ','\"Operación exenta de IGIC según lo dispuesto en el artículo 10.1.27º de la Ley 20/1991, de modificación de los aspectos fiscales del REF de Canarias.\\na2',NULL,NULL,NULL,'Normal'),
(83,'2025A/43','2025-05-17','rendon 540',143.00,'Enviada','fede.gundel@gmail.com','https://centro.factuley.com/image.php?id=ix7XQcvhzdaaoqIPXeSEtgIO7','2025-05-16','Federico Gundel','37847226','7400','02284728052',NULL,38,'2025-05-16 18:19:12','Factura','Particular',NULL,4,NULL,NULL,'DESDE NUESTRAUHDWQDQDVWF\\nNUESTRA EMPRES ANO SEIOEÑ','\"Operación exenta de IGIC según lo dispuesto en el artículo 10.1.27º de la Ley 20/1991, de modificación de los aspectos fiscales del REF de Canarias.',NULL,'eee',NULL,'Normal'),
(84,'2025A/44','2025-05-16','Alcalde Jose Ramirez Bethencourt',143.00,'Enviada','11@limidata.com','https://centro.factuley.com/image.php?id=ix7XQcvhzdaaoqIPXeSEtgIO7',NULL,'Paco Sanz 1','45394193J','35017','661033031',NULL,31,'2025-05-16 22:00:54','Factura','Particular',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Normal'),
(85,'2025A/45','2025-05-16',NULL,0.00,'Enviada','11@limidata.com','https://centro.factuley.com/image.php?id=ix7XQcvhzdaaoqIPXeSEtgIO7',NULL,'Paco Sanz 1','45394193J','35011','928252167',NULL,31,'2025-05-16 22:01:32','Factura','Particular',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Normal'),
(86,'2025A/46','2025-05-16',NULL,50.00,'Enviada','roberlp6@gmail.com','https://centro.factuley.com/image.php?id=ix7XQcvhzdaaoqIPXeSEtgIO7',NULL,'Paco Sanz 1','45394193J','35011','928252167',NULL,31,'2025-05-16 22:39:52','Factura','Particular',NULL,NULL,NULL,NULL,'DESDE NUESTRAUHDWQDQDVWF','a2',NULL,NULL,NULL,'Normal');
/*!40000 ALTER TABLE `factura_manual` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `factura_proveedor`
--

DROP TABLE IF EXISTS `factura_proveedor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `factura_proveedor` (
  `id_factura_proveedor` int(11) NOT NULL AUTO_INCREMENT,
  `importe` decimal(7,2) NOT NULL,
  `id_proveedor` int(11) DEFAULT NULL,
  `fecha_vencimiento` datetime DEFAULT NULL,
  `numero` varchar(255) DEFAULT NULL,
  `fecha` datetime NOT NULL,
  PRIMARY KEY (`id_factura_proveedor`),
  KEY `id_proveedor` (`id_proveedor`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `factura_proveedor`
--

LOCK TABLES `factura_proveedor` WRITE;
/*!40000 ALTER TABLE `factura_proveedor` DISABLE KEYS */;
INSERT INTO `factura_proveedor` VALUES
(4,800.00,1,'2024-11-04 13:37:00','8888','2024-11-04 13:37:00'),
(5,1400.00,1,'2024-11-14 12:34:00','112','2024-11-14 12:34:00'),
(9,500.00,2,'2024-12-30 14:05:00','LMD/01','2024-12-30 14:05:00'),
(10,3000.00,1,'2025-04-10 13:06:00','23','2025-04-10 13:06:00'),
(11,0.00,NULL,'2025-05-14 00:16:00',NULL,'2025-05-14 00:16:00'),
(12,0.00,1,'2025-05-14 00:17:00','324','2025-05-14 00:17:00');
/*!40000 ALTER TABLE `factura_proveedor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `facturas`
--

DROP TABLE IF EXISTS `facturas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `facturas` (
  `id_factura` int(11) NOT NULL AUTO_INCREMENT,
  `numero` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `fecha` datetime NOT NULL,
  `domicilio` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `importe` decimal(9,2) NOT NULL,
  `estado` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `id_presupuesto` int(11) NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `importe_restante` decimal(9,2) NOT NULL,
  `fecha_envio` datetime DEFAULT NULL,
  `metodo_pago` int(11) DEFAULT NULL,
  `pagos` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `importe_s` decimal(9,2) NOT NULL,
  `fecha_vencimiento` datetime NOT NULL,
  `dias_vencimiento` int(11) NOT NULL DEFAULT 7,
  `emails_vencimiento` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imagen` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `programado` datetime DEFAULT NULL,
  PRIMARY KEY (`id_factura`),
  KEY `FK_presupuesto_id` (`id_presupuesto`),
  KEY `metodo_pago` (`metodo_pago`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `facturas`
--

LOCK TABLES `facturas` WRITE;
/*!40000 ALTER TABLE `facturas` DISABLE KEYS */;
/*!40000 ALTER TABLE `facturas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `facturas_rectificadas`
--

DROP TABLE IF EXISTS `facturas_rectificadas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `facturas_rectificadas` (
  `id_factura_rectificada` int(11) NOT NULL AUTO_INCREMENT,
  `id_factura_manual` int(11) NOT NULL,
  `numero` varchar(255) NOT NULL,
  `fecha` date NOT NULL,
  PRIMARY KEY (`id_factura_rectificada`),
  KEY `facturas_rectificadas_ibfk_1` (`id_factura_manual`),
  CONSTRAINT `facturas_rectificadas_ibfk_1` FOREIGN KEY (`id_factura_manual`) REFERENCES `factura_manual` (`id_factura_manual`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `facturas_rectificadas`
--

LOCK TABLES `facturas_rectificadas` WRITE;
/*!40000 ALTER TABLE `facturas_rectificadas` DISABLE KEYS */;
INSERT INTO `facturas_rectificadas` VALUES
(6,83,'202521RE/','2025-05-16'),
(7,86,'202522RE/','2025-05-16');
/*!40000 ALTER TABLE `facturas_rectificadas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `familias`
--

DROP TABLE IF EXISTS `familias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `familias` (
  `id_familia` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id_familia`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `familias`
--

LOCK TABLES `familias` WRITE;
/*!40000 ALTER TABLE `familias` DISABLE KEYS */;
/*!40000 ALTER TABLE `familias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fases`
--

DROP TABLE IF EXISTS `fases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `fases` (
  `id_fase` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_fase`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fases`
--

LOCK TABLES `fases` WRITE;
/*!40000 ALTER TABLE `fases` DISABLE KEYS */;
/*!40000 ALTER TABLE `fases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `favorites`
--

DROP TABLE IF EXISTS `favorites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `favorites` (
  `favorite_id` int(11) NOT NULL AUTO_INCREMENT,
  `favorite_user` int(11) NOT NULL,
  `favorite_type` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `favorite_type_id` int(11) NOT NULL,
  `favorite_data` int(11) NOT NULL,
  PRIMARY KEY (`favorite_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `favorites`
--

LOCK TABLES `favorites` WRITE;
/*!40000 ALTER TABLE `favorites` DISABLE KEYS */;
/*!40000 ALTER TABLE `favorites` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `featured`
--

DROP TABLE IF EXISTS `featured`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `featured` (
  `featured_id` int(11) NOT NULL AUTO_INCREMENT,
  `featured_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `featured_url` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `featured_column` int(11) NOT NULL,
  PRIMARY KEY (`featured_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `featured`
--

LOCK TABLES `featured` WRITE;
/*!40000 ALTER TABLE `featured` DISABLE KEYS */;
/*!40000 ALTER TABLE `featured` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fichajes`
--

DROP TABLE IF EXISTS `fichajes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `fichajes` (
  `id_fichaje` int(11) NOT NULL AUTO_INCREMENT,
  `id_miembro` int(11) NOT NULL,
  `fecha_entrada` datetime NOT NULL,
  `fecha_salida` datetime DEFAULT NULL,
  `horas_descanso` int(11) DEFAULT NULL,
  `fecha` date NOT NULL,
  `ultima_entrada` datetime DEFAULT NULL,
  `ultima_salida` datetime DEFAULT NULL,
  `observaciones` varchar(1000) DEFAULT NULL,
  `estado` varchar(255) DEFAULT 'Pendiente',
  `csrf_token` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id_fichaje`),
  KEY `miembro` (`id_miembro`),
  CONSTRAINT `fichajes_ibfk_1` FOREIGN KEY (`id_miembro`) REFERENCES `miembro_equipo` (`id_miembro`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=196 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fichajes`
--

LOCK TABLES `fichajes` WRITE;
/*!40000 ALTER TABLE `fichajes` DISABLE KEYS */;
INSERT INTO `fichajes` VALUES
(194,44,'2025-05-20 17:46:04','2025-05-20 17:46:14',NULL,'2025-05-20',NULL,NULL,NULL,'Aceptado','MTc0Nzc3NDEyMGJRbXltbEsxM2VGaGl3YU9xNjAyNXIwbnNlU0FTWHBK'),
(195,44,'2025-05-20 19:57:22',NULL,NULL,'2025-05-20',NULL,NULL,NULL,'Aceptado','MTc0Nzc4MTk5OUNhcTA0TUZzOW44Q0ZOU0dQNTVCU1lxVlBYQkhXWWcw');
/*!40000 ALTER TABLE `fichajes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `files`
--

DROP TABLE IF EXISTS `files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `files` (
  `file_id` int(11) NOT NULL AUTO_INCREMENT,
  `file_user` int(11) DEFAULT NULL,
  `file_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `file_extension` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `file_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `file_section` int(11) NOT NULL,
  `file_folder` int(11) NOT NULL,
  `file_address` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `file_tags` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `file_data` int(11) NOT NULL,
  `fecha` date NOT NULL,
  `id_estado_archivo` int(11) DEFAULT NULL,
  PRIMARY KEY (`file_id`),
  KEY `file_user` (`file_user`),
  KEY `id_estado_archivo` (`id_estado_archivo`),
  CONSTRAINT `files_ibfk_1` FOREIGN KEY (`id_estado_archivo`) REFERENCES `estado_archivo` (`id_estado_archivo`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `files_ibfk_2` FOREIGN KEY (`file_user`) REFERENCES `users` (`user_id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `files`
--

LOCK TABLES `files` WRITE;
/*!40000 ALTER TABLE `files` DISABLE KEYS */;
INSERT INTO `files` VALUES
(8,13,'Fondo empresa','pdf','Archivo',0,22,'/22/','',1731587600,'2024-11-14',NULL);
/*!40000 ALTER TABLE `files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `financieras`
--

DROP TABLE IF EXISTS `financieras`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `financieras` (
  `id_financiera` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) NOT NULL,
  `telefono` varchar(20) NOT NULL,
  `email` varchar(255) NOT NULL,
  PRIMARY KEY (`id_financiera`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `financieras`
--

LOCK TABLES `financieras` WRITE;
/*!40000 ALTER TABLE `financieras` DISABLE KEYS */;
/*!40000 ALTER TABLE `financieras` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `firmas`
--

DROP TABLE IF EXISTS `firmas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `firmas` (
  `id_firma` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `dni` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  PRIMARY KEY (`id_firma`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `firmas`
--

LOCK TABLES `firmas` WRITE;
/*!40000 ALTER TABLE `firmas` DISABLE KEYS */;
/*!40000 ALTER TABLE `firmas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `folders`
--

DROP TABLE IF EXISTS `folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `folders` (
  `folder_id` int(11) NOT NULL AUTO_INCREMENT,
  `folder_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `folder_user` int(11) DEFAULT NULL,
  `folder_section` int(11) NOT NULL,
  `folder_folder` int(11) NOT NULL,
  `folder_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `folder_address` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `folder_tag` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `folder_data` int(11) NOT NULL,
  `id_estado_archivo` int(11) DEFAULT NULL,
  `id_extra_folder` int(11) DEFAULT NULL,
  PRIMARY KEY (`folder_id`),
  KEY `id_estado_archivo` (`id_estado_archivo`),
  KEY `folder_user` (`folder_user`),
  CONSTRAINT `folders_ibfk_1` FOREIGN KEY (`id_estado_archivo`) REFERENCES `estado_archivo` (`id_estado_archivo`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `folders_ibfk_2` FOREIGN KEY (`folder_user`) REFERENCES `users` (`user_id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `folders`
--

LOCK TABLES `folders` WRITE;
/*!40000 ALTER TABLE `folders` DISABLE KEYS */;
INSERT INTO `folders` VALUES
(19,'JUAN MANUEL',13,0,0,NULL,'/','',1726574064,3,NULL),
(22,'FACTURAS 2025 ',13,0,0,NULL,'/','',1731587567,6,NULL),
(37,'prueba',6707,0,0,NULL,'/','sdfasd,sadfa',1744399544,NULL,NULL);
/*!40000 ALTER TABLE `folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `formularios`
--

DROP TABLE IF EXISTS `formularios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formularios` (
  `id_formulario` int(11) NOT NULL AUTO_INCREMENT,
  `portada` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `info_1` varchar(2500) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `apellidos` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `dni` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `pais` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `ciudad` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `direccion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `info_2` varchar(2500) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `info_3` varchar(2500) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `autorizacion` tinyint(1) DEFAULT NULL,
  `info_4` varchar(2500) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `texto_modal` varchar(2500) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `lottie_modal` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `nombre_formulario` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `estado` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT 'Activo',
  PRIMARY KEY (`id_formulario`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `formularios`
--

LOCK TABLES `formularios` WRITE;
/*!40000 ALTER TABLE `formularios` DISABLE KEYS */;
/*!40000 ALTER TABLE `formularios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gasto_proyecto`
--

DROP TABLE IF EXISTS `gasto_proyecto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gasto_proyecto` (
  `id_gasto_proyecto` int(11) NOT NULL AUTO_INCREMENT,
  `concepto` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `importe` decimal(10,2) DEFAULT NULL,
  `observaciones` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `id_proyecto` int(11) NOT NULL,
  `fecha` date DEFAULT NULL,
  PRIMARY KEY (`id_gasto_proyecto`),
  KEY `fk_gasto_proyecto_proyectos` (`id_proyecto`),
  CONSTRAINT `fk_gasto_proyecto_proyectos` FOREIGN KEY (`id_proyecto`) REFERENCES `proyectos` (`id_proyecto`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gasto_proyecto`
--

LOCK TABLES `gasto_proyecto` WRITE;
/*!40000 ALTER TABLE `gasto_proyecto` DISABLE KEYS */;
INSERT INTO `gasto_proyecto` VALUES
(2,'Bloque de hormigon',3000.00,'bloque',4,'2025-01-30');
/*!40000 ALTER TABLE `gasto_proyecto` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `google`
--

DROP TABLE IF EXISTS `google`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `google` (
  `client_id` varchar(100) DEFAULT NULL,
  `client_secret` varchar(100) DEFAULT NULL,
  `redirect_link` varchar(100) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `google`
--

LOCK TABLES `google` WRITE;
/*!40000 ALTER TABLE `google` DISABLE KEYS */;
INSERT INTO `google` VALUES
('313096051511-0lkoha12n1ik35o5catoji3fchprd88h.apps.googleusercontent.com','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','https://centro.factuley.com/login',1);
/*!40000 ALTER TABLE `google` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `grupo_cliente`
--

DROP TABLE IF EXISTS `grupo_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `grupo_cliente` (
  `id_grupo_cliente` int(11) NOT NULL AUTO_INCREMENT,
  `id_grupo` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  PRIMARY KEY (`id_grupo_cliente`),
  KEY `id_grupo` (`id_grupo`),
  KEY `client_id` (`client_id`),
  CONSTRAINT `grupo_cliente_ibfk_1` FOREIGN KEY (`id_grupo`) REFERENCES `grupos` (`id_grupo`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `grupo_cliente_ibfk_2` FOREIGN KEY (`client_id`) REFERENCES `clientes` (`client_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `grupo_cliente`
--

LOCK TABLES `grupo_cliente` WRITE;
/*!40000 ALTER TABLE `grupo_cliente` DISABLE KEYS */;
/*!40000 ALTER TABLE `grupo_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `grupos`
--

DROP TABLE IF EXISTS `grupos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `grupos` (
  `id_grupo` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_grupo`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `grupos`
--

LOCK TABLES `grupos` WRITE;
/*!40000 ALTER TABLE `grupos` DISABLE KEYS */;
INSERT INTO `grupos` VALUES
(3,'LASER MICROBLADING'),
(5,'Grupos jueves a las 3'),
(6,'ss'),
(7,'Nuevo'),
(8,'1'),
(9,'klñ'),
(10,'1111'),
(11,'44');
/*!40000 ALTER TABLE `grupos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `grupos2`
--

DROP TABLE IF EXISTS `grupos2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `grupos2` (
  `id_grupo2` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_grupo2`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `grupos2`
--

LOCK TABLES `grupos2` WRITE;
/*!40000 ALTER TABLE `grupos2` DISABLE KEYS */;
INSERT INTO `grupos2` VALUES
(1,'ss');
/*!40000 ALTER TABLE `grupos2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `igic`
--

DROP TABLE IF EXISTS `igic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `igic` (
  `id_igic` int(11) NOT NULL AUTO_INCREMENT,
  `porcentaje` decimal(9,2) DEFAULT NULL,
  `nombre` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id_igic`),
  UNIQUE KEY `porcentaje` (`porcentaje`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `igic`
--

LOCK TABLES `igic` WRITE;
/*!40000 ALTER TABLE `igic` DISABLE KEYS */;
INSERT INTO `igic` VALUES
(1,7.00,'IGIC 7%'),
(3,21.00,'IVA 21%');
/*!40000 ALTER TABLE `igic` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `impuestos`
--

DROP TABLE IF EXISTS `impuestos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `impuestos` (
  `id_impuesto` int(11) NOT NULL AUTO_INCREMENT,
  `titulo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `impuesto` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_impuesto`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `impuestos`
--

LOCK TABLES `impuestos` WRITE;
/*!40000 ALTER TABLE `impuestos` DISABLE KEYS */;
INSERT INTO `impuestos` VALUES
(1,'a1','a2'),
(2,'Exento de IGIC','\"Operación exenta de IGIC según lo dispuesto en el artículo 10.1.27º de la Ley 20/1991, de modificación de los aspectos fiscales del REF de Canarias.');
/*!40000 ALTER TABLE `impuestos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ingreso_plan`
--

DROP TABLE IF EXISTS `ingreso_plan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ingreso_plan` (
  `id_ingreso_plan` int(11) NOT NULL AUTO_INCREMENT,
  `monto` decimal(9,2) NOT NULL,
  `fecha` datetime NOT NULL,
  `observaciones` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `id_plan` int(11) NOT NULL,
  PRIMARY KEY (`id_ingreso_plan`),
  KEY `id_plan` (`id_plan`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ingreso_plan`
--

LOCK TABLES `ingreso_plan` WRITE;
/*!40000 ALTER TABLE `ingreso_plan` DISABLE KEYS */;
/*!40000 ALTER TABLE `ingreso_plan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jornada_laboral`
--

DROP TABLE IF EXISTS `jornada_laboral`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `jornada_laboral` (
  `id_jornada` int(11) NOT NULL AUTO_INCREMENT,
  `id_miembro` int(11) NOT NULL,
  `lunes_e` time DEFAULT '08:00:00',
  `lunes_s` time DEFAULT '12:00:00',
  `martes_e` time DEFAULT '08:00:00',
  `martes_s` time DEFAULT '12:00:00',
  `miercoles_e` time DEFAULT '08:00:00',
  `miercoles_s` time DEFAULT '12:00:00',
  `jueves_e` time DEFAULT '08:00:00',
  `jueves_s` time DEFAULT '12:00:00',
  `viernes_e` time DEFAULT '08:00:00',
  `viernes_s` time DEFAULT '12:00:00',
  `sabado_e` time DEFAULT '08:00:00',
  `sabado_s` time DEFAULT '12:00:00',
  `lunes2_e` time DEFAULT '14:00:00',
  `lunes2_s` time DEFAULT '18:00:00',
  `martes2_e` time DEFAULT '14:00:00',
  `martes2_s` time DEFAULT '18:00:00',
  `miercoles2_e` time DEFAULT '14:00:00',
  `miercoles2_s` time DEFAULT '18:00:00',
  `jueves2_e` time DEFAULT '14:00:00',
  `jueves2_s` time DEFAULT '18:00:00',
  `viernes2_e` time DEFAULT '14:00:00',
  `viernes2_s` time DEFAULT '18:00:00',
  `sabado2_e` time DEFAULT '14:00:00',
  `sabado2_s` time DEFAULT '18:00:00',
  `domingo_e` time DEFAULT NULL,
  `domingo_s` time DEFAULT NULL,
  `domingo2_e` time DEFAULT NULL,
  `domingo2_s` time DEFAULT NULL,
  PRIMARY KEY (`id_jornada`),
  KEY `id_miembro` (`id_miembro`),
  CONSTRAINT `jornada_laboral_ibfk_1` FOREIGN KEY (`id_miembro`) REFERENCES `miembro_equipo` (`id_miembro`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jornada_laboral`
--

LOCK TABLES `jornada_laboral` WRITE;
/*!40000 ALTER TABLE `jornada_laboral` DISABLE KEYS */;
INSERT INTO `jornada_laboral` VALUES
(28,32,'08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','14:00:00','20:00:00','14:00:00','20:00:00','14:00:00','20:00:00','14:00:00','20:00:00','14:00:00','20:00:00','14:00:00','20:00:00','08:00:00','12:00:00','14:00:00','20:00:00'),
(32,36,'08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','14:00:00','20:00:00','14:00:00','20:00:00','14:00:00','20:00:00','14:00:00','20:00:00','14:00:00','20:00:00','14:00:00','20:00:00','08:00:00','12:00:00','14:00:00','20:00:00'),
(34,38,'08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','14:00:00','23:00:00','14:00:00','23:00:00','14:00:00','23:00:00','14:00:00','23:00:00','14:00:00','23:00:00','14:00:00','23:00:00','08:00:00','12:00:00','14:00:00','23:00:00'),
(38,42,'08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','14:00:00','20:00:00','14:00:00','20:00:00','14:00:00','20:00:00','14:00:00','20:00:00','14:00:00','20:00:00','14:00:00','20:00:00','08:00:00','12:00:00','14:00:00','20:00:00'),
(40,44,'08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','08:00:00','12:00:00','14:00:00','20:00:00','14:00:00','20:00:00','14:00:00','20:00:00','14:00:00','20:00:00','14:00:00','20:00:00','14:00:00','20:00:00','08:00:00','12:00:00','14:00:00','20:00:00');
/*!40000 ALTER TABLE `jornada_laboral` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kit_articulo`
--

DROP TABLE IF EXISTS `kit_articulo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kit_articulo` (
  `id_kit_articulo` int(11) NOT NULL AUTO_INCREMENT,
  `id_articulo` int(11) NOT NULL,
  `id_kit` int(11) NOT NULL,
  `cantidad` int(11) NOT NULL,
  PRIMARY KEY (`id_kit_articulo`),
  KEY `fk_kit_articulo_id_articulo` (`id_articulo`),
  KEY `fk_kit_articulo_id_kit` (`id_kit`),
  CONSTRAINT `fk_kit_articulo_id_articulo` FOREIGN KEY (`id_articulo`) REFERENCES `articulos` (`id_articulo`) ON DELETE CASCADE,
  CONSTRAINT `fk_kit_articulo_id_kit` FOREIGN KEY (`id_kit`) REFERENCES `kits` (`id_kit`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kit_articulo`
--

LOCK TABLES `kit_articulo` WRITE;
/*!40000 ALTER TABLE `kit_articulo` DISABLE KEYS */;
/*!40000 ALTER TABLE `kit_articulo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kits`
--

DROP TABLE IF EXISTS `kits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kits` (
  `id_kit` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `descuento` decimal(7,2) NOT NULL,
  PRIMARY KEY (`id_kit`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kits`
--

LOCK TABLES `kits` WRITE;
/*!40000 ALTER TABLE `kits` DISABLE KEYS */;
/*!40000 ALTER TABLE `kits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `logins`
--

DROP TABLE IF EXISTS `logins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `logins` (
  `login_id` int(11) NOT NULL AUTO_INCREMENT,
  `login_user` int(11) DEFAULT NULL,
  `login_ip` text NOT NULL,
  `login_agent` text DEFAULT NULL,
  `login_success` tinyint(4) NOT NULL,
  `login_date` int(11) NOT NULL,
  PRIMARY KEY (`login_id`),
  KEY `fk_logins_users_idx` (`login_user`)
) ENGINE=InnoDB AUTO_INCREMENT=431 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `logins`
--

LOCK TABLES `logins` WRITE;
/*!40000 ALTER TABLE `logins` DISABLE KEYS */;
INSERT INTO `logins` VALUES
(8,13,'77.231.124.90','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 OPR/112.0.0.0',1,1725289441),
(9,13,'77.231.124.90','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 OPR/112.0.0.0',1,1725292413),
(12,13,'77.231.124.90','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 OPR/112.0.0.0',1,1725301235),
(17,13,'77.231.124.90','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 OPR/112.0.0.0',1,1725460669),
(18,13,'77.231.124.90','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 OPR/112.0.0.0',1,1725461097),
(20,13,'77.231.124.90','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 OPR/112.0.0.0',1,1725522947),
(21,13,'77.231.124.90','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 OPR/112.0.0.0',1,1725619965),
(24,13,'77.231.124.90','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 OPR/112.0.0.0',1,1725628090),
(26,13,'85.51.18.14','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 OPR/112.0.0.0',1,1725707061),
(27,13,'85.51.16.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 OPR/112.0.0.0',1,1725710322),
(29,13,'85.51.57.178','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 OPR/112.0.0.0',1,1725822977),
(31,13,'90.166.99.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 OPR/112.0.0.0',1,1725967262),
(37,13,'85.51.57.178','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 OPR/112.0.0.0',1,1726120796),
(38,13,'77.231.124.90','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 OPR/112.0.0.0',1,1726129244),
(52,13,'85.51.18.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 OPR/112.0.0.0',1,1726574031),
(68,13,'90.166.99.4','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 OPR/112.0.0.0',1,1727088088),
(69,13,'85.51.17.73','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 OPR/112.0.0.0',1,1727094976),
(74,13,'90.166.193.89','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 OPR/112.0.0.0',1,1727269230),
(80,13,'83.59.19.36','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 OPR/112.0.0.0',1,1727544251),
(84,13,'77.231.124.90','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 OPR/113.0.0.0',1,1728322851),
(85,13,'83.59.19.36','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 OPR/113.0.0.0',1,1728396513),
(86,13,'83.59.19.36','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 OPR/113.0.0.0',1,1728593270),
(87,13,'83.59.19.36','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 OPR/113.0.0.0',1,1728668894),
(88,13,'83.59.19.36','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 OPR/113.0.0.0',1,1728919837),
(92,13,'2.137.147.122','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 OPR/113.0.0.0',1,1729106149),
(93,13,'85.51.21.85','Mozilla/5.0 (iPhone; CPU iPhone OS 17_7 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/129.0.6668.69 Mobile/15E148 Safari/604.1',1,1729107580),
(94,13,'85.51.57.178','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 OPR/113.0.0.0',1,1729122995),
(95,13,'81.61.230.94','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 OPR/113.0.0.0',1,1729178640),
(100,13,'212.230.233.53','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1730143954),
(103,13,'119.12.255.220','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1730199294),
(108,13,'79.116.36.84','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1730289437),
(109,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1730552143),
(113,13,'90.166.98.221','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1730727318),
(115,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1730816028),
(116,13,'87.125.238.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1730885984),
(118,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1731075807),
(119,13,'213.96.27.35','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1731320105),
(121,13,'83.59.19.36','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1731585581),
(122,13,'83.59.19.36','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1731586665),
(124,13,'83.59.19.36','Mozilla/5.0 (iPhone; CPU iPhone OS 18_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/130.0.6723.90 Mobile/15E148 Safari/604.1',1,1731592079),
(125,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36',1,1731608316),
(127,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1731928764),
(128,13,'46.27.69.24','Mozilla/5.0 (iPhone; CPU iPhone OS 18_2_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/131.0.6778.73 Mobile/15E148 Safari/604.1',1,1732016727),
(130,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1732016792),
(137,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1732187769),
(143,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1732275550),
(147,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1732288086),
(148,6692,'88.8.175.89','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36',0,1732538783),
(155,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1732557970),
(156,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1732558008),
(157,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1732558301),
(165,13,'85.48.184.171','Mozilla/5.0 (iPhone; CPU iPhone OS 18_2_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/131.0.6778.73 Mobile/15E148 Safari/604.1',1,1732866504),
(174,13,'46.27.69.24','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36',1,1733129056),
(175,13,'206.204.131.46','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36',1,1733132841),
(178,13,'176.80.93.104','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1733133172),
(184,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1733181550),
(202,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1733764407),
(209,13,'85.51.57.178','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36',1,1734111177),
(212,13,'83.59.20.38','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1734266363),
(225,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 OPR/115.0.0.0',1,1735820069),
(234,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36',1,1736337821),
(235,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36',1,1736344295),
(238,13,'83.59.9.4','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36',1,1736425921),
(244,13,'83.59.9.4','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 OPR/115.0.0.0',1,1736594704),
(245,13,'79.117.162.10','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 OPR/115.0.0.0',1,1736799163),
(248,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 OPR/115.0.0.0',1,1736986160),
(249,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 OPR/115.0.0.0',1,1737031169),
(250,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 OPR/115.0.0.0',1,1737050002),
(251,13,'83.59.9.4','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0',1,1737137137),
(252,13,'83.59.9.4','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 OPR/115.0.0.0',1,1737969013),
(254,13,'85.51.16.41','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36',1,1738008085),
(255,13,'83.59.9.4','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 OPR/116.0.0.0',1,1738085923),
(256,13,'85.51.16.169','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 OPR/116.0.0.0',1,1738158938),
(257,13,'85.51.23.116','Mozilla/5.0 (iPhone; CPU iPhone OS 18_3_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/132.0.6834.100 Mobile/15E148 Safari/604.1',1,1738159205),
(258,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 OPR/116.0.0.0',1,1738171504),
(259,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 OPR/115.0.0.0',1,1738172444),
(261,13,'83.59.9.4','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 OPR/116.0.0.0',1,1738254557),
(262,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 OPR/116.0.0.0',1,1738580648),
(263,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 OPR/116.0.0.0',1,1738583900),
(266,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 OPR/116.0.0.0',1,1738602085),
(267,13,'85.51.57.178','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 OPR/116.0.0.0',1,1738748375),
(268,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 OPR/116.0.0.0',1,1738756283),
(269,6707,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36',0,1743331492),
(270,6707,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36',1,1743333559),
(271,6707,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36',1,1743459631),
(272,6707,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36',1,1743983661),
(273,6707,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36',1,1743983718),
(274,6707,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36',1,1743984817),
(275,6707,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36',1,1743984910),
(276,6707,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36',1,1743985189),
(277,6707,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744212852),
(278,6707,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744238647),
(279,6707,'::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744245544),
(280,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744249321),
(281,13,'85.51.57.178','Mozilla/5.0 (iPhone; CPU iPhone OS 18_4_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/135.0.7049.53 Mobile/15E148 Safari/604.1',1,1744249326),
(282,13,'85.51.57.178','Mozilla/5.0 (iPhone; CPU iPhone OS 18_4_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/135.0.7049.53 Mobile/15E148 Safari/604.1',1,1744271092),
(283,13,'85.51.57.178','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36 OPR/117.0.0.0',1,1744275662),
(284,13,'85.51.57.178','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36 OPR/117.0.0.0',1,1744283272),
(287,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744309002),
(288,13,'85.51.57.178','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36 OPR/117.0.0.0',1,1744328041),
(289,13,'85.51.57.178','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36 OPR/117.0.0.0',1,1744329268),
(290,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744370999),
(291,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744378310),
(292,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744392931),
(293,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744405277),
(294,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744410059),
(295,13,'83.59.18.196','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36 OPR/117.0.0.0',1,1744481571),
(297,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744656347),
(298,13,'83.59.18.196','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36 OPR/117.0.0.0',1,1744660631),
(307,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744749839),
(313,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744756641),
(314,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744770738),
(315,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744777354),
(316,13,'62.43.176.41','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36 OPR/117.0.0.0',1,1744798745),
(317,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744826239),
(318,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744830531),
(319,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744843296),
(320,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744849779),
(321,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744851702),
(322,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744855213),
(323,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744907406),
(324,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744907459),
(325,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744909775),
(326,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744910380),
(327,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744917991),
(328,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744921964),
(329,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744931884),
(330,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1744993129),
(331,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1745010713),
(332,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1745011330),
(333,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1745035267),
(334,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1745036965),
(337,13,'85.51.57.178','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36 OPR/117.0.0.0',1,1745260601),
(339,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1745270224),
(340,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1745274406),
(341,13,'88.25.163.117','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36 OPR/117.0.0.0',1,1745330723),
(344,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1745349866),
(345,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1745353925),
(346,13,'83.59.185.188','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36 OPR/117.0.0.0',1,1745355033),
(347,13,'85.51.57.178','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36 OPR/117.0.0.0',1,1745395333),
(348,13,'88.25.163.117','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36 OPR/117.0.0.0',1,1745430457),
(350,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1745449306),
(351,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1745456766),
(352,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1745466632),
(353,13,'88.25.163.117','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36 OPR/117.0.0.0',1,1745569816),
(354,13,'88.25.163.117','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36 OPR/117.0.0.0',1,1745593376),
(355,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1745681351),
(356,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1745756233),
(357,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1745784637),
(358,13,'85.51.57.178','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36 OPR/117.0.0.0',1,1745786138),
(359,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1745786269),
(360,6727,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',0,1745788416),
(361,6727,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1745788508),
(362,6707,'186.137.88.51','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36',1,1745790162),
(363,6727,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1745796542),
(366,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1746061562),
(367,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',1,1746084409),
(368,13,'83.59.194.78','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Safari/537.36 OPR/118.0.0.0',1,1746121319),
(369,6707,'186.0.182.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1746703516),
(372,6707,'186.0.182.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1746740402),
(373,6707,'186.0.182.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1746783220),
(374,6707,'186.0.182.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1746785480),
(375,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Safari/537.36 OPR/118.0.0.0',1,1746788829),
(376,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1746994426),
(377,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747002685),
(378,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747002989),
(379,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747012893),
(380,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747031951),
(381,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747107028),
(382,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747168991),
(383,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747190922),
(384,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747209449),
(385,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747298027),
(388,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747344060),
(389,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747347693),
(390,6734,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747348412),
(391,6734,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747348423),
(392,6734,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747348474),
(393,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Safari/537.36 OPR/118.0.0.0',1,1747413515),
(394,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747413950),
(395,13,'46.27.69.24','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747414948),
(396,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747415234),
(397,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747415316),
(398,6733,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747420022),
(399,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Safari/537.36 OPR/118.0.0.0',1,1747429182),
(400,6736,'46.27.69.24','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747429966),
(401,6736,'46.27.69.24','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747430388),
(402,13,'46.27.69.24','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Safari/537.36 OPR/118.0.0.0',1,1747432813),
(403,6733,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747433396),
(404,6734,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747433552),
(405,6734,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747436529),
(406,6734,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747438314),
(407,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747442431),
(408,6733,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747450690),
(409,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747450716),
(410,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747463592),
(411,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747506518),
(412,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747528172),
(413,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747539242),
(414,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747600315),
(415,13,'85.51.57.178','Mozilla/5.0 (iPhone; CPU iPhone OS 18_4_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/136.0.7103.91 Mobile/15E148 Safari/604.1',1,1747606845),
(416,13,'85.51.57.178','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Safari/537.36 OPR/118.0.0.0',1,1747608414),
(417,6736,'104.28.42.85','Mozilla/5.0 (iPhone; CPU iPhone OS 18_4_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.4 Mobile/15E148 Safari/604.1',1,1747609554),
(418,6736,'88.24.64.74','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747609894),
(419,13,'85.51.57.178','Mozilla/5.0 (iPhone; CPU iPhone OS 18_4_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/136.0.7103.91 Mobile/15E148 Safari/604.1',1,1747613793),
(420,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747710974),
(421,6707,'186.137.88.51','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36',1,1747721998),
(422,13,'81.43.66.163','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Safari/537.36 OPR/118.0.0.0',1,1747755926),
(423,13,'83.59.15.159','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Safari/537.36 OPR/118.0.0.0',1,1747767732),
(424,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747771564),
(425,6707,'186.137.88.51','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36',1,1747777124),
(426,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747786852),
(427,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747797198),
(428,6707,'186.137.88.51','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36',1,1747803327),
(429,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747817989),
(430,6707,'186.137.88.51','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36',1,1747822719);
/*!40000 ALTER TABLE `logins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mailing`
--

DROP TABLE IF EXISTS `mailing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mailing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `from_address` varchar(100) DEFAULT NULL,
  `to_address` varchar(100) DEFAULT NULL,
  `body` text DEFAULT NULL,
  `used` tinyint(1) DEFAULT NULL,
  `attachments` text DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `createdAt` datetime DEFAULT NULL,
  `title` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=120 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mailing`
--

LOCK TABLES `mailing` WRITE;
/*!40000 ALTER TABLE `mailing` DISABLE KEYS */;
INSERT INTO `mailing` VALUES
(79,'admin@centro.factuley.com','fede.gundel@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se ha creado un fichaje a su nombre\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n\n                                            ¿Desea aceptar el fichaje? <br>\n\n                                            Haga clic en el siguiente botón para confirmar su aceptación:\n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_fichaje?id=172&token=MTc0NzAxNDY1Nm9uQ2pSQVRlZ09aWE1KeGYzZjhLTkRFZ0FkR3RadnJ6\\\' class=\\\'button\\\'>Aceptar Fichaje</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-12 02:50:56','Se ha creado un fichaje a su nombre'),
(80,'admin@centro.factuley.com','yosoyrubens@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se ha creado un fichaje a su nombre\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n\n                                            ¿Desea aceptar el fichaje? <br>\n\n                                            Haga clic en el siguiente botón para confirmar su aceptación:\n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_fichaje?id=173&token=MTc0NzE4MTU3NUJueXpVQXoxU2E4Y3VFU01XUVpVZVpiRnFLY2pqaHdC\\\' class=\\\'button\\\'>Aceptar Fichaje</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-14 01:12:55','Se ha creado un fichaje a su nombre'),
(81,'admin@centro.factuley.com','yosoyrubens@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se ha creado un fichaje a su nombre\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n\n                                            ¿Desea aceptar el fichaje? <br>\n\n                                            Haga clic en el siguiente botón para confirmar su aceptación:\n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_fichaje?id=173&token=MTc0NzE4MTgzMWV5Smw0b0hNbDIzWGdqZVluWEg3TUpvZWhhVWdtRGRt\\\' class=\\\'button\\\'>Aceptar Fichaje</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-14 01:17:11','Se ha creado un fichaje a su nombre'),
(82,'admin@centro.factuley.com','gundelagustina@gmail.com','<!DOCTYPE html>\n<html lang=\\\"es\\\">\n	<head>\n	<title>Solicitud de acceso - Plataforma [A&ntilde;adirNombre]</title>\n		<meta charset=\\\"UTF-8\\\">\n		<link href=\\\"https://fonts.googleapis.com/css?family=Ubuntu:300\\\" rel=\\\"stylesheet\\\" />\n		<link href=\\\"https://fonts.googleapis.com/css?family=Ubuntu:400,500&display=swap\\\" rel=\\\"stylesheet\\\" />\n        <meta name=\\\"viewport\\\" content=\\\"user-scalable=no, width=device-width, initial-scale=1\\\">\n	</head>\n	<body style=\\\"margin:0px;padding:0px;font-family:\\\'Ubuntu\\\', sans-serif;\\\">\n		<div style=\\\"max-width:700px;margin: auto;height:auto;overflow:hidden;\\\">\n			<div style=\\\"width:100%;height:120px;overflow:hidden;\\\">\n				<img src=\\\"https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\" style=\\\"width:100%;\\\">\n			</div>\n			<div style=\\\"width:auto;padding:0px 25px;\\\">\n				\n				<h1 style=\\\"color:#4d4d4d;font-size:18pt;font-family:\\\'Ubuntu\\\', sans-serif;font-weight:400;\\\">Hola agustina gundel</h1>\n				<div style=\\\"width:100%;height:auto;font-weight:300;font-size:14pt;color:#4d4d4d;font-family:\\\'Ubuntu\\\', sans-serif;\\\">\n\n\n					<p>Su solicitud ha sido aceptada por parte del departamento de [A&ntilde;adirNombre]</p>\n	\n				</div>\n				\n			</div>\n		\n			<div style=\\\"max-width:100%;margin:auto;color:#abadae;font-size:11pt;font-family:\\\'Ubuntu\\\', sans-serif;\\\">\n				<p align=\\\"justify\\\">&lt;p&gt;Este mensaje es solamente para la persona a la que va dirigido. Puede contener informaci&amp;oacute;n confidencial o legalmente protegida. No hay renuncia a la confidencialidad o privilegio por cualquier transmisi&amp;oacute;n mala o err&amp;oacute;nea. Si usted ha recibido este mensaje por error, le rogamos que borre de su sistema inmediatamente el mensaje as&amp;iacute; como todas sus copias, destruya todas las copias del mismo de su disco duro y notifique al remitente. No debe, directa o indirectamente, usar, revelar, distribuir, imprimir o copiar ninguna de las partes de este mensaje si no es usted el destinatario. Cualquier opini&amp;oacute;n expresada en este mensaje proviene del remitente, excepto cuando el mensaje establezca lo contrario y el remitente esta autorizado para establecer que dichas opiniones provienen de [A&amp;ntilde;adirNombre]. N&amp;oacute;tese que el correo electr&amp;oacute;nico v&amp;iacute;a Internet no permite asegurar ni la confidencialidad de los mensajes que se transmiten ni la correcta recepci&amp;oacute;n de los mismos. En el caso de que el destinatario de este mensaje no consintiera la utilizaci&amp;oacute;n del correo electr&amp;oacute;nico v&amp;iacute;a Internet, rogamos lo ponga en nuestro conocimiento de manera inmediata.&lt;/p&gt;</p>\n				\n			</div>\n		</div>\n	</body>\n</html>',0,'null',1,'2025-05-15 09:45:31','Solicitud aceptada'),
(83,'admin@centro.factuley.com','gundelagustina@gmail.com','<!DOCTYPE html>\n<html lang=\\\"es\\\">\n	<head>\n	<title>Solicitud de acceso - Plataforma [A&ntilde;adirNombre]</title>\n		<meta charset=\\\"UTF-8\\\">\n		<link href=\\\"https://fonts.googleapis.com/css?family=Ubuntu:300\\\" rel=\\\"stylesheet\\\" />\n		<link href=\\\"https://fonts.googleapis.com/css?family=Ubuntu:400,500&display=swap\\\" rel=\\\"stylesheet\\\" />\n        <meta name=\\\"viewport\\\" content=\\\"user-scalable=no, width=device-width, initial-scale=1\\\">\n	</head>\n	<body style=\\\"margin:0px;padding:0px;font-family:\\\'Ubuntu\\\', sans-serif;\\\">\n		<div style=\\\"max-width:700px;margin: auto;height:auto;overflow:hidden;\\\">\n			<div style=\\\"width:100%;height:120px;overflow:hidden;\\\">\n				<img src=\\\"https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\" style=\\\"width:100%;\\\">\n			</div>\n			<div style=\\\"width:auto;padding:0px 25px;\\\">\n				\n				<h1 style=\\\"color:#4d4d4d;font-size:18pt;font-family:\\\'Ubuntu\\\', sans-serif;font-weight:400;\\\">Hola Agustina Cuarterola</h1>\n				<div style=\\\"width:100%;height:auto;font-weight:300;font-size:14pt;color:#4d4d4d;font-family:\\\'Ubuntu\\\', sans-serif;\\\">\n\n\n					<p>Su solicitud ha sido aceptada por parte del departamento de [A&ntilde;adirNombre]</p>\n	\n				</div>\n				\n			</div>\n		\n			<div style=\\\"max-width:100%;margin:auto;color:#abadae;font-size:11pt;font-family:\\\'Ubuntu\\\', sans-serif;\\\">\n				<p align=\\\"justify\\\">&lt;p&gt;Este mensaje es solamente para la persona a la que va dirigido. Puede contener informaci&amp;oacute;n confidencial o legalmente protegida. No hay renuncia a la confidencialidad o privilegio por cualquier transmisi&amp;oacute;n mala o err&amp;oacute;nea. Si usted ha recibido este mensaje por error, le rogamos que borre de su sistema inmediatamente el mensaje as&amp;iacute; como todas sus copias, destruya todas las copias del mismo de su disco duro y notifique al remitente. No debe, directa o indirectamente, usar, revelar, distribuir, imprimir o copiar ninguna de las partes de este mensaje si no es usted el destinatario. Cualquier opini&amp;oacute;n expresada en este mensaje proviene del remitente, excepto cuando el mensaje establezca lo contrario y el remitente esta autorizado para establecer que dichas opiniones provienen de [A&amp;ntilde;adirNombre]. N&amp;oacute;tese que el correo electr&amp;oacute;nico v&amp;iacute;a Internet no permite asegurar ni la confidencialidad de los mensajes que se transmiten ni la correcta recepci&amp;oacute;n de los mismos. En el caso de que el destinatario de este mensaje no consintiera la utilizaci&amp;oacute;n del correo electr&amp;oacute;nico v&amp;iacute;a Internet, rogamos lo ponga en nuestro conocimiento de manera inmediata.&lt;/p&gt;</p>\n				\n			</div>\n		</div>\n	</body>\n</html>',0,'null',1,'2025-05-15 09:48:30','Solicitud aceptada'),
(84,'admin@centro.factuley.com','llruben_gm@hotmail.com','<p>Hola Andres, &iquest;necesitas de un servicio digital? Cada una de nuestras areas se encuentra formado por diversos expertos para m&aacute;ximizar y asegurar el &eacute;xito. Ayudamos a nuestros clientes a ser m&aacute;s competitivos mediante una dedicaci&oacute;n comprometida, innovadora y eficaz basada en la confianza.</p>\r\n<p>Puede consultar por nuestros servicios&nbsp;<a href=\\\"https://empiresystems.io/\\\">empiresystems.io</a></p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<!-- Fallback force center content -->\r\n<div style=\\\"text-align: center;\\\">\r\n<table style=\\\"text-align: center; vertical-align: top; width: 592px; max-width: 600px; background-color: #3f3f3f;\\\" width=\\\"592\\\" cellpadding=\\\"0px\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 592px; vertical-align: top; padding: 0px;\\\"><!-- Your logo  is here --> <!--\r\n            <img style=\\\"width: 200px; max-width: 200px; height: 70px; max-height: 70px; text-align: center; color: #ffffff;\\\" alt=\\\"Logo\\\" src=\\\"https://64.media.tumblr.com/dfe839d12d891dc4b73f0f29da62fa49/tumblr_inline_sc3yl3BwJh1rfe0n6_500.jpg\\\" align=\\\"center\\\" width=\\\"600\\\" height=\\\"170\\\">\r\n            <!-- Your logo 2 is here --> <!--   <img style=\\\"width: 600px; max-width: 600px; height: 200px; max-height: 200px; text-align: center; color: #fcf6df;\\\" alt=\\\"Logo\\\" src=\\\"https://64.media.tumblr.com/77b0199f657ba1688b57394272b58e9b/tumblr_inline_sc42vq6ffd1rfe0n6_500.jpg\\\" align=\\\"center\\\" width=\\\"800\\\" height=\\\"300\\\">\r\n <!-- Your logo 3 is here --> <img style=\\\"max-width: 200px; max-height: 100px; text-align: center; color: #ffffff;\\\" src=\\\"image.php?id=ix7XQcvhzdaaoqIPXeSEtgIO7\\\" alt=\\\"Logo\\\" width=\\\"240\\\" height=\\\"49\\\" align=\\\"middle\\\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<!-- End container for logo --> <!-- Hero image --> <br /><!-- Hero image --> <!-- Start single column section -->\r\n<table style=\\\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #ffffff;\\\" width=\\\"600\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 596px; vertical-align: top; padding: 30px 30px 40px 30px;\\\" width=\\\"596\\\">\r\n<div class=\\\"caja\\\">\r\n<p class=\\\"pretitulo wow fadeInUp\\\" data-wow-duration=\\\"1s\\\" data-wow-delay=\\\"0.3s\\\" data-wow-offset=\\\"100\\\">&iexcl;&iexcl;BIENVENIDO!!</p>\r\n</div>\r\n<div class=\\\"centrado centrado relative\\\">\r\n<div class=\\\"caja_h3 caja\\\">\r\n<h3 class=\\\"h3 wow fadeInUp\\\" data-wow-duration=\\\"1s\\\" data-wow-delay=\\\"0.6s\\\" data-wow-offset=\\\"100\\\">Tenemos el veh&iacute;culo que est&aacute; buscando</h3>\r\n</div>\r\n</div>\r\n<p><strong>Dilucars Autom&oacute;viles, S.L.</strong>&nbsp;empresa dedicada a la venta de&nbsp;<strong>veh&iacute;culos de ocasi&oacute;n</strong>, inicia su actividad el&nbsp;<strong>10 de diciembre de</strong>&nbsp;<strong>2007&nbsp;</strong>abriendo su primera exposici&oacute;n en una de las calles de mayor crecimiento y desarrollo econ&oacute;mico de la ciudad de Las Palmas de G.C en la&nbsp;<strong>Avda. Pintor Felo Monz&oacute;n,17 Portal 9 Bajo - 7 Palmas</strong>.</p>\r\n<p>Prueba de&nbsp;nuestra profesionalidad, seguridad en la compra a nuestros clientes y garant&iacute;a, nos llevan a seguir en el mercado a&ntilde;os m&aacute;s tarde. En febrero de&nbsp;<strong>2021 abrimos nuevas instalaciones</strong>&nbsp;tambi&eacute;n en Las Palmas de Gran Canaria en la&nbsp;<strong>C/ Arguineg&uuml;&iacute;n, 23 - Pol&iacute;gono Industrial Lomo Blanco - Las Torres (frente a la ITV)</strong>. Entre ambas exposiciones ofrecemos m&aacute;s de&nbsp;<strong>750 metros cuadrados&nbsp;</strong>y un amplio stock de&nbsp;<strong>veh&iacute;culos para elegir</strong>.</p>\r\n<h3>Le queremos agradecer su tiempo en la visita a nuestra web y le invitamos a conocer nuestro Stock y nuestra pol&iacute;tica de empresa.</h3>\r\n<p style=\\\"font-size: 15px; line-height: 24px; font-family: Releway, sans-serif; font-weight: 400; text-decoration: none; color: #919293; text-align: justify;\\\">Nuestra especialidad, es la venta de veh&iacute;culos seminuevos que han sido seleccionados para usted, por cubrir unos requisitos indispensables de bajo kilometraje, antig&uuml;edad no superior a 40 meses y totalmente revisados y garantizados.</p>\r\n<h2><span style=\\\"color: #3366ff;\\\"><strong><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.empiresystems.io\\\">empiresystems.io</a></strong><!-- Start container for logo --></span></h2>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h2><span style=\\\"color: #3366ff;\\\"><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.dilucars.com/\\\"><!-- End single column section --> <!-- Start image --> </a></span></h2>\r\n<h4><span style=\\\"color: #3366ff;\\\"><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.dilucars.com/\\\"><!-- End image --> <!-- Start footer --></a></span></h4>\r\n<table style=\\\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #3f3f3f;\\\" width=\\\"600\\\" cellpadding=\\\"15px 30px\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 600px; vertical-align: top; padding: 15px 30px 15px 30px;\\\" width=\\\"600\\\">\r\n<h4><!-- Your inverted logo is here --></h4>\r\n<span style=\\\"color: #ffffff;\\\">infomx@empiresystems.io</span>\r\n<h4 style=\\\"font-size: 12px; line-height: 12px; font-family: \\\'Raleway\\\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\\\">&nbsp;</h4>\r\n<h4 style=\\\"font-size: 11px; line-height: 20px; font-family: \\\'Helvetica\\\', Arial, sans-serif; font-weight: 400; text-decoration: none; color: #000000;\\\"><span style=\\\"color: #ffffff;\\\">No quieres recibir m&aacute;s correos electr&oacute;nicos?</span></h4>\r\n<p>&nbsp;</p>\r\n<h4 style=\\\"margin-bottom: 0; font-size: 17px; line-height: 24px; font-family: \\\'Releway\\\', Releway, sans-serif; font-weight: 400; text-decoration: none; color: #ffffff;\\\">&nbsp;</h4>\r\n<h4 style=\\\"font-size: 12px; line-height: 12px; font-family: \\\'Raleway\\\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\\\">&nbsp;</h4>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>',0,'null',1,'2025-05-15 10:03:57','promoción'),
(85,'admin@centro.factuley.com','fede.gundel@gmail.com','<p>Hola Federico, &iquest;necesitas de un servicio digital? Cada una de nuestras areas se encuentra formado por diversos expertos para m&aacute;ximizar y asegurar el &eacute;xito. Ayudamos a nuestros clientes a ser m&aacute;s competitivos mediante una dedicaci&oacute;n comprometida, innovadora y eficaz basada en la confianza.</p>\r\n<p>Puede consultar por nuestros servicios&nbsp;<a href=\\\"https://empiresystems.io/\\\">empiresystems.io</a></p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<!-- Fallback force center content -->\r\n<div style=\\\"text-align: center;\\\">\r\n<table style=\\\"text-align: center; vertical-align: top; width: 592px; max-width: 600px; background-color: #3f3f3f;\\\" width=\\\"592\\\" cellpadding=\\\"0px\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 592px; vertical-align: top; padding: 0px;\\\"><!-- Your logo  is here --> <!--\r\n            <img style=\\\"width: 200px; max-width: 200px; height: 70px; max-height: 70px; text-align: center; color: #ffffff;\\\" alt=\\\"Logo\\\" src=\\\"https://64.media.tumblr.com/dfe839d12d891dc4b73f0f29da62fa49/tumblr_inline_sc3yl3BwJh1rfe0n6_500.jpg\\\" align=\\\"center\\\" width=\\\"600\\\" height=\\\"170\\\">\r\n            <!-- Your logo 2 is here --> <!--   <img style=\\\"width: 600px; max-width: 600px; height: 200px; max-height: 200px; text-align: center; color: #fcf6df;\\\" alt=\\\"Logo\\\" src=\\\"https://64.media.tumblr.com/77b0199f657ba1688b57394272b58e9b/tumblr_inline_sc42vq6ffd1rfe0n6_500.jpg\\\" align=\\\"center\\\" width=\\\"800\\\" height=\\\"300\\\">\r\n <!-- Your logo 3 is here --> <img style=\\\"max-width: 200px; max-height: 100px; text-align: center; color: #ffffff;\\\" src=\\\"image.php?id=ix7XQcvhzdaaoqIPXeSEtgIO7\\\" alt=\\\"Logo\\\" width=\\\"240\\\" height=\\\"49\\\" align=\\\"middle\\\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<!-- End container for logo --> <!-- Hero image --> <br /><!-- Hero image --> <!-- Start single column section -->\r\n<table style=\\\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #ffffff;\\\" width=\\\"600\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 596px; vertical-align: top; padding: 30px 30px 40px 30px;\\\" width=\\\"596\\\">\r\n<div class=\\\"caja\\\">\r\n<p class=\\\"pretitulo wow fadeInUp\\\" data-wow-duration=\\\"1s\\\" data-wow-delay=\\\"0.3s\\\" data-wow-offset=\\\"100\\\">&iexcl;&iexcl;BIENVENIDO!!</p>\r\n</div>\r\n<div class=\\\"centrado centrado relative\\\">\r\n<div class=\\\"caja_h3 caja\\\">\r\n<h3 class=\\\"h3 wow fadeInUp\\\" data-wow-duration=\\\"1s\\\" data-wow-delay=\\\"0.6s\\\" data-wow-offset=\\\"100\\\">Tenemos el veh&iacute;culo que est&aacute; buscando</h3>\r\n</div>\r\n</div>\r\n<p><strong>Dilucars Autom&oacute;viles, S.L.</strong>&nbsp;empresa dedicada a la venta de&nbsp;<strong>veh&iacute;culos de ocasi&oacute;n</strong>, inicia su actividad el&nbsp;<strong>10 de diciembre de</strong>&nbsp;<strong>2007&nbsp;</strong>abriendo su primera exposici&oacute;n en una de las calles de mayor crecimiento y desarrollo econ&oacute;mico de la ciudad de Las Palmas de G.C en la&nbsp;<strong>Avda. Pintor Felo Monz&oacute;n,17 Portal 9 Bajo - 7 Palmas</strong>.</p>\r\n<p>Prueba de&nbsp;nuestra profesionalidad, seguridad en la compra a nuestros clientes y garant&iacute;a, nos llevan a seguir en el mercado a&ntilde;os m&aacute;s tarde. En febrero de&nbsp;<strong>2021 abrimos nuevas instalaciones</strong>&nbsp;tambi&eacute;n en Las Palmas de Gran Canaria en la&nbsp;<strong>C/ Arguineg&uuml;&iacute;n, 23 - Pol&iacute;gono Industrial Lomo Blanco - Las Torres (frente a la ITV)</strong>. Entre ambas exposiciones ofrecemos m&aacute;s de&nbsp;<strong>750 metros cuadrados&nbsp;</strong>y un amplio stock de&nbsp;<strong>veh&iacute;culos para elegir</strong>.</p>\r\n<h3>Le queremos agradecer su tiempo en la visita a nuestra web y le invitamos a conocer nuestro Stock y nuestra pol&iacute;tica de empresa.</h3>\r\n<p style=\\\"font-size: 15px; line-height: 24px; font-family: Releway, sans-serif; font-weight: 400; text-decoration: none; color: #919293; text-align: justify;\\\">Nuestra especialidad, es la venta de veh&iacute;culos seminuevos que han sido seleccionados para usted, por cubrir unos requisitos indispensables de bajo kilometraje, antig&uuml;edad no superior a 40 meses y totalmente revisados y garantizados.</p>\r\n<h2><span style=\\\"color: #3366ff;\\\"><strong><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.empiresystems.io\\\">empiresystems.io</a></strong><!-- Start container for logo --></span></h2>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h2><span style=\\\"color: #3366ff;\\\"><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.dilucars.com/\\\"><!-- End single column section --> <!-- Start image --> </a></span></h2>\r\n<h4><span style=\\\"color: #3366ff;\\\"><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.dilucars.com/\\\"><!-- End image --> <!-- Start footer --></a></span></h4>\r\n<table style=\\\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #3f3f3f;\\\" width=\\\"600\\\" cellpadding=\\\"15px 30px\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 600px; vertical-align: top; padding: 15px 30px 15px 30px;\\\" width=\\\"600\\\">\r\n<h4><!-- Your inverted logo is here --></h4>\r\n<span style=\\\"color: #ffffff;\\\">infomx@empiresystems.io</span>\r\n<h4 style=\\\"font-size: 12px; line-height: 12px; font-family: \\\'Raleway\\\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\\\">&nbsp;</h4>\r\n<h4 style=\\\"font-size: 11px; line-height: 20px; font-family: \\\'Helvetica\\\', Arial, sans-serif; font-weight: 400; text-decoration: none; color: #000000;\\\"><span style=\\\"color: #ffffff;\\\">No quieres recibir m&aacute;s correos electr&oacute;nicos?</span></h4>\r\n<p>&nbsp;</p>\r\n<h4 style=\\\"margin-bottom: 0; font-size: 17px; line-height: 24px; font-family: \\\'Releway\\\', Releway, sans-serif; font-weight: 400; text-decoration: none; color: #ffffff;\\\">&nbsp;</h4>\r\n<h4 style=\\\"font-size: 12px; line-height: 12px; font-family: \\\'Raleway\\\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\\\">&nbsp;</h4>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>',0,'null',1,'2025-05-15 10:03:58','promoción'),
(86,'admin@centro.factuley.com','11@limidata.com','<p>Hola Paco, &iquest;necesitas de un servicio digital? Cada una de nuestras areas se encuentra formado por diversos expertos para m&aacute;ximizar y asegurar el &eacute;xito. Ayudamos a nuestros clientes a ser m&aacute;s competitivos mediante una dedicaci&oacute;n comprometida, innovadora y eficaz basada en la confianza.</p>\r\n<p>Puede consultar por nuestros servicios&nbsp;<a href=\\\"https://empiresystems.io/\\\">empiresystems.io</a></p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<!-- Fallback force center content -->\r\n<div style=\\\"text-align: center;\\\">\r\n<table style=\\\"text-align: center; vertical-align: top; width: 592px; max-width: 600px; background-color: #3f3f3f;\\\" width=\\\"592\\\" cellpadding=\\\"0px\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 592px; vertical-align: top; padding: 0px;\\\"><!-- Your logo  is here --> <!--\r\n            <img style=\\\"width: 200px; max-width: 200px; height: 70px; max-height: 70px; text-align: center; color: #ffffff;\\\" alt=\\\"Logo\\\" src=\\\"https://64.media.tumblr.com/dfe839d12d891dc4b73f0f29da62fa49/tumblr_inline_sc3yl3BwJh1rfe0n6_500.jpg\\\" align=\\\"center\\\" width=\\\"600\\\" height=\\\"170\\\">\r\n            <!-- Your logo 2 is here --> <!--   <img style=\\\"width: 600px; max-width: 600px; height: 200px; max-height: 200px; text-align: center; color: #fcf6df;\\\" alt=\\\"Logo\\\" src=\\\"https://64.media.tumblr.com/77b0199f657ba1688b57394272b58e9b/tumblr_inline_sc42vq6ffd1rfe0n6_500.jpg\\\" align=\\\"center\\\" width=\\\"800\\\" height=\\\"300\\\">\r\n <!-- Your logo 3 is here --> <img style=\\\"max-width: 200px; max-height: 100px; text-align: center; color: #ffffff;\\\" src=\\\"image.php?id=ix7XQcvhzdaaoqIPXeSEtgIO7\\\" alt=\\\"Logo\\\" width=\\\"240\\\" height=\\\"49\\\" align=\\\"middle\\\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<!-- End container for logo --> <!-- Hero image --> <br /><!-- Hero image --> <!-- Start single column section -->\r\n<table style=\\\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #ffffff;\\\" width=\\\"600\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 596px; vertical-align: top; padding: 30px 30px 40px 30px;\\\" width=\\\"596\\\">\r\n<div class=\\\"caja\\\">\r\n<p class=\\\"pretitulo wow fadeInUp\\\" data-wow-duration=\\\"1s\\\" data-wow-delay=\\\"0.3s\\\" data-wow-offset=\\\"100\\\">&iexcl;&iexcl;BIENVENIDO!!</p>\r\n</div>\r\n<div class=\\\"centrado centrado relative\\\">\r\n<div class=\\\"caja_h3 caja\\\">\r\n<h3 class=\\\"h3 wow fadeInUp\\\" data-wow-duration=\\\"1s\\\" data-wow-delay=\\\"0.6s\\\" data-wow-offset=\\\"100\\\">Tenemos el veh&iacute;culo que est&aacute; buscando</h3>\r\n</div>\r\n</div>\r\n<p><strong>Dilucars Autom&oacute;viles, S.L.</strong>&nbsp;empresa dedicada a la venta de&nbsp;<strong>veh&iacute;culos de ocasi&oacute;n</strong>, inicia su actividad el&nbsp;<strong>10 de diciembre de</strong>&nbsp;<strong>2007&nbsp;</strong>abriendo su primera exposici&oacute;n en una de las calles de mayor crecimiento y desarrollo econ&oacute;mico de la ciudad de Las Palmas de G.C en la&nbsp;<strong>Avda. Pintor Felo Monz&oacute;n,17 Portal 9 Bajo - 7 Palmas</strong>.</p>\r\n<p>Prueba de&nbsp;nuestra profesionalidad, seguridad en la compra a nuestros clientes y garant&iacute;a, nos llevan a seguir en el mercado a&ntilde;os m&aacute;s tarde. En febrero de&nbsp;<strong>2021 abrimos nuevas instalaciones</strong>&nbsp;tambi&eacute;n en Las Palmas de Gran Canaria en la&nbsp;<strong>C/ Arguineg&uuml;&iacute;n, 23 - Pol&iacute;gono Industrial Lomo Blanco - Las Torres (frente a la ITV)</strong>. Entre ambas exposiciones ofrecemos m&aacute;s de&nbsp;<strong>750 metros cuadrados&nbsp;</strong>y un amplio stock de&nbsp;<strong>veh&iacute;culos para elegir</strong>.</p>\r\n<h3>Le queremos agradecer su tiempo en la visita a nuestra web y le invitamos a conocer nuestro Stock y nuestra pol&iacute;tica de empresa.</h3>\r\n<p style=\\\"font-size: 15px; line-height: 24px; font-family: Releway, sans-serif; font-weight: 400; text-decoration: none; color: #919293; text-align: justify;\\\">Nuestra especialidad, es la venta de veh&iacute;culos seminuevos que han sido seleccionados para usted, por cubrir unos requisitos indispensables de bajo kilometraje, antig&uuml;edad no superior a 40 meses y totalmente revisados y garantizados.</p>\r\n<h2><span style=\\\"color: #3366ff;\\\"><strong><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.empiresystems.io\\\">empiresystems.io</a></strong><!-- Start container for logo --></span></h2>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h2><span style=\\\"color: #3366ff;\\\"><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.dilucars.com/\\\"><!-- End single column section --> <!-- Start image --> </a></span></h2>\r\n<h4><span style=\\\"color: #3366ff;\\\"><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.dilucars.com/\\\"><!-- End image --> <!-- Start footer --></a></span></h4>\r\n<table style=\\\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #3f3f3f;\\\" width=\\\"600\\\" cellpadding=\\\"15px 30px\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 600px; vertical-align: top; padding: 15px 30px 15px 30px;\\\" width=\\\"600\\\">\r\n<h4><!-- Your inverted logo is here --></h4>\r\n<span style=\\\"color: #ffffff;\\\">infomx@empiresystems.io</span>\r\n<h4 style=\\\"font-size: 12px; line-height: 12px; font-family: \\\'Raleway\\\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\\\">&nbsp;</h4>\r\n<h4 style=\\\"font-size: 11px; line-height: 20px; font-family: \\\'Helvetica\\\', Arial, sans-serif; font-weight: 400; text-decoration: none; color: #000000;\\\"><span style=\\\"color: #ffffff;\\\">No quieres recibir m&aacute;s correos electr&oacute;nicos?</span></h4>\r\n<p>&nbsp;</p>\r\n<h4 style=\\\"margin-bottom: 0; font-size: 17px; line-height: 24px; font-family: \\\'Releway\\\', Releway, sans-serif; font-weight: 400; text-decoration: none; color: #ffffff;\\\">&nbsp;</h4>\r\n<h4 style=\\\"font-size: 12px; line-height: 12px; font-family: \\\'Raleway\\\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\\\">&nbsp;</h4>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>',0,'null',1,'2025-05-15 10:03:59','promoción'),
(87,'admin@centro.factuley.com','llruben_gm@hotmail.com','<p>Hola Andres, &iquest;necesitas de un servicio digital? Cada una de nuestras areas se encuentra formado por diversos expertos para m&aacute;ximizar y asegurar el &eacute;xito. Ayudamos a nuestros clientes a ser m&aacute;s competitivos mediante una dedicaci&oacute;n comprometida, innovadora y eficaz basada en la confianza.</p>\r\n<p>Puede consultar por nuestros servicios&nbsp;<a href=\\\"https://empiresystems.io/\\\">empiresystems.io</a></p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<!-- Fallback force center content -->\r\n<div style=\\\"text-align: center;\\\">\r\n<table style=\\\"text-align: center; vertical-align: top; width: 592px; max-width: 600px; background-color: #3f3f3f;\\\" width=\\\"592\\\" cellpadding=\\\"0px\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 592px; vertical-align: top; padding: 0px;\\\"><!-- Your logo  is here --> <!--\r\n            <img style=\\\"width: 200px; max-width: 200px; height: 70px; max-height: 70px; text-align: center; color: #ffffff;\\\" alt=\\\"Logo\\\" src=\\\"https://64.media.tumblr.com/dfe839d12d891dc4b73f0f29da62fa49/tumblr_inline_sc3yl3BwJh1rfe0n6_500.jpg\\\" align=\\\"center\\\" width=\\\"600\\\" height=\\\"170\\\">\r\n            <!-- Your logo 2 is here --> <!--   <img style=\\\"width: 600px; max-width: 600px; height: 200px; max-height: 200px; text-align: center; color: #fcf6df;\\\" alt=\\\"Logo\\\" src=\\\"https://64.media.tumblr.com/77b0199f657ba1688b57394272b58e9b/tumblr_inline_sc42vq6ffd1rfe0n6_500.jpg\\\" align=\\\"center\\\" width=\\\"800\\\" height=\\\"300\\\">\r\n <!-- Your logo 3 is here --> <img style=\\\"max-width: 200px; max-height: 100px; text-align: center; color: #ffffff;\\\" src=\\\"image.php?id=ix7XQcvhzdaaoqIPXeSEtgIO7\\\" alt=\\\"Logo\\\" width=\\\"240\\\" height=\\\"49\\\" align=\\\"middle\\\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<!-- End container for logo --> <!-- Hero image --> <br /><!-- Hero image --> <!-- Start single column section -->\r\n<table style=\\\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #ffffff;\\\" width=\\\"600\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 596px; vertical-align: top; padding: 30px 30px 40px 30px;\\\" width=\\\"596\\\">\r\n<div class=\\\"caja\\\">\r\n<p class=\\\"pretitulo wow fadeInUp\\\" data-wow-duration=\\\"1s\\\" data-wow-delay=\\\"0.3s\\\" data-wow-offset=\\\"100\\\">&iexcl;&iexcl;BIENVENIDO!!</p>\r\n</div>\r\n<div class=\\\"centrado centrado relative\\\">\r\n<div class=\\\"caja_h3 caja\\\">\r\n<h3 class=\\\"h3 wow fadeInUp\\\" data-wow-duration=\\\"1s\\\" data-wow-delay=\\\"0.6s\\\" data-wow-offset=\\\"100\\\">Tenemos el veh&iacute;culo que est&aacute; buscando</h3>\r\n</div>\r\n</div>\r\n<p><strong>Dilucars Autom&oacute;viles, S.L.</strong>&nbsp;empresa dedicada a la venta de&nbsp;<strong>veh&iacute;culos de ocasi&oacute;n</strong>, inicia su actividad el&nbsp;<strong>10 de diciembre de</strong>&nbsp;<strong>2007&nbsp;</strong>abriendo su primera exposici&oacute;n en una de las calles de mayor crecimiento y desarrollo econ&oacute;mico de la ciudad de Las Palmas de G.C en la&nbsp;<strong>Avda. Pintor Felo Monz&oacute;n,17 Portal 9 Bajo - 7 Palmas</strong>.</p>\r\n<p>Prueba de&nbsp;nuestra profesionalidad, seguridad en la compra a nuestros clientes y garant&iacute;a, nos llevan a seguir en el mercado a&ntilde;os m&aacute;s tarde. En febrero de&nbsp;<strong>2021 abrimos nuevas instalaciones</strong>&nbsp;tambi&eacute;n en Las Palmas de Gran Canaria en la&nbsp;<strong>C/ Arguineg&uuml;&iacute;n, 23 - Pol&iacute;gono Industrial Lomo Blanco - Las Torres (frente a la ITV)</strong>. Entre ambas exposiciones ofrecemos m&aacute;s de&nbsp;<strong>750 metros cuadrados&nbsp;</strong>y un amplio stock de&nbsp;<strong>veh&iacute;culos para elegir</strong>.</p>\r\n<h3>Le queremos agradecer su tiempo en la visita a nuestra web y le invitamos a conocer nuestro Stock y nuestra pol&iacute;tica de empresa.</h3>\r\n<p style=\\\"font-size: 15px; line-height: 24px; font-family: Releway, sans-serif; font-weight: 400; text-decoration: none; color: #919293; text-align: justify;\\\">Nuestra especialidad, es la venta de veh&iacute;culos seminuevos que han sido seleccionados para usted, por cubrir unos requisitos indispensables de bajo kilometraje, antig&uuml;edad no superior a 40 meses y totalmente revisados y garantizados.</p>\r\n<h2><span style=\\\"color: #3366ff;\\\"><strong><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.empiresystems.io\\\">empiresystems.io</a></strong><!-- Start container for logo --></span></h2>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h2><span style=\\\"color: #3366ff;\\\"><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.dilucars.com/\\\"><!-- End single column section --> <!-- Start image --> </a></span></h2>\r\n<h4><span style=\\\"color: #3366ff;\\\"><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.dilucars.com/\\\"><!-- End image --> <!-- Start footer --></a></span></h4>\r\n<table style=\\\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #3f3f3f;\\\" width=\\\"600\\\" cellpadding=\\\"15px 30px\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 600px; vertical-align: top; padding: 15px 30px 15px 30px;\\\" width=\\\"600\\\">\r\n<h4><!-- Your inverted logo is here --></h4>\r\n<span style=\\\"color: #ffffff;\\\">infomx@empiresystems.io</span>\r\n<h4 style=\\\"font-size: 12px; line-height: 12px; font-family: \\\'Raleway\\\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\\\">&nbsp;</h4>\r\n<h4 style=\\\"font-size: 11px; line-height: 20px; font-family: \\\'Helvetica\\\', Arial, sans-serif; font-weight: 400; text-decoration: none; color: #000000;\\\"><span style=\\\"color: #ffffff;\\\">No quieres recibir m&aacute;s correos electr&oacute;nicos?</span></h4>\r\n<p>&nbsp;</p>\r\n<h4 style=\\\"margin-bottom: 0; font-size: 17px; line-height: 24px; font-family: \\\'Releway\\\', Releway, sans-serif; font-weight: 400; text-decoration: none; color: #ffffff;\\\">&nbsp;</h4>\r\n<h4 style=\\\"font-size: 12px; line-height: 12px; font-family: \\\'Raleway\\\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\\\">&nbsp;</h4>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>',0,'null',1,'2025-05-15 10:06:13','promoción'),
(88,'admin@centro.factuley.com','fede.gundel@gmail.com','<p>Hola Federico, &iquest;necesitas de un servicio digital? Cada una de nuestras areas se encuentra formado por diversos expertos para m&aacute;ximizar y asegurar el &eacute;xito. Ayudamos a nuestros clientes a ser m&aacute;s competitivos mediante una dedicaci&oacute;n comprometida, innovadora y eficaz basada en la confianza.</p>\r\n<p>Puede consultar por nuestros servicios&nbsp;<a href=\\\"https://empiresystems.io/\\\">empiresystems.io</a></p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<!-- Fallback force center content -->\r\n<div style=\\\"text-align: center;\\\">\r\n<table style=\\\"text-align: center; vertical-align: top; width: 592px; max-width: 600px; background-color: #3f3f3f;\\\" width=\\\"592\\\" cellpadding=\\\"0px\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 592px; vertical-align: top; padding: 0px;\\\"><!-- Your logo  is here --> <!--\r\n            <img style=\\\"width: 200px; max-width: 200px; height: 70px; max-height: 70px; text-align: center; color: #ffffff;\\\" alt=\\\"Logo\\\" src=\\\"https://64.media.tumblr.com/dfe839d12d891dc4b73f0f29da62fa49/tumblr_inline_sc3yl3BwJh1rfe0n6_500.jpg\\\" align=\\\"center\\\" width=\\\"600\\\" height=\\\"170\\\">\r\n            <!-- Your logo 2 is here --> <!--   <img style=\\\"width: 600px; max-width: 600px; height: 200px; max-height: 200px; text-align: center; color: #fcf6df;\\\" alt=\\\"Logo\\\" src=\\\"https://64.media.tumblr.com/77b0199f657ba1688b57394272b58e9b/tumblr_inline_sc42vq6ffd1rfe0n6_500.jpg\\\" align=\\\"center\\\" width=\\\"800\\\" height=\\\"300\\\">\r\n <!-- Your logo 3 is here --> <img style=\\\"max-width: 200px; max-height: 100px; text-align: center; color: #ffffff;\\\" src=\\\"image.php?id=ix7XQcvhzdaaoqIPXeSEtgIO7\\\" alt=\\\"Logo\\\" width=\\\"240\\\" height=\\\"49\\\" align=\\\"middle\\\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<!-- End container for logo --> <!-- Hero image --> <br /><!-- Hero image --> <!-- Start single column section -->\r\n<table style=\\\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #ffffff;\\\" width=\\\"600\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 596px; vertical-align: top; padding: 30px 30px 40px 30px;\\\" width=\\\"596\\\">\r\n<div class=\\\"caja\\\">\r\n<p class=\\\"pretitulo wow fadeInUp\\\" data-wow-duration=\\\"1s\\\" data-wow-delay=\\\"0.3s\\\" data-wow-offset=\\\"100\\\">&iexcl;&iexcl;BIENVENIDO!!</p>\r\n</div>\r\n<div class=\\\"centrado centrado relative\\\">\r\n<div class=\\\"caja_h3 caja\\\">\r\n<h3 class=\\\"h3 wow fadeInUp\\\" data-wow-duration=\\\"1s\\\" data-wow-delay=\\\"0.6s\\\" data-wow-offset=\\\"100\\\">Tenemos el veh&iacute;culo que est&aacute; buscando</h3>\r\n</div>\r\n</div>\r\n<p><strong>Dilucars Autom&oacute;viles, S.L.</strong>&nbsp;empresa dedicada a la venta de&nbsp;<strong>veh&iacute;culos de ocasi&oacute;n</strong>, inicia su actividad el&nbsp;<strong>10 de diciembre de</strong>&nbsp;<strong>2007&nbsp;</strong>abriendo su primera exposici&oacute;n en una de las calles de mayor crecimiento y desarrollo econ&oacute;mico de la ciudad de Las Palmas de G.C en la&nbsp;<strong>Avda. Pintor Felo Monz&oacute;n,17 Portal 9 Bajo - 7 Palmas</strong>.</p>\r\n<p>Prueba de&nbsp;nuestra profesionalidad, seguridad en la compra a nuestros clientes y garant&iacute;a, nos llevan a seguir en el mercado a&ntilde;os m&aacute;s tarde. En febrero de&nbsp;<strong>2021 abrimos nuevas instalaciones</strong>&nbsp;tambi&eacute;n en Las Palmas de Gran Canaria en la&nbsp;<strong>C/ Arguineg&uuml;&iacute;n, 23 - Pol&iacute;gono Industrial Lomo Blanco - Las Torres (frente a la ITV)</strong>. Entre ambas exposiciones ofrecemos m&aacute;s de&nbsp;<strong>750 metros cuadrados&nbsp;</strong>y un amplio stock de&nbsp;<strong>veh&iacute;culos para elegir</strong>.</p>\r\n<h3>Le queremos agradecer su tiempo en la visita a nuestra web y le invitamos a conocer nuestro Stock y nuestra pol&iacute;tica de empresa.</h3>\r\n<p style=\\\"font-size: 15px; line-height: 24px; font-family: Releway, sans-serif; font-weight: 400; text-decoration: none; color: #919293; text-align: justify;\\\">Nuestra especialidad, es la venta de veh&iacute;culos seminuevos que han sido seleccionados para usted, por cubrir unos requisitos indispensables de bajo kilometraje, antig&uuml;edad no superior a 40 meses y totalmente revisados y garantizados.</p>\r\n<h2><span style=\\\"color: #3366ff;\\\"><strong><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.empiresystems.io\\\">empiresystems.io</a></strong><!-- Start container for logo --></span></h2>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h2><span style=\\\"color: #3366ff;\\\"><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.dilucars.com/\\\"><!-- End single column section --> <!-- Start image --> </a></span></h2>\r\n<h4><span style=\\\"color: #3366ff;\\\"><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.dilucars.com/\\\"><!-- End image --> <!-- Start footer --></a></span></h4>\r\n<table style=\\\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #3f3f3f;\\\" width=\\\"600\\\" cellpadding=\\\"15px 30px\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 600px; vertical-align: top; padding: 15px 30px 15px 30px;\\\" width=\\\"600\\\">\r\n<h4><!-- Your inverted logo is here --></h4>\r\n<span style=\\\"color: #ffffff;\\\">infomx@empiresystems.io</span>\r\n<h4 style=\\\"font-size: 12px; line-height: 12px; font-family: \\\'Raleway\\\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\\\">&nbsp;</h4>\r\n<h4 style=\\\"font-size: 11px; line-height: 20px; font-family: \\\'Helvetica\\\', Arial, sans-serif; font-weight: 400; text-decoration: none; color: #000000;\\\"><span style=\\\"color: #ffffff;\\\">No quieres recibir m&aacute;s correos electr&oacute;nicos?</span></h4>\r\n<p>&nbsp;</p>\r\n<h4 style=\\\"margin-bottom: 0; font-size: 17px; line-height: 24px; font-family: \\\'Releway\\\', Releway, sans-serif; font-weight: 400; text-decoration: none; color: #ffffff;\\\">&nbsp;</h4>\r\n<h4 style=\\\"font-size: 12px; line-height: 12px; font-family: \\\'Raleway\\\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\\\">&nbsp;</h4>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>',0,'null',1,'2025-05-15 10:06:20','promoción'),
(89,'admin@centro.factuley.com','llruben_gm@hotmail.com','<p>Hola Andres, &iquest;necesitas de un servicio digital? Cada una de nuestras areas se encuentra formado por diversos expertos para m&aacute;ximizar y asegurar el &eacute;xito. Ayudamos a nuestros clientes a ser m&aacute;s competitivos mediante una dedicaci&oacute;n comprometida, innovadora y eficaz basada en la confianza.</p>\r\n<p>Puede consultar por nuestros servicios&nbsp;<a href=\\\"https://empiresystems.io/\\\">empiresystems.io</a></p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<!-- Fallback force center content -->\r\n<div style=\\\"text-align: center;\\\">\r\n<table style=\\\"text-align: center; vertical-align: top; width: 592px; max-width: 600px; background-color: #3f3f3f;\\\" width=\\\"592\\\" cellpadding=\\\"0px\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 592px; vertical-align: top; padding: 0px;\\\"><!-- Your logo  is here --> <!--\r\n            <img style=\\\"width: 200px; max-width: 200px; height: 70px; max-height: 70px; text-align: center; color: #ffffff;\\\" alt=\\\"Logo\\\" src=\\\"https://64.media.tumblr.com/dfe839d12d891dc4b73f0f29da62fa49/tumblr_inline_sc3yl3BwJh1rfe0n6_500.jpg\\\" align=\\\"center\\\" width=\\\"600\\\" height=\\\"170\\\">\r\n            <!-- Your logo 2 is here --> <!--   <img style=\\\"width: 600px; max-width: 600px; height: 200px; max-height: 200px; text-align: center; color: #fcf6df;\\\" alt=\\\"Logo\\\" src=\\\"https://64.media.tumblr.com/77b0199f657ba1688b57394272b58e9b/tumblr_inline_sc42vq6ffd1rfe0n6_500.jpg\\\" align=\\\"center\\\" width=\\\"800\\\" height=\\\"300\\\">\r\n <!-- Your logo 3 is here --> <img style=\\\"max-width: 200px; max-height: 100px; text-align: center; color: #ffffff;\\\" src=\\\"image.php?id=ix7XQcvhzdaaoqIPXeSEtgIO7\\\" alt=\\\"Logo\\\" width=\\\"240\\\" height=\\\"49\\\" align=\\\"middle\\\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<!-- End container for logo --> <!-- Hero image --> <br /><!-- Hero image --> <!-- Start single column section -->\r\n<table style=\\\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #ffffff;\\\" width=\\\"600\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 596px; vertical-align: top; padding: 30px 30px 40px 30px;\\\" width=\\\"596\\\">\r\n<div class=\\\"caja\\\">\r\n<p class=\\\"pretitulo wow fadeInUp\\\" data-wow-duration=\\\"1s\\\" data-wow-delay=\\\"0.3s\\\" data-wow-offset=\\\"100\\\">&iexcl;&iexcl;BIENVENIDO!!</p>\r\n</div>\r\n<div class=\\\"centrado centrado relative\\\">\r\n<div class=\\\"caja_h3 caja\\\">\r\n<h3 class=\\\"h3 wow fadeInUp\\\" data-wow-duration=\\\"1s\\\" data-wow-delay=\\\"0.6s\\\" data-wow-offset=\\\"100\\\">Tenemos el veh&iacute;culo que est&aacute; buscando</h3>\r\n</div>\r\n</div>\r\n<p><strong>Dilucars Autom&oacute;viles, S.L.</strong>&nbsp;empresa dedicada a la venta de&nbsp;<strong>veh&iacute;culos de ocasi&oacute;n</strong>, inicia su actividad el&nbsp;<strong>10 de diciembre de</strong>&nbsp;<strong>2007&nbsp;</strong>abriendo su primera exposici&oacute;n en una de las calles de mayor crecimiento y desarrollo econ&oacute;mico de la ciudad de Las Palmas de G.C en la&nbsp;<strong>Avda. Pintor Felo Monz&oacute;n,17 Portal 9 Bajo - 7 Palmas</strong>.</p>\r\n<p>Prueba de&nbsp;nuestra profesionalidad, seguridad en la compra a nuestros clientes y garant&iacute;a, nos llevan a seguir en el mercado a&ntilde;os m&aacute;s tarde. En febrero de&nbsp;<strong>2021 abrimos nuevas instalaciones</strong>&nbsp;tambi&eacute;n en Las Palmas de Gran Canaria en la&nbsp;<strong>C/ Arguineg&uuml;&iacute;n, 23 - Pol&iacute;gono Industrial Lomo Blanco - Las Torres (frente a la ITV)</strong>. Entre ambas exposiciones ofrecemos m&aacute;s de&nbsp;<strong>750 metros cuadrados&nbsp;</strong>y un amplio stock de&nbsp;<strong>veh&iacute;culos para elegir</strong>.</p>\r\n<h3>Le queremos agradecer su tiempo en la visita a nuestra web y le invitamos a conocer nuestro Stock y nuestra pol&iacute;tica de empresa.</h3>\r\n<p style=\\\"font-size: 15px; line-height: 24px; font-family: Releway, sans-serif; font-weight: 400; text-decoration: none; color: #919293; text-align: justify;\\\">Nuestra especialidad, es la venta de veh&iacute;culos seminuevos que han sido seleccionados para usted, por cubrir unos requisitos indispensables de bajo kilometraje, antig&uuml;edad no superior a 40 meses y totalmente revisados y garantizados.</p>\r\n<h2><span style=\\\"color: #3366ff;\\\"><strong><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.empiresystems.io\\\">empiresystems.io</a></strong><!-- Start container for logo --></span></h2>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h2><span style=\\\"color: #3366ff;\\\"><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.dilucars.com/\\\"><!-- End single column section --> <!-- Start image --> </a></span></h2>\r\n<h4><span style=\\\"color: #3366ff;\\\"><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.dilucars.com/\\\"><!-- End image --> <!-- Start footer --></a></span></h4>\r\n<table style=\\\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #3f3f3f;\\\" width=\\\"600\\\" cellpadding=\\\"15px 30px\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 600px; vertical-align: top; padding: 15px 30px 15px 30px;\\\" width=\\\"600\\\">\r\n<h4><!-- Your inverted logo is here --></h4>\r\n<span style=\\\"color: #ffffff;\\\">infomx@empiresystems.io</span>\r\n<h4 style=\\\"font-size: 12px; line-height: 12px; font-family: \\\'Raleway\\\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\\\">&nbsp;</h4>\r\n<h4 style=\\\"font-size: 11px; line-height: 20px; font-family: \\\'Helvetica\\\', Arial, sans-serif; font-weight: 400; text-decoration: none; color: #000000;\\\"><span style=\\\"color: #ffffff;\\\">No quieres recibir m&aacute;s correos electr&oacute;nicos?</span></h4>\r\n<p>&nbsp;</p>\r\n<h4 style=\\\"margin-bottom: 0; font-size: 17px; line-height: 24px; font-family: \\\'Releway\\\', Releway, sans-serif; font-weight: 400; text-decoration: none; color: #ffffff;\\\">&nbsp;</h4>\r\n<h4 style=\\\"font-size: 12px; line-height: 12px; font-family: \\\'Raleway\\\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\\\">&nbsp;</h4>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>',0,'null',1,'2025-05-15 10:06:52','promoción'),
(90,'admin@centro.factuley.com','fede.gundel@gmail.com','<p>Hola Federico, &iquest;necesitas de un servicio digital? Cada una de nuestras areas se encuentra formado por diversos expertos para m&aacute;ximizar y asegurar el &eacute;xito. Ayudamos a nuestros clientes a ser m&aacute;s competitivos mediante una dedicaci&oacute;n comprometida, innovadora y eficaz basada en la confianza.</p>\r\n<p>Puede consultar por nuestros servicios&nbsp;<a href=\\\"https://empiresystems.io/\\\">empiresystems.io</a></p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<!-- Fallback force center content -->\r\n<div style=\\\"text-align: center;\\\">\r\n<table style=\\\"text-align: center; vertical-align: top; width: 592px; max-width: 600px; background-color: #3f3f3f;\\\" width=\\\"592\\\" cellpadding=\\\"0px\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 592px; vertical-align: top; padding: 0px;\\\"><!-- Your logo  is here --> <!--\r\n            <img style=\\\"width: 200px; max-width: 200px; height: 70px; max-height: 70px; text-align: center; color: #ffffff;\\\" alt=\\\"Logo\\\" src=\\\"https://64.media.tumblr.com/dfe839d12d891dc4b73f0f29da62fa49/tumblr_inline_sc3yl3BwJh1rfe0n6_500.jpg\\\" align=\\\"center\\\" width=\\\"600\\\" height=\\\"170\\\">\r\n            <!-- Your logo 2 is here --> <!--   <img style=\\\"width: 600px; max-width: 600px; height: 200px; max-height: 200px; text-align: center; color: #fcf6df;\\\" alt=\\\"Logo\\\" src=\\\"https://64.media.tumblr.com/77b0199f657ba1688b57394272b58e9b/tumblr_inline_sc42vq6ffd1rfe0n6_500.jpg\\\" align=\\\"center\\\" width=\\\"800\\\" height=\\\"300\\\">\r\n <!-- Your logo 3 is here --> <img style=\\\"max-width: 200px; max-height: 100px; text-align: center; color: #ffffff;\\\" src=\\\"image.php?id=ix7XQcvhzdaaoqIPXeSEtgIO7\\\" alt=\\\"Logo\\\" width=\\\"240\\\" height=\\\"49\\\" align=\\\"middle\\\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<!-- End container for logo --> <!-- Hero image --> <br /><!-- Hero image --> <!-- Start single column section -->\r\n<table style=\\\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #ffffff;\\\" width=\\\"600\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 596px; vertical-align: top; padding: 30px 30px 40px 30px;\\\" width=\\\"596\\\">\r\n<div class=\\\"caja\\\">\r\n<p class=\\\"pretitulo wow fadeInUp\\\" data-wow-duration=\\\"1s\\\" data-wow-delay=\\\"0.3s\\\" data-wow-offset=\\\"100\\\">&iexcl;&iexcl;BIENVENIDO!!</p>\r\n</div>\r\n<div class=\\\"centrado centrado relative\\\">\r\n<div class=\\\"caja_h3 caja\\\">\r\n<h3 class=\\\"h3 wow fadeInUp\\\" data-wow-duration=\\\"1s\\\" data-wow-delay=\\\"0.6s\\\" data-wow-offset=\\\"100\\\">Tenemos el veh&iacute;culo que est&aacute; buscando</h3>\r\n</div>\r\n</div>\r\n<p><strong>Dilucars Autom&oacute;viles, S.L.</strong>&nbsp;empresa dedicada a la venta de&nbsp;<strong>veh&iacute;culos de ocasi&oacute;n</strong>, inicia su actividad el&nbsp;<strong>10 de diciembre de</strong>&nbsp;<strong>2007&nbsp;</strong>abriendo su primera exposici&oacute;n en una de las calles de mayor crecimiento y desarrollo econ&oacute;mico de la ciudad de Las Palmas de G.C en la&nbsp;<strong>Avda. Pintor Felo Monz&oacute;n,17 Portal 9 Bajo - 7 Palmas</strong>.</p>\r\n<p>Prueba de&nbsp;nuestra profesionalidad, seguridad en la compra a nuestros clientes y garant&iacute;a, nos llevan a seguir en el mercado a&ntilde;os m&aacute;s tarde. En febrero de&nbsp;<strong>2021 abrimos nuevas instalaciones</strong>&nbsp;tambi&eacute;n en Las Palmas de Gran Canaria en la&nbsp;<strong>C/ Arguineg&uuml;&iacute;n, 23 - Pol&iacute;gono Industrial Lomo Blanco - Las Torres (frente a la ITV)</strong>. Entre ambas exposiciones ofrecemos m&aacute;s de&nbsp;<strong>750 metros cuadrados&nbsp;</strong>y un amplio stock de&nbsp;<strong>veh&iacute;culos para elegir</strong>.</p>\r\n<h3>Le queremos agradecer su tiempo en la visita a nuestra web y le invitamos a conocer nuestro Stock y nuestra pol&iacute;tica de empresa.</h3>\r\n<p style=\\\"font-size: 15px; line-height: 24px; font-family: Releway, sans-serif; font-weight: 400; text-decoration: none; color: #919293; text-align: justify;\\\">Nuestra especialidad, es la venta de veh&iacute;culos seminuevos que han sido seleccionados para usted, por cubrir unos requisitos indispensables de bajo kilometraje, antig&uuml;edad no superior a 40 meses y totalmente revisados y garantizados.</p>\r\n<h2><span style=\\\"color: #3366ff;\\\"><strong><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.empiresystems.io\\\">empiresystems.io</a></strong><!-- Start container for logo --></span></h2>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h2><span style=\\\"color: #3366ff;\\\"><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.dilucars.com/\\\"><!-- End single column section --> <!-- Start image --> </a></span></h2>\r\n<h4><span style=\\\"color: #3366ff;\\\"><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.dilucars.com/\\\"><!-- End image --> <!-- Start footer --></a></span></h4>\r\n<table style=\\\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #3f3f3f;\\\" width=\\\"600\\\" cellpadding=\\\"15px 30px\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 600px; vertical-align: top; padding: 15px 30px 15px 30px;\\\" width=\\\"600\\\">\r\n<h4><!-- Your inverted logo is here --></h4>\r\n<span style=\\\"color: #ffffff;\\\">infomx@empiresystems.io</span>\r\n<h4 style=\\\"font-size: 12px; line-height: 12px; font-family: \\\'Raleway\\\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\\\">&nbsp;</h4>\r\n<h4 style=\\\"font-size: 11px; line-height: 20px; font-family: \\\'Helvetica\\\', Arial, sans-serif; font-weight: 400; text-decoration: none; color: #000000;\\\"><span style=\\\"color: #ffffff;\\\">No quieres recibir m&aacute;s correos electr&oacute;nicos?</span></h4>\r\n<p>&nbsp;</p>\r\n<h4 style=\\\"margin-bottom: 0; font-size: 17px; line-height: 24px; font-family: \\\'Releway\\\', Releway, sans-serif; font-weight: 400; text-decoration: none; color: #ffffff;\\\">&nbsp;</h4>\r\n<h4 style=\\\"font-size: 12px; line-height: 12px; font-family: \\\'Raleway\\\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\\\">&nbsp;</h4>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>',0,'null',1,'2025-05-15 10:06:53','promoción'),
(91,'admin@centro.factuley.com','11@limidata.com','<p>Hola Paco, &iquest;necesitas de un servicio digital? Cada una de nuestras areas se encuentra formado por diversos expertos para m&aacute;ximizar y asegurar el &eacute;xito. Ayudamos a nuestros clientes a ser m&aacute;s competitivos mediante una dedicaci&oacute;n comprometida, innovadora y eficaz basada en la confianza.</p>\r\n<p>Puede consultar por nuestros servicios&nbsp;<a href=\\\"https://empiresystems.io/\\\">empiresystems.io</a></p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<!-- Fallback force center content -->\r\n<div style=\\\"text-align: center;\\\">\r\n<table style=\\\"text-align: center; vertical-align: top; width: 592px; max-width: 600px; background-color: #3f3f3f;\\\" width=\\\"592\\\" cellpadding=\\\"0px\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 592px; vertical-align: top; padding: 0px;\\\"><!-- Your logo  is here --> <!--\r\n            <img style=\\\"width: 200px; max-width: 200px; height: 70px; max-height: 70px; text-align: center; color: #ffffff;\\\" alt=\\\"Logo\\\" src=\\\"https://64.media.tumblr.com/dfe839d12d891dc4b73f0f29da62fa49/tumblr_inline_sc3yl3BwJh1rfe0n6_500.jpg\\\" align=\\\"center\\\" width=\\\"600\\\" height=\\\"170\\\">\r\n            <!-- Your logo 2 is here --> <!--   <img style=\\\"width: 600px; max-width: 600px; height: 200px; max-height: 200px; text-align: center; color: #fcf6df;\\\" alt=\\\"Logo\\\" src=\\\"https://64.media.tumblr.com/77b0199f657ba1688b57394272b58e9b/tumblr_inline_sc42vq6ffd1rfe0n6_500.jpg\\\" align=\\\"center\\\" width=\\\"800\\\" height=\\\"300\\\">\r\n <!-- Your logo 3 is here --> <img style=\\\"max-width: 200px; max-height: 100px; text-align: center; color: #ffffff;\\\" src=\\\"image.php?id=ix7XQcvhzdaaoqIPXeSEtgIO7\\\" alt=\\\"Logo\\\" width=\\\"240\\\" height=\\\"49\\\" align=\\\"middle\\\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<!-- End container for logo --> <!-- Hero image --> <br /><!-- Hero image --> <!-- Start single column section -->\r\n<table style=\\\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #ffffff;\\\" width=\\\"600\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 596px; vertical-align: top; padding: 30px 30px 40px 30px;\\\" width=\\\"596\\\">\r\n<div class=\\\"caja\\\">\r\n<p class=\\\"pretitulo wow fadeInUp\\\" data-wow-duration=\\\"1s\\\" data-wow-delay=\\\"0.3s\\\" data-wow-offset=\\\"100\\\">&iexcl;&iexcl;BIENVENIDO!!</p>\r\n</div>\r\n<div class=\\\"centrado centrado relative\\\">\r\n<div class=\\\"caja_h3 caja\\\">\r\n<h3 class=\\\"h3 wow fadeInUp\\\" data-wow-duration=\\\"1s\\\" data-wow-delay=\\\"0.6s\\\" data-wow-offset=\\\"100\\\">Tenemos el veh&iacute;culo que est&aacute; buscando</h3>\r\n</div>\r\n</div>\r\n<p><strong>Dilucars Autom&oacute;viles, S.L.</strong>&nbsp;empresa dedicada a la venta de&nbsp;<strong>veh&iacute;culos de ocasi&oacute;n</strong>, inicia su actividad el&nbsp;<strong>10 de diciembre de</strong>&nbsp;<strong>2007&nbsp;</strong>abriendo su primera exposici&oacute;n en una de las calles de mayor crecimiento y desarrollo econ&oacute;mico de la ciudad de Las Palmas de G.C en la&nbsp;<strong>Avda. Pintor Felo Monz&oacute;n,17 Portal 9 Bajo - 7 Palmas</strong>.</p>\r\n<p>Prueba de&nbsp;nuestra profesionalidad, seguridad en la compra a nuestros clientes y garant&iacute;a, nos llevan a seguir en el mercado a&ntilde;os m&aacute;s tarde. En febrero de&nbsp;<strong>2021 abrimos nuevas instalaciones</strong>&nbsp;tambi&eacute;n en Las Palmas de Gran Canaria en la&nbsp;<strong>C/ Arguineg&uuml;&iacute;n, 23 - Pol&iacute;gono Industrial Lomo Blanco - Las Torres (frente a la ITV)</strong>. Entre ambas exposiciones ofrecemos m&aacute;s de&nbsp;<strong>750 metros cuadrados&nbsp;</strong>y un amplio stock de&nbsp;<strong>veh&iacute;culos para elegir</strong>.</p>\r\n<h3>Le queremos agradecer su tiempo en la visita a nuestra web y le invitamos a conocer nuestro Stock y nuestra pol&iacute;tica de empresa.</h3>\r\n<p style=\\\"font-size: 15px; line-height: 24px; font-family: Releway, sans-serif; font-weight: 400; text-decoration: none; color: #919293; text-align: justify;\\\">Nuestra especialidad, es la venta de veh&iacute;culos seminuevos que han sido seleccionados para usted, por cubrir unos requisitos indispensables de bajo kilometraje, antig&uuml;edad no superior a 40 meses y totalmente revisados y garantizados.</p>\r\n<h2><span style=\\\"color: #3366ff;\\\"><strong><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.empiresystems.io\\\">empiresystems.io</a></strong><!-- Start container for logo --></span></h2>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h2><span style=\\\"color: #3366ff;\\\"><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.dilucars.com/\\\"><!-- End single column section --> <!-- Start image --> </a></span></h2>\r\n<h4><span style=\\\"color: #3366ff;\\\"><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.dilucars.com/\\\"><!-- End image --> <!-- Start footer --></a></span></h4>\r\n<table style=\\\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #3f3f3f;\\\" width=\\\"600\\\" cellpadding=\\\"15px 30px\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 600px; vertical-align: top; padding: 15px 30px 15px 30px;\\\" width=\\\"600\\\">\r\n<h4><!-- Your inverted logo is here --></h4>\r\n<span style=\\\"color: #ffffff;\\\">infomx@empiresystems.io</span>\r\n<h4 style=\\\"font-size: 12px; line-height: 12px; font-family: \\\'Raleway\\\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\\\">&nbsp;</h4>\r\n<h4 style=\\\"font-size: 11px; line-height: 20px; font-family: \\\'Helvetica\\\', Arial, sans-serif; font-weight: 400; text-decoration: none; color: #000000;\\\"><span style=\\\"color: #ffffff;\\\">No quieres recibir m&aacute;s correos electr&oacute;nicos?</span></h4>\r\n<p>&nbsp;</p>\r\n<h4 style=\\\"margin-bottom: 0; font-size: 17px; line-height: 24px; font-family: \\\'Releway\\\', Releway, sans-serif; font-weight: 400; text-decoration: none; color: #ffffff;\\\">&nbsp;</h4>\r\n<h4 style=\\\"font-size: 12px; line-height: 12px; font-family: \\\'Raleway\\\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\\\">&nbsp;</h4>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>',0,'null',1,'2025-05-15 10:06:54','promoción'),
(92,'admin@centro.factuley.com','aaaa434342@gmail.com','<!DOCTYPE html>\n<html lang=\\\"es\\\">\n	<head>\n	<title>Solicitud de acceso - Plataforma [A&ntilde;adirNombre]</title>\n		<meta charset=\\\"UTF-8\\\">\n		<link href=\\\"https://fonts.googleapis.com/css?family=Ubuntu:300\\\" rel=\\\"stylesheet\\\" />\n		<link href=\\\"https://fonts.googleapis.com/css?family=Ubuntu:400,500&display=swap\\\" rel=\\\"stylesheet\\\" />\n        <meta name=\\\"viewport\\\" content=\\\"user-scalable=no, width=device-width, initial-scale=1\\\">\n	</head>\n	<body style=\\\"margin:0px;padding:0px;font-family:\\\'Ubuntu\\\', sans-serif;\\\">\n		<div style=\\\"max-width:700px;margin: auto;height:auto;overflow:hidden;\\\">\n			<div style=\\\"width:100%;height:120px;overflow:hidden;\\\">\n				<img src=\\\"https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\" style=\\\"width:100%;\\\">\n			</div>\n			<div style=\\\"width:auto;padding:0px 25px;\\\">\n				\n				<h1 style=\\\"color:#4d4d4d;font-size:18pt;font-family:\\\'Ubuntu\\\', sans-serif;font-weight:400;\\\">Hola Alberto Andreu</h1>\n				<div style=\\\"width:100%;height:auto;font-weight:300;font-size:14pt;color:#4d4d4d;font-family:\\\'Ubuntu\\\', sans-serif;\\\">\n\n\n					<p>Su solicitud ha sido aceptada por parte del departamento de [A&ntilde;adirNombre]</p>\n	\n				</div>\n				\n			</div>\n		\n			<div style=\\\"max-width:100%;margin:auto;color:#abadae;font-size:11pt;font-family:\\\'Ubuntu\\\', sans-serif;\\\">\n				<p align=\\\"justify\\\">&lt;p&gt;Este mensaje es solamente para la persona a la que va dirigido. Puede contener informaci&amp;oacute;n confidencial o legalmente protegida. No hay renuncia a la confidencialidad o privilegio por cualquier transmisi&amp;oacute;n mala o err&amp;oacute;nea. Si usted ha recibido este mensaje por error, le rogamos que borre de su sistema inmediatamente el mensaje as&amp;iacute; como todas sus copias, destruya todas las copias del mismo de su disco duro y notifique al remitente. No debe, directa o indirectamente, usar, revelar, distribuir, imprimir o copiar ninguna de las partes de este mensaje si no es usted el destinatario. Cualquier opini&amp;oacute;n expresada en este mensaje proviene del remitente, excepto cuando el mensaje establezca lo contrario y el remitente esta autorizado para establecer que dichas opiniones provienen de [A&amp;ntilde;adirNombre]. N&amp;oacute;tese que el correo electr&amp;oacute;nico v&amp;iacute;a Internet no permite asegurar ni la confidencialidad de los mensajes que se transmiten ni la correcta recepci&amp;oacute;n de los mismos. En el caso de que el destinatario de este mensaje no consintiera la utilizaci&amp;oacute;n del correo electr&amp;oacute;nico v&amp;iacute;a Internet, rogamos lo ponga en nuestro conocimiento de manera inmediata.&lt;/p&gt;</p>\n				\n			</div>\n		</div>\n	</body>\n</html>',0,'null',1,'2025-05-15 22:54:00','Solicitud aceptada'),
(93,'admin@centro.factuley.com','fede.gundel@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se ha creado un fichaje a su nombre\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n\n                                            ¿Desea aceptar el fichaje? <br>\n\n                                            Haga clic en el siguiente botón para confirmar su aceptación:\n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_fichaje?id=172&token=MTc0NzQxNTE2OG1pYW93QzVPWjk1MXZyVVFXY3BRNGZvNVhGQXJZQ2x0\\\' class=\\\'button\\\'>Aceptar Fichaje</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-16 18:06:08','Se ha creado un fichaje a su nombre'),
(94,'admin@centro.factuley.com','fede.gundel@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se ha creado un fichaje a su nombre\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n\n                                            ¿Desea aceptar el fichaje? <br>\n\n                                            Haga clic en el siguiente botón para confirmar su aceptación:\n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_fichaje?id=172&token=MTc0NzQxNTE2OTl1YXdQOXd1UkpBNEpSTnFBVzVYaUZpRlhhcTVZS0xS\\\' class=\\\'button\\\'>Aceptar Fichaje</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-16 18:06:09','Se ha creado un fichaje a su nombre'),
(95,'admin@centro.factuley.com','yosoyrubens@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se ha creado un fichaje a su nombre\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n\n                                            ¿Desea aceptar el fichaje? <br>\n\n                                            Haga clic en el siguiente botón para confirmar su aceptación:\n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_fichaje?id=175&token=MTc0NzQxNTI3M0FOZXFBZlpFbGV2OG1QWXdkTVVXRng2UDdlSDVOcWow\\\' class=\\\'button\\\'>Aceptar Fichaje</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-16 18:07:53','Se ha creado un fichaje a su nombre'),
(96,'admin@centro.factuley.com','fede.gundel@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se ha creado un fichaje a su nombre\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n\n                                            ¿Desea aceptar el fichaje? <br>\n\n                                            Haga clic en el siguiente botón para confirmar su aceptación:\n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_fichaje?id=176&token=MTc0NzQxNTI5NW5INklnMU9FUVhjZ0ZMU01QcVFodDkzcjVod2dCVTJF\\\' class=\\\'button\\\'>Aceptar Fichaje</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-16 18:08:15','Se ha creado un fichaje a su nombre'),
(97,'admin@centro.factuley.com','fede.gundel@gmail.com','<p>Muy buenas, Tras lo hablado le enviamos la <strong>factura</strong>, Cualquier tipo de duda o comentario por favor h&aacute;ganoslo saber, Un saludo.</p>',0,'',1,'2025-05-16 18:11:17','Factura - Importante'),
(98,'admin@centro.factuley.com','fede.gundel@gmail.com','<p>Muy buenas, Tras lo hablado le enviamos la <strong>factura</strong>, Cualquier tipo de duda o comentario por favor h&aacute;ganoslo saber, Un saludo.</p>',0,'',1,'2025-05-16 18:12:15','Factura - Importante'),
(99,'admin@centro.factuley.com','fede.gundel@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se ha creado un fichaje a su nombre\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n\n                                            ¿Desea aceptar el fichaje? <br>\n\n                                            Haga clic en el siguiente botón para confirmar su aceptación:\n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_fichaje?id=177&token=MTc0NzQxNTgwM3B1aVhSV2xPbk1JUWM1WXB1MXZVOENxR3hDNnlqbE95\\\' class=\\\'button\\\'>Aceptar Fichaje</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-16 18:16:43','Se ha creado un fichaje a su nombre'),
(100,'admin@centro.factuley.com','liberrimostyle@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se ha creado un fichaje a su nombre\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n\n                                            ¿Desea aceptar el fichaje? <br>\n\n                                            Haga clic en el siguiente botón para confirmar su aceptación:\n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_fichaje?id=178&token=MTc0NzQxNTgzMjRsSHlESnhhVlF0cnNldFMzUVBDREI5cjVTQXhuSWkw\\\' class=\\\'button\\\'>Aceptar Fichaje</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-16 18:17:12','Se ha creado un fichaje a su nombre'),
(101,'admin@centro.factuley.com','fede.gundel@gmail.com','<p>Muy buenas, Tras lo hablado le enviamos la <strong>factura</strong>, Cualquier tipo de duda o comentario por favor h&aacute;ganoslo saber, Un saludo.</p>',0,'',1,'2025-05-16 18:19:11','Factura - Importante'),
(102,'admin@centro.factuley.com','11@limidata.com','<p>Muy buenas, Tras lo hablado le enviamos la <strong>factura</strong>, Cualquier tipo de duda o comentario por favor h&aacute;ganoslo saber, Un saludo.</p>',0,'',1,'2025-05-16 22:00:54','Factura - Importante'),
(103,'admin@centro.factuley.com','11@limidata.com','<p>Muy buenas, Tras lo hablado le enviamos la <strong>factura</strong>, Cualquier tipo de duda o comentario por favor h&aacute;ganoslo saber, Un saludo.</p>',0,'',1,'2025-05-16 22:01:32','Factura - Importante'),
(104,'admin@centro.factuley.com','roberlp6@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se a añadido tu email a nuestro sistema de fichajes\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n                                        Para proceder a la creación de tu cuenta haz click en el siguiente enlace: <br>\n\n                                           \n                                        \n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_miembro?id=37&token=MTc0NzQyOTUxOXR1YUFzSnJwMUpRUVlDNkZxd2Y1R0VhVno1NHpMMzZ3&email=roberlp6@gmail.com\\\' class=\\\'button\\\'>Crear usuario</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-16 22:05:19','Se ha solicitado la creación de un usuario con tu cuenta de correo electrónico'),
(105,'admin@centro.factuley.com','roberlp6@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se a añadido tu email a nuestro sistema de fichajes\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n                                        Para proceder a la creación de tu cuenta haz click en el siguiente enlace: <br>\n\n                                           \n                                        \n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_miembro?id=38&token=MTc0NzQyOTkwMXFKOElydVA1NU53ckxjc2ZDU3dFYXIyeW5kRWloSVpW&email=roberlp6@gmail.com\\\' class=\\\'button\\\'>Crear usuario</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-16 22:11:41','Se ha solicitado la creación de un usuario con tu cuenta de correo electrónico'),
(106,'admin@centro.factuley.com','roberlp6@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se ha creado un fichaje a su nombre\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n\n                                            ¿Desea aceptar el fichaje? <br>\n\n                                            Haga clic en el siguiente botón para confirmar su aceptación:\n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_fichaje?id=180&token=MTc0NzQzMDE5MEt6YUE5VEN4MVFMQ2ROc3FVVU1nMzhvSGp4UGw5UE9W\\\' class=\\\'button\\\'>Aceptar Fichaje</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-16 22:16:30','Se ha creado un fichaje a su nombre'),
(107,'admin@centro.factuley.com','11@limidata.com','<p>Muy buenas, Tras lo hablado le enviamos el albaran, Cualquier tipo de duda o comentario por favor h&aacute;ganoslo saber, Un saludo.</p>',0,'',1,'2025-05-16 22:35:47','Albaran - Pendiente'),
(108,'admin@centro.factuley.com','11@limidata.com','<p>Muy buenas, Tras lo hablado le enviamos el albaran, Cualquier tipo de duda o comentario por favor h&aacute;ganoslo saber, Un saludo.</p>',0,'',1,'2025-05-16 22:37:25','Albaran - Pendiente'),
(109,'admin@centro.factuley.com','roberlp6@gmail.com','<p>Muy buenas, Tras lo hablado le enviamos la <strong>factura</strong>, Cualquier tipo de duda o comentario por favor h&aacute;ganoslo saber, Un saludo.</p>',0,'',1,'2025-05-16 22:39:52','Factura - Importante'),
(110,'admin@centro.factuley.com','roberlp6@gmail.com','<p>Hola Cliente, &iquest;necesitas de un servicio digital? Cada una de nuestras areas se encuentra formado por diversos expertos para m&aacute;ximizar y asegurar el &eacute;xito. Ayudamos a nuestros clientes a ser m&aacute;s competitivos mediante una dedicaci&oacute;n comprometida, innovadora y eficaz basada en la confianza.</p>\r\n<p>Puede consultar por nuestros servicios&nbsp;<a href=\\\"https://empiresystems.io/\\\">empiresystems.io</a></p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<!-- Fallback force center content -->\r\n<div style=\\\"text-align: center;\\\">\r\n<table style=\\\"text-align: center; vertical-align: top; width: 592px; max-width: 600px; background-color: #3f3f3f;\\\" width=\\\"592\\\" cellpadding=\\\"0px\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 592px; vertical-align: top; padding: 0px;\\\"><!-- Your logo  is here --> <!--\r\n            <img style=\\\"width: 200px; max-width: 200px; height: 70px; max-height: 70px; text-align: center; color: #ffffff;\\\" alt=\\\"Logo\\\" src=\\\"https://64.media.tumblr.com/dfe839d12d891dc4b73f0f29da62fa49/tumblr_inline_sc3yl3BwJh1rfe0n6_500.jpg\\\" align=\\\"center\\\" width=\\\"600\\\" height=\\\"170\\\">\r\n            <!-- Your logo 2 is here --> <!--   <img style=\\\"width: 600px; max-width: 600px; height: 200px; max-height: 200px; text-align: center; color: #fcf6df;\\\" alt=\\\"Logo\\\" src=\\\"https://64.media.tumblr.com/77b0199f657ba1688b57394272b58e9b/tumblr_inline_sc42vq6ffd1rfe0n6_500.jpg\\\" align=\\\"center\\\" width=\\\"800\\\" height=\\\"300\\\">\r\n <!-- Your logo 3 is here --> <img style=\\\"max-width: 200px; max-height: 100px; text-align: center; color: #ffffff;\\\" src=\\\"image.php?id=ix7XQcvhzdaaoqIPXeSEtgIO7\\\" alt=\\\"Logo\\\" width=\\\"240\\\" height=\\\"49\\\" align=\\\"middle\\\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<!-- End container for logo --> <!-- Hero image --> <br /><!-- Hero image --> <!-- Start single column section -->\r\n<table style=\\\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #ffffff;\\\" width=\\\"600\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 596px; vertical-align: top; padding: 30px 30px 40px 30px;\\\" width=\\\"596\\\">\r\n<div class=\\\"caja\\\">\r\n<p class=\\\"pretitulo wow fadeInUp\\\" data-wow-duration=\\\"1s\\\" data-wow-delay=\\\"0.3s\\\" data-wow-offset=\\\"100\\\">&iexcl;&iexcl;BIENVENIDO!!</p>\r\n</div>\r\n<div class=\\\"centrado centrado relative\\\">\r\n<div class=\\\"caja_h3 caja\\\">\r\n<h3 class=\\\"h3 wow fadeInUp\\\" data-wow-duration=\\\"1s\\\" data-wow-delay=\\\"0.6s\\\" data-wow-offset=\\\"100\\\">Tenemos el veh&iacute;culo que est&aacute; buscando</h3>\r\n</div>\r\n</div>\r\n<p><strong>Dilucars Autom&oacute;viles, S.L.</strong>&nbsp;empresa dedicada a la venta de&nbsp;<strong>veh&iacute;culos de ocasi&oacute;n</strong>, inicia su actividad el&nbsp;<strong>10 de diciembre de</strong>&nbsp;<strong>2007&nbsp;</strong>abriendo su primera exposici&oacute;n en una de las calles de mayor crecimiento y desarrollo econ&oacute;mico de la ciudad de Las Palmas de G.C en la&nbsp;<strong>Avda. Pintor Felo Monz&oacute;n,17 Portal 9 Bajo - 7 Palmas</strong>.</p>\r\n<p>Prueba de&nbsp;nuestra profesionalidad, seguridad en la compra a nuestros clientes y garant&iacute;a, nos llevan a seguir en el mercado a&ntilde;os m&aacute;s tarde. En febrero de&nbsp;<strong>2021 abrimos nuevas instalaciones</strong>&nbsp;tambi&eacute;n en Las Palmas de Gran Canaria en la&nbsp;<strong>C/ Arguineg&uuml;&iacute;n, 23 - Pol&iacute;gono Industrial Lomo Blanco - Las Torres (frente a la ITV)</strong>. Entre ambas exposiciones ofrecemos m&aacute;s de&nbsp;<strong>750 metros cuadrados&nbsp;</strong>y un amplio stock de&nbsp;<strong>veh&iacute;culos para elegir</strong>.</p>\r\n<h3>Le queremos agradecer su tiempo en la visita a nuestra web y le invitamos a conocer nuestro Stock y nuestra pol&iacute;tica de empresa.</h3>\r\n<p style=\\\"font-size: 15px; line-height: 24px; font-family: Releway, sans-serif; font-weight: 400; text-decoration: none; color: #919293; text-align: justify;\\\">Nuestra especialidad, es la venta de veh&iacute;culos seminuevos que han sido seleccionados para usted, por cubrir unos requisitos indispensables de bajo kilometraje, antig&uuml;edad no superior a 40 meses y totalmente revisados y garantizados.</p>\r\n<h2><span style=\\\"color: #3366ff;\\\"><strong><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.empiresystems.io\\\">empiresystems.io</a></strong><!-- Start container for logo --></span></h2>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h2><span style=\\\"color: #3366ff;\\\"><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.dilucars.com/\\\"><!-- End single column section --> <!-- Start image --> </a></span></h2>\r\n<h4><span style=\\\"color: #3366ff;\\\"><a style=\\\"color: #3366ff;\\\" href=\\\"https://www.dilucars.com/\\\"><!-- End image --> <!-- Start footer --></a></span></h4>\r\n<table style=\\\"text-align: center; vertical-align: top; width: 600px; max-width: 600px; background-color: #3f3f3f;\\\" width=\\\"600\\\" cellpadding=\\\"15px 30px\\\" align=\\\"center\\\">\r\n<tbody>\r\n<tr>\r\n<td style=\\\"width: 600px; vertical-align: top; padding: 15px 30px 15px 30px;\\\" width=\\\"600\\\">\r\n<h4><!-- Your inverted logo is here --></h4>\r\n<span style=\\\"color: #ffffff;\\\">infomx@empiresystems.io</span>\r\n<h4 style=\\\"font-size: 12px; line-height: 12px; font-family: \\\'Raleway\\\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\\\">&nbsp;</h4>\r\n<h4 style=\\\"font-size: 11px; line-height: 20px; font-family: \\\'Helvetica\\\', Arial, sans-serif; font-weight: 400; text-decoration: none; color: #000000;\\\"><span style=\\\"color: #ffffff;\\\">No quieres recibir m&aacute;s correos electr&oacute;nicos?</span></h4>\r\n<p>&nbsp;</p>\r\n<h4 style=\\\"margin-bottom: 0; font-size: 17px; line-height: 24px; font-family: \\\'Releway\\\', Releway, sans-serif; font-weight: 400; text-decoration: none; color: #ffffff;\\\">&nbsp;</h4>\r\n<h4 style=\\\"font-size: 12px; line-height: 12px; font-family: \\\'Raleway\\\', Raleway, sans-serif; font-weight: normal; text-decoration: none; color: #000000;\\\">&nbsp;</h4>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>',0,'{\\\"name\\\":[\\\"Contrato de colaboracio\\\\u0301n KIT DIGITAL.pdf\\\"],\\\"type\\\":[\\\"application\\\\/pdf\\\"],\\\"tmp_name\\\":[\\\"\\\\/tmp\\\\/phpqCIOIY\\\"],\\\"error\\\":[0],\\\"size\\\":[644909]}',1,'2025-05-16 23:18:46','promoción'),
(111,'admin@centro.factuley.com','fede.gundel@gmail.com','<p>Muy buenas, Tras lo hablado le enviamos el albaran, Cualquier tipo de duda o comentario por favor h&aacute;ganoslo saber, Un saludo.</p>',0,'',1,'2025-05-16 23:38:43','Albaran - Pendiente'),
(112,'admin@centro.factuley.com','fede.gundel@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se a añadido tu email a nuestro sistema de fichajes\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n                                        Para proceder a la creación de tu cuenta haz click en el siguiente enlace: <br>\n\n                                           \n                                        \n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_miembro?id=40&token=MTc0NzUyOTEyMHo3bTNCN1NCeEZiRlBuTDhqSVk2bHI4cUJlV2NwclZk&email=fede.gundel@gmail.com\\\' class=\\\'button\\\'>Crear usuario</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-18 01:45:20','Se ha solicitado la creación de un usuario con tu cuenta de correo electrónico'),
(113,'admin@centro.factuley.com','fede.gundel@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se a añadido tu email a nuestro sistema de fichajes\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n                                        Para proceder a la creación de tu cuenta haz click en el siguiente enlace: <br>\n\n                                           \n                                        \n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_miembro?id=41&token=MTc0NzUyOTkyMHV4R3ZudWxFbU05WnFVOFBQWjNmSjdxM05WM29FRTZW&email=fede.gundel@gmail.com\\\' class=\\\'button\\\'>Crear usuario</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-18 01:58:40','Se ha solicitado la creación de un usuario con tu cuenta de correo electrónico'),
(114,'admin@centro.factuley.com','albertorodriguez6545@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se a añadido tu email a nuestro sistema de fichajes\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n                                        Para proceder a la creación de tu cuenta haz click en el siguiente enlace: <br>\n\n                                           \n                                        \n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_miembro?id=42&token=MTc0NzUzMDE4MzFLbEx4eDNONTIxZkJLdnp4cjlUbm1GcWRTUU1qcFZH&email=albertorodriguez6545@gmail.com\\\' class=\\\'button\\\'>Crear usuario</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-18 02:03:03','Se ha solicitado la creación de un usuario con tu cuenta de correo electrónico'),
(115,'admin@centro.factuley.com','agustinvaldez494@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se a añadido tu email a nuestro sistema de fichajes\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n                                        Para proceder a la creación de tu cuenta haz click en el siguiente enlace: <br>\n\n                                           \n                                        \n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_miembro?id=43&token=MTc0NzUzOTQ3MjdKWTFEeElRSlJHcnVvVHFFYWplYzRaV3lwQWVxaWxH&email=agustinvaldez494@gmail.com\\\' class=\\\'button\\\'>Crear usuario</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-18 04:37:52','Se ha solicitado la creación de un usuario con tu cuenta de correo electrónico'),
(116,'admin@centro.factuley.com','fede.gundel@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se ha creado un fichaje a su nombre\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n\n                                            ¿Desea aceptar el fichaje? <br>\n\n                                            Haga clic en el siguiente botón para confirmar su aceptación:\n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_fichaje?id=182&token=MTc0Nzc3MTg2OUNtdWJEcXlqUnAyZHhzd21vWjcwNHpoaExhbmxkT1Bn\\\' class=\\\'button\\\'>Revisar Fichaje</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-20 21:11:09','Se ha creado un fichaje a su nombre'),
(117,'admin@centro.factuley.com','fede.gundel@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se ha creado un fichaje a su nombre\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n\n                                            ¿Desea aceptar el fichaje? <br>\n\n                                            Haga clic en el siguiente botón para confirmar su aceptación:\n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_fichaje?id=187&token=MTc0Nzc3MjU5N0tvMmdBb0s5Z240SHdhS3V6Y1lxVWVFU1dIWXkyQlBt\\\' class=\\\'button\\\'>Revisar Fichaje</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-20 21:23:17','Se ha creado un fichaje a su nombre'),
(118,'admin@centro.factuley.com','fede.gundel@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se ha creado un fichaje a su nombre\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n\n                                            ¿Desea aceptar el fichaje? <br>\n\n                                            Haga clic en el siguiente botón para confirmar su aceptación:\n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_fichaje?id=188&token=MTc0Nzc3MjkwOGwzMnQzVmUzRUNuVDZ1dkVYR0pGN2ltU3hLT2VXaDdz\\\' class=\\\'button\\\'>Revisar Fichaje</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-20 21:28:28','Se ha creado un fichaje a su nombre'),
(119,'admin@centro.factuley.com','fede.gundel@gmail.com',' <html>\n\n                                <head>\n\n                                    <style>\n\n                                        .button {\n\n                                        background-color: #0cca8e;\n\n                                border-color: #0cca8e;\n\n                                        display: inline-block;\n\n                                font-weight: 400;\n\n                                text-align: center;\n\n                                white-space: nowrap;\n\n                                vertical-align: middle;\n\n                                user-select: none;\n\n                                border: 1px solid rgba(0, 0, 0, 0);\n\n                                padding: .56rem 1.375rem;\n\n                                font-size: 1rem;\n\n                                line-height: 1;\n\n                                border-radius: .1875rem;\n\n                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;\n\n                                outline: 0;\n\n                                outline-offset: 0;\n\n                                color: #fff!important;\n\n                            }\n\n                            .button:hover {\n\n                                color: #fff;\n\n                                background-color: #0aa675;\n\n                                border-color: #099a6c;\n\n                                text-decoration: none;\n\n                            }\n\n                                        .email-container {\n\n                                            font-family: Arial, sans-serif;\n\n                                            line-height: 1.5;\n\n                                            margin: 20px;\n\n                                                max-width: 370px;\n\n                                                margin: 0 auto;\n\n                                                text-align:center;\n\n                                        }\n\n                                        .email-title {\n\n                                            color: #333;\n\n                                            font-size: 20px;\n\n                                            font-weight: bold;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-text {\n\n                                            color: #555;\n\n                                            font-size: 16px;\n\n                                            width: 100%;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                        .email-b{\n\n                                        width: 100%;\n\n                                        }\n\n                                        .email-image {\n\n                                            width: 100%;\n\n                                            max-width: 300px;\n\n                                            height: auto;\n\n                                            display: block;\n\n                                            margin: 0 auto;\n\n                                            margin-bottom:.5rem;\n\n                                        }\n\n                                    </style>\n\n                                </head>\n\n                                <body>\n\n                                    <div class=\\\'email-container\\\'>\n\n                                    \n\n                                        <img src=\\\'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2\\\' alt=\\\'Imagen de fichaje\\\' class=\\\'email-image\\\' />\n\n                            <div class=\\\'email-title\\\'>\n\n                                            Se ha creado un fichaje a su nombre\n\n                                        </div>\n\n                                    \n\n                                        <div class=\\\'email-text\\\'>\n\n                                            ¿Desea aceptar el fichaje? <br>\n\n                                            Haga clic en el siguiente botón para confirmar su aceptación:\n\n                                        </div>\n\n                            <div class=\\\'email-b\\\'>\n\n                                        <a href=\\\'https://centro.factuley.com/aceptar_fichaje?id=190&token=MTc0Nzc3MzQ4M1dlRmlhbHgySUxVZXF4RWVwQTNqQ0Q1U3dIczFQcll0\\\' class=\\\'button\\\'>Revisar Fichaje</a> \n\n                                        </div>\n\n                                    </div>\n\n                                </body>\n\n                                </html>\n\n                            ',0,'null',1,'2025-05-20 21:38:03','Se ha creado un fichaje a su nombre');
/*!40000 ALTER TABLE `mailing` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `marcas`
--

DROP TABLE IF EXISTS `marcas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `marcas` (
  `id_marca` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id_marca`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `marcas`
--

LOCK TABLES `marcas` WRITE;
/*!40000 ALTER TABLE `marcas` DISABLE KEYS */;
/*!40000 ALTER TABLE `marcas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `materiales`
--

DROP TABLE IF EXISTS `materiales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `materiales` (
  `material_id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `cantidad` int(11) NOT NULL,
  `id_estado` int(11) NOT NULL,
  `id_ubicacion` int(11) NOT NULL,
  PRIMARY KEY (`material_id`),
  KEY `FK_estado_id` (`id_estado`),
  KEY `FK_ubicacion_id` (`id_ubicacion`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `materiales`
--

LOCK TABLES `materiales` WRITE;
/*!40000 ALTER TABLE `materiales` DISABLE KEYS */;
INSERT INTO `materiales` VALUES
(2,'Cajas',234,2,1),
(3,'ROLLOS PAPEL ',500,1,1),
(4,'Papel',300,1,2);
/*!40000 ALTER TABLE `materiales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `medidas`
--

DROP TABLE IF EXISTS `medidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `medidas` (
  `id_medida` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_medida`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `medidas`
--

LOCK TABLES `medidas` WRITE;
/*!40000 ALTER TABLE `medidas` DISABLE KEYS */;
INSERT INTO `medidas` VALUES
(1,'dfgh');
/*!40000 ALTER TABLE `medidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `message`
--

DROP TABLE IF EXISTS `message`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `message` (
  `message_id` int(11) NOT NULL AUTO_INCREMENT,
  `message_user` int(11) NOT NULL,
  `message_ticket_id` int(11) NOT NULL,
  `message_date` int(11) NOT NULL,
  `message_text` varchar(5000) NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `fk_logins_users_idx` (`message_user`),
  KEY `fk_message_tikets1_idx` (`message_ticket_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `message`
--

LOCK TABLES `message` WRITE;
/*!40000 ALTER TABLE `message` DISABLE KEYS */;
/*!40000 ALTER TABLE `message` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metodos_pago`
--

DROP TABLE IF EXISTS `metodos_pago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metodos_pago` (
  `id_metodo` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_metodo`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metodos_pago`
--

LOCK TABLES `metodos_pago` WRITE;
/*!40000 ALTER TABLE `metodos_pago` DISABLE KEYS */;
INSERT INTO `metodos_pago` VALUES
(1,'Efectivo'),
(2,'Transferencia bancaria ');
/*!40000 ALTER TABLE `metodos_pago` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `miembro_equipo`
--

DROP TABLE IF EXISTS `miembro_equipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `miembro_equipo` (
  `id_miembro` int(11) NOT NULL AUTO_INCREMENT,
  `dni` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `precio_hora` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `precio_horas_extra` int(11) DEFAULT NULL,
  `direccion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `kilometros_casa` int(11) DEFAULT 1,
  `kilometros_calle` int(11) DEFAULT 1,
  `calle` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT 'Avenida Escaleritas, Las Palmas de Gran Canaria, España',
  `csrf_token` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `estado` varchar(255) NOT NULL DEFAULT 'Aceptado',
  PRIMARY KEY (`id_miembro`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `miembro_equipo_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `miembro_equipo`
--

LOCK TABLES `miembro_equipo` WRITE;
/*!40000 ALTER TABLE `miembro_equipo` DISABLE KEYS */;
INSERT INTO `miembro_equipo` VALUES
(32,'1',1,13,1,'Av. Escaleritas, Las Palmas de Gran Canaria, España',1,1,'Calle Fernando Guanarteme, 159, Las Palmas de Gran Canaria, España',NULL,NULL,'Aceptado'),
(36,'2223',23,6735,2,'Carretera Pico Viento, n23, Tafira Baja, España',1,1,'Av. Escaleritas, n3, Las Palmas de Gran Canaria, España',NULL,NULL,'Aceptado'),
(38,'y12612616',2,6736,2,'Carretera Pico Viento, n3, Tafira Baja, España',1,1,'Av. Escaleritas, n3, Las Palmas de Gran Canaria, España',NULL,NULL,'Aceptado'),
(42,'2342',12,6738,123,'Baigorria 1126, Merlo, Provincia de Buenos Aires, Argentina',NULL,NULL,NULL,NULL,'albertorodriguez6545@gmail.com','Aceptado'),
(44,'37847226',10,6707,12,'11 de Septiembre 1388, Tandil, Provincia de Buenos Aires, Argentina',1,1,'Panamá 351, Tandil, Provincia de Buenos Aires, Argentina',NULL,NULL,'Aceptado');
/*!40000 ALTER TABLE `miembro_equipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `modelos`
--

DROP TABLE IF EXISTS `modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `modelos` (
  `id_modelo` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id_modelo`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `modelos`
--

LOCK TABLES `modelos` WRITE;
/*!40000 ALTER TABLE `modelos` DISABLE KEYS */;
INSERT INTO `modelos` VALUES
(3,'qwe');
/*!40000 ALTER TABLE `modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `navegadores`
--

DROP TABLE IF EXISTS `navegadores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `navegadores` (
  `id_navegador` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_navegador`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `navegadores`
--

LOCK TABLES `navegadores` WRITE;
/*!40000 ALTER TABLE `navegadores` DISABLE KEYS */;
/*!40000 ALTER TABLE `navegadores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nivel_estudios`
--

DROP TABLE IF EXISTS `nivel_estudios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nivel_estudios` (
  `id_nivel_estudios` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_nivel_estudios`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nivel_estudios`
--

LOCK TABLES `nivel_estudios` WRITE;
/*!40000 ALTER TABLE `nivel_estudios` DISABLE KEYS */;
/*!40000 ALTER TABLE `nivel_estudios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notas`
--

DROP TABLE IF EXISTS `notas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `notas` (
  `id_nota` int(11) NOT NULL AUTO_INCREMENT,
  `cuerpo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `id_cliente` int(11) NOT NULL,
  `fecha` datetime NOT NULL,
  PRIMARY KEY (`id_nota`),
  KEY `FK_client_id` (`id_cliente`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notas`
--

LOCK TABLES `notas` WRITE;
/*!40000 ALTER TABLE `notas` DISABLE KEYS */;
INSERT INTO `notas` VALUES
(1,'Cliente ideal',1,'2024-09-04 15:46:00'),
(2,'Cliente contento',2,'2024-09-10 12:27:12'),
(3,'Cliente problematico',2,'2024-09-23 11:56:31'),
(4,'Clienta me llamo a las 7:00 am',3,'2024-10-08 15:21:40'),
(5,'cLIENTE CONTENTO',4,'2024-10-14 16:43:16'),
(6,'Cliente simpatico',10,'2025-01-09 12:39:21'),
(7,'cl4l',1,'2025-01-17 18:31:56');
/*!40000 ALTER TABLE `notas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `obras`
--

DROP TABLE IF EXISTS `obras`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `obras` (
  `id_obra` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_obra`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `obras`
--

LOCK TABLES `obras` WRITE;
/*!40000 ALTER TABLE `obras` DISABLE KEYS */;
/*!40000 ALTER TABLE `obras` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `observaciones`
--

DROP TABLE IF EXISTS `observaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `observaciones` (
  `id_observacion` int(11) NOT NULL AUTO_INCREMENT,
  `observacion` varchar(2255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `id_pedido` int(11) NOT NULL,
  PRIMARY KEY (`id_observacion`),
  KEY `id_pedido` (`id_pedido`),
  CONSTRAINT `observaciones_ibfk_1` FOREIGN KEY (`id_pedido`) REFERENCES `pedidos` (`id_pedido`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `observaciones`
--

LOCK TABLES `observaciones` WRITE;
/*!40000 ALTER TABLE `observaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `observaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `otras_carpetas`
--

DROP TABLE IF EXISTS `otras_carpetas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `otras_carpetas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `otras_carpetas`
--

LOCK TABLES `otras_carpetas` WRITE;
/*!40000 ALTER TABLE `otras_carpetas` DISABLE KEYS */;
/*!40000 ALTER TABLE `otras_carpetas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pago`
--

DROP TABLE IF EXISTS `pago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pago` (
  `id_pago` int(11) NOT NULL AUTO_INCREMENT,
  `importe` decimal(7,2) NOT NULL,
  `estado` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `id_miembro` int(11) DEFAULT NULL,
  `fecha` date NOT NULL,
  `pagos` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `importe_restante` decimal(7,2) NOT NULL,
  `horas_extra` int(11) DEFAULT NULL,
  `precio_horas_extra` decimal(7,2) DEFAULT NULL,
  `id_proveedor` int(11) DEFAULT NULL,
  `numero_factura` int(11) DEFAULT NULL,
  `fecha_vencimiento` datetime DEFAULT NULL,
  PRIMARY KEY (`id_pago`),
  KEY `id_miembro` (`id_miembro`),
  KEY `id_proveedor` (`id_proveedor`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pago`
--

LOCK TABLES `pago` WRITE;
/*!40000 ALTER TABLE `pago` DISABLE KEYS */;
/*!40000 ALTER TABLE `pago` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pago_empleado`
--

DROP TABLE IF EXISTS `pago_empleado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pago_empleado` (
  `id_pago_empleado` int(11) NOT NULL AUTO_INCREMENT,
  `importe` decimal(7,2) DEFAULT NULL,
  `id_metodo` int(11) DEFAULT NULL,
  `id_banco` int(11) DEFAULT NULL,
  `fecha` datetime DEFAULT NULL,
  `id_factura_empleado` int(11) NOT NULL,
  PRIMARY KEY (`id_pago_empleado`),
  KEY `id_metodo` (`id_metodo`),
  KEY `id_banco` (`id_banco`),
  KEY `id_factura_empleado` (`id_factura_empleado`),
  CONSTRAINT `pago_empleado_ibfk_1` FOREIGN KEY (`id_banco`) REFERENCES `bancos` (`id_banco`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `pago_empleado_ibfk_2` FOREIGN KEY (`id_metodo`) REFERENCES `metodos_pago` (`id_metodo`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `pago_empleado_ibfk_3` FOREIGN KEY (`id_factura_empleado`) REFERENCES `factura_empleado` (`id_factura_empleado`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pago_empleado`
--

LOCK TABLES `pago_empleado` WRITE;
/*!40000 ALTER TABLE `pago_empleado` DISABLE KEYS */;
/*!40000 ALTER TABLE `pago_empleado` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pago_factura`
--

DROP TABLE IF EXISTS `pago_factura`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pago_factura` (
  `id_pago_factura` int(11) NOT NULL AUTO_INCREMENT,
  `importe` decimal(9,2) NOT NULL,
  `id_metodo` int(11) DEFAULT NULL,
  `id_banco` int(11) DEFAULT NULL,
  `fecha` date NOT NULL,
  `id_factura_manual` int(11) NOT NULL,
  PRIMARY KEY (`id_pago_factura`),
  KEY `id_metodo` (`id_metodo`),
  KEY `id_banco` (`id_banco`),
  KEY `id_factura_manual` (`id_factura_manual`),
  CONSTRAINT `pago_factura_ibfk_1` FOREIGN KEY (`id_banco`) REFERENCES `bancos` (`id_banco`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `pago_factura_ibfk_2` FOREIGN KEY (`id_metodo`) REFERENCES `metodos_pago` (`id_metodo`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `pago_factura_ibfk_3` FOREIGN KEY (`id_factura_manual`) REFERENCES `factura_manual` (`id_factura_manual`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pago_factura`
--

LOCK TABLES `pago_factura` WRITE;
/*!40000 ALTER TABLE `pago_factura` DISABLE KEYS */;
/*!40000 ALTER TABLE `pago_factura` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pago_proveedor`
--

DROP TABLE IF EXISTS `pago_proveedor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pago_proveedor` (
  `id_pago_proveedor` int(11) NOT NULL AUTO_INCREMENT,
  `importe` decimal(9,2) NOT NULL,
  `id_metodo` int(11) DEFAULT NULL,
  `id_banco` int(11) DEFAULT NULL,
  `fecha` datetime NOT NULL,
  `id_factura_proveedor` int(11) NOT NULL,
  PRIMARY KEY (`id_pago_proveedor`),
  KEY `id_metodo` (`id_metodo`),
  KEY `id_banco` (`id_banco`),
  KEY `id_factura_proveedor` (`id_factura_proveedor`),
  CONSTRAINT `pago_proveedor_ibfk_1` FOREIGN KEY (`id_banco`) REFERENCES `bancos` (`id_banco`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `pago_proveedor_ibfk_2` FOREIGN KEY (`id_metodo`) REFERENCES `metodos_pago` (`id_metodo`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `pago_proveedor_ibfk_3` FOREIGN KEY (`id_factura_proveedor`) REFERENCES `factura_proveedor` (`id_factura_proveedor`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pago_proveedor`
--

LOCK TABLES `pago_proveedor` WRITE;
/*!40000 ALTER TABLE `pago_proveedor` DISABLE KEYS */;
INSERT INTO `pago_proveedor` VALUES
(1,20.00,NULL,4,'2024-11-04 13:37:50',4),
(2,780.00,1,NULL,'2024-11-04 13:38:00',4),
(3,1400.00,1,4,'2024-11-14 12:34:00',5);
/*!40000 ALTER TABLE `pago_proveedor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pedidos`
--

DROP TABLE IF EXISTS `pedidos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pedidos` (
  `id_pedido` int(11) NOT NULL AUTO_INCREMENT,
  `numero` varchar(255) DEFAULT NULL,
  `nombre` varchar(255) DEFAULT NULL,
  `domicilio` varchar(255) DEFAULT NULL,
  `dni` varchar(255) DEFAULT NULL,
  `telefono` varchar(255) DEFAULT NULL,
  `palets` varchar(255) DEFAULT NULL,
  `bultos` varchar(255) DEFAULT NULL,
  `tipo_entrega` varchar(255) DEFAULT NULL,
  `estado` varchar(255) DEFAULT '',
  `geolocalizacion` varchar(255) DEFAULT NULL,
  `id_transportista` int(11) DEFAULT NULL,
  `fecha_creacion` datetime DEFAULT current_timestamp(),
  `fecha_entrega` date DEFAULT NULL,
  `id_firma` int(11) DEFAULT NULL,
  `id_almacen` int(11) DEFAULT NULL,
  `id_balda` int(11) DEFAULT NULL,
  `id_columna` int(11) DEFAULT NULL,
  `fecha_almacen` date DEFAULT NULL,
  PRIMARY KEY (`id_pedido`),
  KEY `pedidos_transportistas_id` (`id_transportista`),
  KEY `id_firma` (`id_firma`),
  KEY `id_almacen` (`id_almacen`),
  KEY `id_balda` (`id_balda`),
  KEY `id_columna` (`id_columna`),
  CONSTRAINT `pedidos_ibfk_1` FOREIGN KEY (`id_transportista`) REFERENCES `transportistas` (`id_transportista`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `pedidos_ibfk_2` FOREIGN KEY (`id_firma`) REFERENCES `firmas` (`id_firma`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `pedidos_ibfk_3` FOREIGN KEY (`id_almacen`) REFERENCES `almacenes` (`id_almacen`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `pedidos_ibfk_4` FOREIGN KEY (`id_balda`) REFERENCES `baldas` (`id_balda`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `pedidos_ibfk_5` FOREIGN KEY (`id_columna`) REFERENCES `columnas` (`id_columna`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pedidos`
--

LOCK TABLES `pedidos` WRITE;
/*!40000 ALTER TABLE `pedidos` DISABLE KEYS */;
INSERT INTO `pedidos` VALUES
(1,'234234','341234','123412','12341234',NULL,'0','012341234','Directa','Entregado',NULL,NULL,'2024-09-25 17:20:15',NULL,NULL,NULL,NULL,NULL,NULL),
(2,'1','Nuevo',NULL,NULL,NULL,'0','0','Directa','Entregado',NULL,NULL,'2025-05-01 09:27:20',NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `pedidos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pedidos_observaciones`
--

DROP TABLE IF EXISTS `pedidos_observaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pedidos_observaciones` (
  `id_pedido` int(11) NOT NULL,
  `observacion` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  KEY `pedidos_observaciones_id` (`id_pedido`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pedidos_observaciones`
--

LOCK TABLES `pedidos_observaciones` WRITE;
/*!40000 ALTER TABLE `pedidos_observaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `pedidos_observaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pedidos_transportistas`
--

DROP TABLE IF EXISTS `pedidos_transportistas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pedidos_transportistas` (
  `id_transportista` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) NOT NULL,
  `domicilio` varchar(255) NOT NULL,
  `dni` varchar(255) NOT NULL,
  `telefono` varchar(255) NOT NULL,
  PRIMARY KEY (`id_transportista`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pedidos_transportistas`
--

LOCK TABLES `pedidos_transportistas` WRITE;
/*!40000 ALTER TABLE `pedidos_transportistas` DISABLE KEYS */;
/*!40000 ALTER TABLE `pedidos_transportistas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `periodo_vacaciones`
--

DROP TABLE IF EXISTS `periodo_vacaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `periodo_vacaciones` (
  `id_periodo_vacaciones` int(11) NOT NULL AUTO_INCREMENT,
  `salida_periodo_1` date DEFAULT NULL,
  `incorporacion_periodo_1` date DEFAULT NULL,
  `salida_periodo_2` date DEFAULT NULL,
  `incorporacion_periodo_2` date DEFAULT NULL,
  `salida_periodo_3` date DEFAULT NULL,
  `incorporacion_periodo_3` date DEFAULT NULL,
  `id_empleado` int(11) NOT NULL,
  `observaciones` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id_periodo_vacaciones`),
  KEY `id_empleado` (`id_empleado`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `periodo_vacaciones`
--

LOCK TABLES `periodo_vacaciones` WRITE;
/*!40000 ALTER TABLE `periodo_vacaciones` DISABLE KEYS */;
INSERT INTO `periodo_vacaciones` VALUES
(16,NULL,NULL,NULL,NULL,NULL,NULL,6,'turbodat','[{\\\"salida\\\":\\\"2025-02-05\\\",\\\"incorporacion\\\":\\\"2025-02-07\\\",\\\"dias\\\":2},{\\\"salida\\\":\\\"2025-02-10\\\",\\\"incorporacion\\\":\\\"2025-02-16\\\",\\\"dias\\\":6},{\\\"salida\\\":\\\"2025-02-27\\\",\\\"incorporacion\\\":\\\"2025-03-02\\\",\\\"dias\\\":3}]'),
(18,NULL,NULL,NULL,NULL,NULL,NULL,7,'','[{\\\"salida\\\":\\\"2025-02-05\\\",\\\"incorporacion\\\":\\\"2025-02-27\\\",\\\"dias\\\":22}]'),
(19,NULL,NULL,NULL,NULL,NULL,NULL,7,'ewqeqwe','[{\\\"salida\\\":\\\"2025-02-10\\\",\\\"incorporacion\\\":\\\"2025-02-17\\\",\\\"dias\\\":7}]'),
(20,NULL,NULL,NULL,NULL,NULL,NULL,10,'Okey','[{\\\"salida\\\":\\\"2025-04-10\\\",\\\"incorporacion\\\":\\\"2025-04-11\\\",\\\"dias\\\":1},{\\\"salida\\\":\\\"2025-04-17\\\",\\\"incorporacion\\\":\\\"2025-04-26\\\",\\\"dias\\\":9}]'),
(21,NULL,NULL,NULL,NULL,NULL,NULL,1,'','[{\\\"salida\\\":\\\"2025-04-29\\\",\\\"incorporacion\\\":\\\"2025-05-14\\\",\\\"dias\\\":15}]');
/*!40000 ALTER TABLE `periodo_vacaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personalizacion`
--

DROP TABLE IF EXISTS `personalizacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `personalizacion` (
  `url_logo_portada` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `url_imagen_portada` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `url_facebook` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `url_linkedin` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `url_twitter` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `url_youtube` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `id_personalizacion` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id_personalizacion`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personalizacion`
--

LOCK TABLES `personalizacion` WRITE;
/*!40000 ALTER TABLE `personalizacion` DISABLE KEYS */;
/*!40000 ALTER TABLE `personalizacion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `planes`
--

DROP TABLE IF EXISTS `planes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `planes` (
  `id_plan` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `id_sector` int(11) DEFAULT NULL,
  `importe` decimal(9,2) NOT NULL,
  `fecha` date NOT NULL,
  PRIMARY KEY (`id_plan`),
  KEY `id_sector` (`id_sector`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `planes`
--

LOCK TABLES `planes` WRITE;
/*!40000 ALTER TABLE `planes` DISABLE KEYS */;
/*!40000 ALTER TABLE `planes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `poblaciones`
--

DROP TABLE IF EXISTS `poblaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `poblaciones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `poblaciones`
--

LOCK TABLES `poblaciones` WRITE;
/*!40000 ALTER TABLE `poblaciones` DISABLE KEYS */;
INSERT INTO `poblaciones` VALUES
(1,'Olavarria'),
(6,'Las Palmas'),
(7,'Olavarría'),
(8,'Las palmas'),
(9,'Barcelona'),
(10,'Olavarria');
/*!40000 ALTER TABLE `poblaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `presupuesto_programado`
--

DROP TABLE IF EXISTS `presupuesto_programado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `presupuesto_programado` (
  `id_presupuesto_programado` int(11) NOT NULL AUTO_INCREMENT,
  `fecha_envio` datetime NOT NULL,
  `id_presupuesto` int(11) NOT NULL,
  `estado` varchar(255) NOT NULL DEFAULT 'No enviado',
  PRIMARY KEY (`id_presupuesto_programado`),
  KEY `id_presupuesto` (`id_presupuesto`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `presupuesto_programado`
--

LOCK TABLES `presupuesto_programado` WRITE;
/*!40000 ALTER TABLE `presupuesto_programado` DISABLE KEYS */;
/*!40000 ALTER TABLE `presupuesto_programado` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `presupuestos`
--

DROP TABLE IF EXISTS `presupuestos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `presupuestos` (
  `id_presupuesto` int(11) NOT NULL AUTO_INCREMENT,
  `titulo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `id_cliente` int(11) NOT NULL,
  `fecha` datetime NOT NULL,
  `numero` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `condiciones` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `tipo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `estado` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `detallado` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `importe` decimal(9,2) NOT NULL,
  `id_fase` int(11) DEFAULT NULL,
  `id_sector` int(11) DEFAULT NULL,
  `id_obra` int(11) DEFAULT NULL,
  `cif` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `domicilio` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `cp` int(11) DEFAULT NULL,
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `id_usuario` int(11) NOT NULL,
  `importe_final` decimal(9,2) NOT NULL,
  `irpf` decimal(7,2) DEFAULT NULL,
  `nota_interna` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `nota_externa` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `imagen` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `programado` date DEFAULT NULL,
  `lugar` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `fechas` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `impuesto` decimal(7,2) DEFAULT NULL,
  PRIMARY KEY (`id_presupuesto`),
  KEY `FK_client_id` (`id_cliente`),
  KEY `FK_fase_id` (`id_fase`),
  KEY `FK_sector_id` (`id_sector`),
  KEY `FK_obra_id` (`id_obra`),
  KEY `FK_user_id` (`id_usuario`),
  CONSTRAINT `presupuestos_ibfk_1` FOREIGN KEY (`id_cliente`) REFERENCES `clientes` (`client_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `presupuestos_ibfk_2` FOREIGN KEY (`id_usuario`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `presupuestos_ibfk_3` FOREIGN KEY (`id_fase`) REFERENCES `fases` (`id_fase`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `presupuestos_ibfk_4` FOREIGN KEY (`id_obra`) REFERENCES `obras` (`id_obra`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `presupuestos_ibfk_5` FOREIGN KEY (`id_sector`) REFERENCES `sectores` (`id_sector`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `presupuestos`
--

LOCK TABLES `presupuestos` WRITE;
/*!40000 ALTER TABLE `presupuestos` DISABLE KEYS */;
INSERT INTO `presupuestos` VALUES
(16,'PRESUPUESTO DE PRUEBA 3',40,'2025-05-19 00:11:55','2022/13','NUESTRA EMPRES ANO SEIOEÑ\\nDESDE NUESTRAUHDWQDQDVWF','Particular','No enviado','[{\"codigo\":\"3354\",\"cantidad\":\"1 dfgh\",\"descripcion\":\"Arrticulo 7\",\"precio_unitario\":\"10.00\",\"titulo\":null,\"igic\":\"7.00\"}]',10.00,NULL,NULL,NULL,'555555555P','Calle Alejandro Hidalgo, 3',35200,'634827935','roberlp6@gmail.com',13,10.70,0.00,NULL,NULL,'https://centro.factuley.com/image.php?id=CeD4ahiDU2QgDyWgNWYeh69k2',NULL,NULL,NULL,7.00);
/*!40000 ALTER TABLE `presupuestos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `producto`
--

DROP TABLE IF EXISTS `producto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `producto` (
  `id_producto` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `precio` decimal(10,2) NOT NULL,
  `id_subcategoria` int(11) DEFAULT NULL,
  `descripcion` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `numero` int(11) NOT NULL,
  PRIMARY KEY (`id_producto`),
  UNIQUE KEY `numero` (`numero`),
  KEY `id_subcategoria` (`id_subcategoria`),
  CONSTRAINT `producto_ibfk_1` FOREIGN KEY (`id_subcategoria`) REFERENCES `subcategorias` (`id_subcategoria`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `producto`
--

LOCK TABLES `producto` WRITE;
/*!40000 ALTER TABLE `producto` DISABLE KEYS */;
INSERT INTO `producto` VALUES
(17,'Nuevo 1',32.00,NULL,'2222',1),
(18,'Nuevo 2',3.00,NULL,'11111',23),
(20,'1',1.00,NULL,'1',12),
(21,'1',1.00,NULL,'1',13),
(22,'123123',1.00,NULL,'1',1333);
/*!40000 ALTER TABLE `producto` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER before_insert_producto
BEFORE INSERT ON producto
FOR EACH ROW
BEGIN
    IF NEW.numero IS NULL OR NEW.numero = '' THEN
        SET NEW.numero = (
            SELECT IFNULL(MAX(CAST(numero AS UNSIGNED)), 0) + 1 FROM producto
        );
    END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `proveedores`
--

DROP TABLE IF EXISTS `proveedores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `proveedores` (
  `id_proveedor` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `cif` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `cp` int(11) DEFAULT NULL,
  `direccion` int(11) DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `telefono` int(11) DEFAULT NULL,
  `tipo` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id_proveedor`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `proveedores`
--

LOCK TABLES `proveedores` WRITE;
/*!40000 ALTER TABLE `proveedores` DISABLE KEYS */;
INSERT INTO `proveedores` VALUES
(1,'Quesos las palmas','iiii',0,0,'yosoyrubens@gmail.com',661033031,NULL);
/*!40000 ALTER TABLE `proveedores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `proyecto_empleado`
--

DROP TABLE IF EXISTS `proyecto_empleado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `proyecto_empleado` (
  `id_proyecto_empleado` int(11) NOT NULL AUTO_INCREMENT,
  `id_empleado` int(11) DEFAULT NULL,
  `id_proyecto` int(11) DEFAULT NULL,
  `fecha_i` datetime NOT NULL,
  `fecha_f` datetime NOT NULL,
  `id_grupo2` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_proyecto_empleado`),
  KEY `id_empleado` (`id_empleado`),
  KEY `id_proyecto` (`id_proyecto`),
  KEY `id_grupo2` (`id_grupo2`),
  CONSTRAINT `proyecto_empleado_ibfk_1` FOREIGN KEY (`id_empleado`) REFERENCES `empleados` (`id_empleado`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `proyecto_empleado_ibfk_2` FOREIGN KEY (`id_grupo2`) REFERENCES `grupos2` (`id_grupo2`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `proyecto_empleado_ibfk_3` FOREIGN KEY (`id_proyecto`) REFERENCES `proyectos` (`id_proyecto`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `proyecto_empleado`
--

LOCK TABLES `proyecto_empleado` WRITE;
/*!40000 ALTER TABLE `proyecto_empleado` DISABLE KEYS */;
INSERT INTO `proyecto_empleado` VALUES
(6,1,1,'2024-09-02 02:00:00','2024-09-02 06:00:00',NULL),
(11,1,3,'2024-11-12 06:00:00','2024-11-12 18:00:00',NULL),
(12,1,4,'2025-01-14 06:00:00','2025-01-14 18:00:00',NULL),
(13,5,4,'2025-01-28 06:00:00','2025-01-28 18:00:00',NULL),
(14,3,4,'2025-01-28 12:00:00','2025-01-29 00:00:00',NULL),
(15,3,4,'2025-01-28 06:00:00','2025-01-28 18:00:00',NULL),
(16,6,5,'2025-02-04 06:00:00','2025-02-04 18:00:00',NULL),
(17,5,5,'2025-02-04 06:00:00','2025-02-04 18:00:00',NULL),
(18,3,5,'2025-02-04 06:00:00','2025-02-04 18:00:00',NULL);
/*!40000 ALTER TABLE `proyecto_empleado` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `proyecto_trabajador`
--

DROP TABLE IF EXISTS `proyecto_trabajador`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `proyecto_trabajador` (
  `id_proyecto_trabajador` int(11) NOT NULL AUTO_INCREMENT,
  `id_trabajador` int(11) NOT NULL,
  `id_proyecto` int(11) DEFAULT NULL,
  `fecha_i` datetime NOT NULL,
  `fecha_f` datetime NOT NULL,
  PRIMARY KEY (`id_proyecto_trabajador`),
  KEY `FK_t_id` (`id_trabajador`),
  KEY `FK_p_id` (`id_proyecto`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `proyecto_trabajador`
--

LOCK TABLES `proyecto_trabajador` WRITE;
/*!40000 ALTER TABLE `proyecto_trabajador` DISABLE KEYS */;
/*!40000 ALTER TABLE `proyecto_trabajador` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `proyectos`
--

DROP TABLE IF EXISTS `proyectos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `proyectos` (
  `id_proyecto` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `color` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `gastos_adicionales` decimal(10,2) DEFAULT NULL,
  `observaciones` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  PRIMARY KEY (`id_proyecto`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `proyectos`
--

LOCK TABLES `proyectos` WRITE;
/*!40000 ALTER TABLE `proyectos` DISABLE KEYS */;
INSERT INTO `proyectos` VALUES
(1,'Proyecto de prueba','#d81089',10.00,'Es un proyecto de prueba'),
(3,'TENERIFE SUR ','#b77afa',400.00,'DESDE EL DIA 9 DE NOVIEMBRE AL 28 DE NOVIEMBRE ESTARÁN LOS MATERIALES EN ESTA UBICACIÓN: \n'),
(4,'Hospital negrin','#db1988',100.00,'Hospital negrin GC'),
(5,'Boda Marbella 1','#16e525',0.00,'Boda');
/*!40000 ALTER TABLE `proyectos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id_rol` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `links` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_rol`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES
(23,'Administrador','[\"calculonomina\",\"historialnominas\",\"empleadosnomina\",\"contratos\",\"inicio\",\"clientestotales\",\"potencialcliente\",\"emailmarketing\",\"condiciones\",\"crearpresupuesto\",\"historialpresupuestos\",\"presupuestosprogramados\",\"crearfacturamanual\",\"historialfacturasmanuales\",\"historialfacturasrectificadas\",\"bancos\",\"copias_seguridad\",\"facturasprogramadas\",\"cobrospendientes\",\"apartados\",\"equipo\",\"fichajes\",\"fichaje\",\"alerta\",\"misfichajes\",\"alumnos\",\"alumnospotenciales\",\"planes\",\"cursos\",\"docentes\",\"vehiculos\",\"financiacion\",\"historialventas\",\"itv\",\"historialenviositv\",\"ventasmanuales\",\"agregarproductosyservicios\",\"calendariocitas\",\"historialcompras\",\"ofertacumpleanos\",\"enviomasivo\",\"subirrecursos\",\"marketing\",\"crearcarpeta\",\"finanzas\",\"legal\",\"presupuestos_c\",\"otrosrecursos\",\"proveedores\",\"pagoaproveedores\",\"inventario\",\"controldesueldos\",\"miembros\",\"empleados\",\"controldepersonal\",\"condiciones\",\"crearalbaran\",\"historialalbaranes\",\"crearfacturamanualalbaranes\",\"backups\",\"historialactividades\",\"miembros_eventos\",\"historialeventos\",\"historialeventosprueba\",\"historialeventosusuario\",\"logistica_crear_pedido\",\"logistica_estadisticas\",\"logistica_en_ruta\",\"logistica_pedidos_pendientes\",\"logistica_pedidos_entregados\",\"logistica_no_entregado\",\"logistica_historial\",\"logistica_observaciones_carga\",\"logistica_transportistas\",\"logistica_scanner\",\"misformularios\",\"crearformulario\",\"calendariovacaciones\",\"controldevacaciones\",\"misvacaciones\",\"sistemaarchivos\"]'),
(48,'Trabajador','[\"fichaje\",\"misfichajes\"]');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sector_cnae`
--

DROP TABLE IF EXISTS `sector_cnae`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sector_cnae` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sector_id` int(11) DEFAULT NULL,
  `cnae_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_sector_cnae` (`sector_id`,`cnae_id`),
  KEY `cnae_id` (`cnae_id`),
  CONSTRAINT `sector_cnae_ibfk_1` FOREIGN KEY (`sector_id`) REFERENCES `sectors` (`id`),
  CONSTRAINT `sector_cnae_ibfk_2` FOREIGN KEY (`cnae_id`) REFERENCES `cnae` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sector_cnae`
--

LOCK TABLES `sector_cnae` WRITE;
/*!40000 ALTER TABLE `sector_cnae` DISABLE KEYS */;
/*!40000 ALTER TABLE `sector_cnae` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sectores`
--

DROP TABLE IF EXISTS `sectores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sectores` (
  `id_sector` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `id_cliente` int(11) NOT NULL,
  PRIMARY KEY (`id_sector`),
  KEY `FK_sector_client_id` (`id_cliente`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sectores`
--

LOCK TABLES `sectores` WRITE;
/*!40000 ALTER TABLE `sectores` DISABLE KEYS */;
INSERT INTO `sectores` VALUES
(1,'1',0),
(2,'Autónomo',0),
(3,'dfdf',0);
/*!40000 ALTER TABLE `sectores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sectors`
--

DROP TABLE IF EXISTS `sectors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sectors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sector_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sectors`
--

LOCK TABLES `sectors` WRITE;
/*!40000 ALTER TABLE `sectors` DISABLE KEYS */;
/*!40000 ALTER TABLE `sectors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `servicio`
--

DROP TABLE IF EXISTS `servicio`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `servicio` (
  `id_servicio` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `descripcion` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `precio` decimal(7,2) NOT NULL,
  `id_subcategoria` int(11) DEFAULT NULL,
  `numero` int(11) NOT NULL,
  PRIMARY KEY (`id_servicio`),
  UNIQUE KEY `numero` (`numero`),
  KEY `id_subcategoria` (`id_subcategoria`),
  CONSTRAINT `servicio_ibfk_1` FOREIGN KEY (`id_subcategoria`) REFERENCES `subcategorias` (`id_subcategoria`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `servicio`
--

LOCK TABLES `servicio` WRITE;
/*!40000 ALTER TABLE `servicio` DISABLE KEYS */;
INSERT INTO `servicio` VALUES
(11,'Mantenimiento','2222',32.00,NULL,3),
(12,'Reparación','11111',3.00,NULL,4),
(13,'Nuevo 3','2222',32.00,NULL,5),
(14,'nuevo 4','11111',3.00,NULL,6),
(15,'4h','4',45.00,NULL,456);
/*!40000 ALTER TABLE `servicio` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER before_insert_servicio
BEFORE INSERT ON servicio
FOR EACH ROW
BEGIN
    IF NEW.numero IS NULL OR NEW.numero = '' THEN
        SET NEW.numero = (
            SELECT IFNULL(MAX(CAST(numero AS UNSIGNED)), 0) + 1 FROM servicio
        );
    END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `servicio_calendario`
--

DROP TABLE IF EXISTS `servicio_calendario`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `servicio_calendario` (
  `id_servicio_calendario` int(11) NOT NULL AUTO_INCREMENT,
  `id_servicio` int(11) NOT NULL,
  `color` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_servicio_calendario`),
  KEY `id_servicio` (`id_servicio`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `servicio_calendario`
--

LOCK TABLES `servicio_calendario` WRITE;
/*!40000 ALTER TABLE `servicio_calendario` DISABLE KEYS */;
/*!40000 ALTER TABLE `servicio_calendario` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `servicio_trabajador`
--

DROP TABLE IF EXISTS `servicio_trabajador`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `servicio_trabajador` (
  `id_servicio_trabajador` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `id_servicio_calendario` int(11) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `fecha_i` datetime NOT NULL,
  `fecha_f` datetime NOT NULL,
  PRIMARY KEY (`id_servicio_trabajador`),
  KEY `client_id` (`client_id`),
  KEY `id_servicio_calendario` (`id_servicio_calendario`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `servicio_trabajador`
--

LOCK TABLES `servicio_trabajador` WRITE;
/*!40000 ALTER TABLE `servicio_trabajador` DISABLE KEYS */;
/*!40000 ALTER TABLE `servicio_trabajador` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slider`
--

DROP TABLE IF EXISTS `slider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `slider` (
  `slider_id` int(11) NOT NULL AUTO_INCREMENT,
  `slider_title` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `slider_subtitle` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `slider_url` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `slider_btn` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `slider_image` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `slider_data` int(11) NOT NULL,
  PRIMARY KEY (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slider`
--

LOCK TABLES `slider` WRITE;
/*!40000 ALTER TABLE `slider` DISABLE KEYS */;
/*!40000 ALTER TABLE `slider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sms`
--

DROP TABLE IF EXISTS `sms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sms` (
  `id_sms` int(11) NOT NULL AUTO_INCREMENT,
  `fecha_envio` datetime DEFAULT NULL,
  `client_id` int(11) NOT NULL,
  `estado` varchar(255) NOT NULL DEFAULT '',
  `cuerpo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `fecha_programado` datetime DEFAULT NULL,
  `tipo` varchar(255) NOT NULL DEFAULT 'sms',
  PRIMARY KEY (`id_sms`),
  KEY `vwer` (`client_id`),
  CONSTRAINT `sms_ibfk_1` FOREIGN KEY (`client_id`) REFERENCES `clientes` (`client_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sms`
--

LOCK TABLES `sms` WRITE;
/*!40000 ALTER TABLE `sms` DISABLE KEYS */;
INSERT INTO `sms` VALUES
(8,'2025-05-01 19:48:05',37,'Enviado','Hola %nombreyapellido%','2025-05-01 18:48:00','sms');
/*!40000 ALTER TABLE `sms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subcategorias`
--

DROP TABLE IF EXISTS `subcategorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `subcategorias` (
  `id_subcategoria` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_subcategoria`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subcategorias`
--

LOCK TABLES `subcategorias` WRITE;
/*!40000 ALTER TABLE `subcategorias` DISABLE KEYS */;
INSERT INTO `subcategorias` VALUES
(1,'Test'),
(2,'Test'),
(3,'Test');
/*!40000 ALTER TABLE `subcategorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subfamilias`
--

DROP TABLE IF EXISTS `subfamilias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `subfamilias` (
  `id_subfamilia` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id_familia` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_subfamilia`),
  KEY `id_familia` (`id_familia`),
  CONSTRAINT `subfamilias_ibfk_1` FOREIGN KEY (`id_familia`) REFERENCES `familias` (`id_familia`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subfamilias`
--

LOCK TABLES `subfamilias` WRITE;
/*!40000 ALTER TABLE `subfamilias` DISABLE KEYS */;
/*!40000 ALTER TABLE `subfamilias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subvenciones`
--

DROP TABLE IF EXISTS `subvenciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `subvenciones` (
  `id_subvencion` int(11) NOT NULL AUTO_INCREMENT,
  `titulo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `estado` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `url_generico` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `email_marketing` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `url_autonomo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `url_sociedad` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `descripcion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `fecha` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_subvencion`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subvenciones`
--

LOCK TABLES `subvenciones` WRITE;
/*!40000 ALTER TABLE `subvenciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `subvenciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tag`
--

DROP TABLE IF EXISTS `tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tag` (
  `id_tag` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_tag`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tag`
--

LOCK TABLES `tag` WRITE;
/*!40000 ALTER TABLE `tag` DISABLE KEYS */;
INSERT INTO `tag` VALUES
(1,'gf');
/*!40000 ALTER TABLE `tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tag_cliente`
--

DROP TABLE IF EXISTS `tag_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tag_cliente` (
  `id_tag` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `id_tag_cliente` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id_tag_cliente`),
  KEY `id_tag` (`id_tag`),
  KEY `client_id` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tag_cliente`
--

LOCK TABLES `tag_cliente` WRITE;
/*!40000 ALTER TABLE `tag_cliente` DISABLE KEYS */;
/*!40000 ALTER TABLE `tag_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tickets`
--

DROP TABLE IF EXISTS `tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tickets` (
  `ticket_id` int(11) NOT NULL AUTO_INCREMENT,
  `ticket_user` int(11) NOT NULL,
  `ticket_assistant` int(11) DEFAULT NULL,
  `ticket_title` tinytext NOT NULL,
  `ticket_status` tinytext NOT NULL,
  `ticket_response_date` int(11) DEFAULT NULL,
  `ticket_date` int(11) NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `fk_logins_users_idx` (`ticket_user`),
  KEY `fk_tickets_users1_idx` (`ticket_assistant`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tickets`
--

LOCK TABLES `tickets` WRITE;
/*!40000 ALTER TABLE `tickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `tickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tipo_pelo`
--

DROP TABLE IF EXISTS `tipo_pelo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tipo_pelo` (
  `id_tipo_pelo` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_tipo_pelo`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tipo_pelo`
--

LOCK TABLES `tipo_pelo` WRITE;
/*!40000 ALTER TABLE `tipo_pelo` DISABLE KEYS */;
/*!40000 ALTER TABLE `tipo_pelo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tools`
--

DROP TABLE IF EXISTS `tools`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tools` (
  `tool_id` int(11) NOT NULL AUTO_INCREMENT,
  `tool_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `tool_url` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `tool_image` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `tool_discard` int(11) DEFAULT NULL,
  PRIMARY KEY (`tool_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tools`
--

LOCK TABLES `tools` WRITE;
/*!40000 ALTER TABLE `tools` DISABLE KEYS */;
/*!40000 ALTER TABLE `tools` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trabajadores`
--

DROP TABLE IF EXISTS `trabajadores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trabajadores` (
  `id_trabajador` int(11) NOT NULL AUTO_INCREMENT,
  `cif` varchar(255) NOT NULL,
  `precio_hora` int(11) NOT NULL,
  `horas_totales` int(11) NOT NULL,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `precio_horas_extra` int(11) NOT NULL,
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_trabajador`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trabajadores`
--

LOCK TABLES `trabajadores` WRITE;
/*!40000 ALTER TABLE `trabajadores` DISABLE KEYS */;
/*!40000 ALTER TABLE `trabajadores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transportistas`
--

DROP TABLE IF EXISTS `transportistas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transportistas` (
  `id_transportista` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `dni` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id_transportista`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transportistas`
--

LOCK TABLES `transportistas` WRITE;
/*!40000 ALTER TABLE `transportistas` DISABLE KEYS */;
/*!40000 ALTER TABLE `transportistas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tutores`
--

DROP TABLE IF EXISTS `tutores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tutores` (
  `id_tutor` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `apellidos` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `parentesco` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL,
  `id_alumno` int(11) NOT NULL,
  PRIMARY KEY (`id_tutor`),
  KEY `id_alumno` (`id_alumno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tutores`
--

LOCK TABLES `tutores` WRITE;
/*!40000 ALTER TABLE `tutores` DISABLE KEYS */;
/*!40000 ALTER TABLE `tutores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ubicaciones`
--

DROP TABLE IF EXISTS `ubicaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ubicaciones` (
  `id_ubicacion` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_ubicacion`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ubicaciones`
--

LOCK TABLES `ubicaciones` WRITE;
/*!40000 ALTER TABLE `ubicaciones` DISABLE KEYS */;
INSERT INTO `ubicaciones` VALUES
(1,'Almacen 4'),
(2,'Almacen 5');
/*!40000 ALTER TABLE `ubicaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `uploads`
--

DROP TABLE IF EXISTS `uploads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `uploads` (
  `upload_id` int(11) NOT NULL AUTO_INCREMENT,
  `upload_name` varchar(100) NOT NULL,
  `upload_original_name` tinytext NOT NULL,
  `upload_mime_type` tinytext NOT NULL,
  `upload_size` int(11) NOT NULL,
  `upload_password` tinytext NOT NULL,
  `upload_date` int(11) NOT NULL,
  PRIMARY KEY (`upload_id`)
) ENGINE=InnoDB AUTO_INCREMENT=416 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `uploads`
--

LOCK TABLES `uploads` WRITE;
/*!40000 ALTER TABLE `uploads` DISABLE KEYS */;
INSERT INTO `uploads` VALUES
(365,'JqQtMpGKrMOC9EpYGL92Z8q73','caxfdh.png','image/png',8833,'zfvnGL5jMmwSqzcn4KfwGuQoEHxOpTL9tQZ5KqYS+Qo=',1683294725),
(366,'ix7XQcvhzdaaoqIPXeSEtgIO7','image.png','image/png',12697,'ERGj8xcgbslU3szPojVcxt3QD+M+sfSTtuyOcrqbVrM=',1683294774),
(382,'TjztTZkaBHyhn9hxLQYNGgoKr','image (1).jpg','image/jpeg',188606,'4X1et1oq47DZc+YBKUiGKUpBBEu4TMs0uFekrcNoRPg=',1687948406),
(389,'IqIY6yoXv9DVSpAfCBhLQyfgn','image.png','image/png',75768,'J4iZW/CHQQJ8LUyw72+30zYeDYpynoo6DZgzRQ+5e3g=',1689663082),
(390,'Ws9DF5UMOiRh4sZhJwV8asGWI','image (2).png','image/png',26120,'ugIh0KWba0mMyz+GNwGfe7YoidGwpRW8J/xmDKCk3YM=',1689663089),
(391,'8d4gbFY5aY3AkU1SZnnN4eGvb','logo_white_1.png','image/png',73698,'JrLujh6L6UYpnu4bIK6VfN0nC1ImjBdAo4LdD0dZ9b4=',1690253261),
(392,'CeD4ahiDU2QgDyWgNWYeh69k2','logo_1.png','image/png',107853,'tDzw4bjT/3P35bsbJG83/ny6eR7HcewZ4DBjtkX0P3Q=',1690253491),
(413,'5LT7VM4o6jokGm9Qex5pFtR6q','1111111111111.png','image/png',100197,'n06eauS5GwCMySohCSvaDPrURSzdcvwrOgQE2awttC0=',1743617544),
(415,'JuycLHxZ5YaxR900UzkNbxVIr','logo alargado.png','image/png',66562,'tc6Vl9oYy7LjFZapPNthHQ9LlZoNV+g7XS+gQZdO8Q8=',1747610863);
/*!40000 ALTER TABLE `uploads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_copia`
--

DROP TABLE IF EXISTS `user_copia`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_copia` (
  `id_user_copia` int(11) NOT NULL AUTO_INCREMENT,
  `id_copia_seguridad` int(11) NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id_user_copia`),
  KEY `id_copia_seguridad` (`id_copia_seguridad`)
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_copia`
--

LOCK TABLES `user_copia` WRITE;
/*!40000 ALTER TABLE `user_copia` DISABLE KEYS */;
INSERT INTO `user_copia` VALUES
(1,3,'javiervs9797@gmail.com'),
(2,4,'javiervs9797@gmail.com'),
(3,5,'javiervs9797@gmail.com'),
(4,6,'javiervs9797@gmail.com'),
(5,7,'javiervs9797@gmail.com'),
(6,8,'javiervs9797@gmail.com'),
(7,9,'javiervs9797@gmail.com'),
(8,10,'javiervs9797@gmail.com'),
(9,11,'javiervs9797@gmail.com'),
(10,12,'javiervs9797@gmail.com'),
(11,13,'limixerr@gmail.com'),
(12,14,'limixerr@gmail.com'),
(13,15,'limixerr@gmail.com'),
(14,16,'limixerr@gmail.com'),
(15,17,'limixerr@gmail.com'),
(16,18,'limixerr@gmail.com'),
(17,19,'limixerr@gmail.com'),
(18,20,'limixerr@gmail.com'),
(19,21,'limixerr@gmail.com'),
(20,22,'limixerr@gmail.com'),
(21,23,'limixerr@gmail.com'),
(22,24,'limixerr@gmail.com'),
(23,25,'limixerr@gmail.com'),
(24,26,'limixerr@gmail.com'),
(25,27,'limixerr@gmail.com'),
(26,28,'limixerr@gmail.com'),
(27,29,'limixerr@gmail.com'),
(28,30,'limixerr@gmail.com'),
(29,31,'limixerr@gmail.com'),
(30,32,'limixerr@gmail.com'),
(31,33,'limixerr@gmail.com'),
(32,34,'limixerr@gmail.com'),
(33,35,'limixerr@gmail.com'),
(34,36,'limixerr@gmail.com'),
(35,37,'limixerr@gmail.com'),
(36,38,'limixerr@gmail.com'),
(37,39,'limixerr@gmail.com'),
(38,40,'limixerr@gmail.com'),
(39,41,'limixerr@gmail.com'),
(40,42,'limixerr@gmail.com'),
(41,43,'limixerr@gmail.com'),
(42,44,'limixerr@gmail.com'),
(43,45,'limixerr@gmail.com'),
(44,46,'limixerr@gmail.com'),
(45,47,'limixerr@gmail.com'),
(46,48,'limixerr@gmail.com'),
(47,49,'limixerr@gmail.com'),
(48,50,'limixerr@gmail.com'),
(49,51,'limixerr@gmail.com'),
(50,52,'limixerr@gmail.com'),
(51,53,'limixerr@gmail.com'),
(52,54,'limixerr@gmail.com'),
(53,55,'limixerr@gmail.com'),
(54,56,'limixerr@gmail.com'),
(55,57,'limixerr@gmail.com'),
(56,58,'limixerr@gmail.com'),
(57,59,'limixerr@gmail.com'),
(58,60,'limixerr@gmail.com'),
(59,61,'limixerr@gmail.com'),
(60,62,'limixerr@gmail.com'),
(61,63,'limixerr@gmail.com'),
(62,64,'limixerr@gmail.com'),
(63,65,'limixerr@gmail.com'),
(64,66,'limixerr@gmail.com'),
(65,67,'limixerr@gmail.com'),
(66,68,'limixerr@gmail.com'),
(67,69,'limixerr@gmail.com'),
(68,70,'limixerr@gmail.com'),
(69,71,'limixerr@gmail.com'),
(70,72,'limixerr@gmail.com'),
(71,73,'limixerr@gmail.com'),
(72,74,'limixerr@gmail.com'),
(73,75,'limixerr@gmail.com'),
(74,76,'limixerr@gmail.com'),
(75,77,'limixerr@gmail.com'),
(76,78,'limixerr@gmail.com'),
(77,79,'limixerr@gmail.com'),
(78,80,'limixerr@gmail.com'),
(79,81,'limixerr@gmail.com'),
(80,82,'limixerr@gmail.com'),
(81,83,'limixerr@gmail.com'),
(82,84,'limixerr@gmail.com'),
(83,85,'limixerr@gmail.com'),
(84,86,'limixerr@gmail.com'),
(85,87,'limixerr@gmail.com'),
(86,88,'limixerr@gmail.com'),
(87,89,'limixerr@gmail.com');
/*!40000 ALTER TABLE `user_copia` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_evento`
--

DROP TABLE IF EXISTS `user_evento`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_evento` (
  `id_user_evento` int(11) NOT NULL AUTO_INCREMENT,
  `id_evento` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `contrato` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `nif` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `contrato_lleno` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `horario_lleno` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `direccion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `cp` int(11) DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `uniforme` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT 'No entregado',
  PRIMARY KEY (`id_user_evento`),
  KEY `user_id` (`user_id`),
  KEY `id_evento` (`id_evento`),
  CONSTRAINT `user_evento_ibfk_1` FOREIGN KEY (`id_evento`) REFERENCES `eventos` (`id_evento`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_evento`
--

LOCK TABLES `user_evento` WRITE;
/*!40000 ALTER TABLE `user_evento` DISABLE KEYS */;
INSERT INTO `user_evento` VALUES
(1,1,13,'../contratos/1/13/contrato_vacio.pdf','ewteer','../contratos/1/13/contrato_lleno.pdf','../horarios/1/13/horario_lleno.pdf','Pellegrino 2045',7400,'fede.gundel@gmail.com','+34 22846121397','No entregado'),
(2,2,14,'../contratos/2/14/contrato_vacio.pdf','2134234',NULL,'../horarios/2/14/horario_lleno.pdf','12342',34123,'fede.gundel@gmail.com',NULL,'No entregado'),
(3,2,6680,'../contratos/2/6680/contrato_vacio.pdf','2134234',NULL,NULL,'12342',34123,'32123',NULL,'No entregado');
/*!40000 ALTER TABLE `user_evento` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_permiso`
--

DROP TABLE IF EXISTS `user_permiso`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_permiso` (
  `id_user_permiso` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `folder_id` int(11) NOT NULL,
  PRIMARY KEY (`id_user_permiso`),
  KEY `user_id` (`user_id`),
  KEY `folder_id` (`folder_id`),
  CONSTRAINT `user_permiso_ibfk_1` FOREIGN KEY (`folder_id`) REFERENCES `folders` (`folder_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_permiso_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=143 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_permiso`
--

LOCK TABLES `user_permiso` WRITE;
/*!40000 ALTER TABLE `user_permiso` DISABLE KEYS */;
INSERT INTO `user_permiso` VALUES
(84,6680,17),
(85,6680,19),
(86,14,19),
(142,6736,22);
/*!40000 ALTER TABLE `user_permiso` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_role` tinyint(4) NOT NULL DEFAULT 0,
  `user_origin` tinyint(4) NOT NULL DEFAULT 0,
  `user_supervisor` int(11) DEFAULT NULL,
  `user_email` tinytext NOT NULL,
  `user_password` varchar(256) DEFAULT NULL,
  `user_full_name` text NOT NULL,
  `user_avatar` text DEFAULT NULL,
  `user_code` varchar(45) NOT NULL,
  `user_verification_status` tinyint(4) NOT NULL DEFAULT 0,
  `user_language` varchar(30) NOT NULL,
  `user_last_seen` int(11) DEFAULT NULL,
  `modal_configuration` int(11) DEFAULT NULL,
  `user_first_seen` int(11) DEFAULT NULL,
  `id_rol` int(11) DEFAULT NULL,
  `notificado` tinyint(1) NOT NULL DEFAULT 0,
  `trabajador_peluqueria` tinyint(1) NOT NULL DEFAULT 0,
  `fondo_portada` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT './assets/img/fondo_default.jpg',
  `emails` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`emails`)),
  PRIMARY KEY (`user_id`),
  KEY `fk_users_users1_idx` (`user_supervisor`),
  KEY `user_ROL` (`id_rol`)
) ENGINE=InnoDB AUTO_INCREMENT=6739 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES
(13,7,2,NULL,'yosoyrubens@gmail.com','$2y$12$Pzn4ncCWSeUUjrvZ9iyBZedKtP7lLS.C1hZbQZNBCvDdg2SXI5MzK','Ruben Gracida Mena','./image.php?id=JqQtMpGKrMOC9EpYGL92Z8q73','nGM7dh9XNst9QCBDhDZntyT2xS94ZCRcTu7ZhmjzeJPwg',1,'',1747767732,NULL,1663334351,23,0,1,'https://centro.factuley.com/image.php?id=TjztTZkaBHyhn9hxLQYNGgoKr','[]'),
(6707,7,2,NULL,'fede.gundel@gmail.com','','Federico Gundel','https://centro.factuley.com/image.php?id=JuycLHxZ5YaxR900UzkNbxVIr','uYFekxA1QHdKXkPeyr7qa766h4dgVUwKTCaB6Z4rAaxUv',1,'',0,NULL,1743331491,23,0,0,'./assets/img/fondo_default.jpg',NULL),
(6733,7,3,6707,'gundelagustina@gmail.com','$2y$12$oVidxyxud8AA5w914.ofzu6WDH7WGaggOKZ742Ra/02mB4zypx7Em','Agustina Cuarterola','/assets/images/profile.png','42093166523',1,'',1747433396,NULL,1747298897,48,0,0,'./assets/img/fondo_default.jpg',NULL),
(6734,7,3,6707,'aaaa434342@gmail.com','$2y$12$ckj9ITR2GSQNhxeDNSk3Ae6JaKkjFHmV2HwTEl6nFrWOeTcA9IfUa','Alberto Andreu','','3353048118',1,'',1747438314,NULL,1747346030,23,0,0,'https://centro.factuley.com/image.php?id=TjztTZkaBHyhn9hxLQYNGgoKr',NULL),
(6735,7,3,NULL,'liberrimostyle@gmail.com','$2y$12$I/KgB0iz22V0Egws1OJ0XO9O20Om4GOzVdIniWpAtaz1Dfow1f1PW','Measure Labs','/assets/images/profile.png','5128523533',0,'',0,NULL,1747414787,48,0,0,'./assets/img/fondo_default.jpg',NULL),
(6736,7,3,NULL,'roberlp6@gmail.com','$2y$12$nyufDdugzb/Qn4Da.RRvCe9sULWFfv6.Cj6CS94cBDW7c9LJICRnS','Roberto Limiñana Ramos','https://centro.factuley.com/image.php?id=JuycLHxZ5YaxR900UzkNbxVIr','80819871301',1,'',1747430388,NULL,1747429941,23,0,0,'https://centro.factuley.com/image.php?id=Ws9DF5UMOiRh4sZhJwV8asGWI',NULL),
(6738,7,3,NULL,'albertorodriguez6545@gmail.com','$2y$12$oXwXxpdNR.bnwYQIes30j.OTYlNaccAWgezGM3DrMdYweXmQZ34qu','Alberto','/assets/images/profile.png','75631876168',1,'',0,NULL,1747530344,48,0,0,'./assets/img/fondo_default.jpg',NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vacaciones`
--

DROP TABLE IF EXISTS `vacaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `vacaciones` (
  `id_vacacion` int(11) NOT NULL AUTO_INCREMENT,
  `fecha_i` date NOT NULL,
  `fecha_f` date NOT NULL,
  `user_id` int(11) NOT NULL,
  `estado` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id_vacacion`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `vacaciones_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vacaciones`
--

LOCK TABLES `vacaciones` WRITE;
/*!40000 ALTER TABLE `vacaciones` DISABLE KEYS */;
INSERT INTO `vacaciones` VALUES
(21,'2025-05-01','2025-05-09',13,'Aceptado'),
(22,'2025-05-11','2025-05-31',13,'Aceptado'),
(25,'2025-05-21','2025-05-24',6707,'Pendiente'),
(26,'2025-04-30','2025-05-02',6707,'Pendiente'),
(27,'2025-05-04','2025-05-10',6707,'Pendiente');
/*!40000 ALTER TABLE `vacaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vehiculos`
--

DROP TABLE IF EXISTS `vehiculos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `vehiculos` (
  `id_vehiculo` int(11) NOT NULL AUTO_INCREMENT,
  `exposicion` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `id_modelo` int(11) DEFAULT NULL,
  `id_marca` int(11) DEFAULT NULL,
  `fecha_matriculacion` date DEFAULT NULL,
  `proxima_itv` date NOT NULL,
  `id_combustible` int(11) DEFAULT NULL,
  `kilometros` decimal(10,2) NOT NULL,
  `matricula` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `envio_vencimiento` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_vehiculo`),
  UNIQUE KEY `matricula` (`matricula`),
  KEY `fk_modelo` (`id_modelo`),
  KEY `fk_combustible` (`id_combustible`),
  KEY `fk_marca` (`id_marca`),
  CONSTRAINT `fk_combustible` FOREIGN KEY (`id_combustible`) REFERENCES `combustibles` (`id_combustible`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `fk_marca` FOREIGN KEY (`id_marca`) REFERENCES `marcas` (`id_marca`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `fk_modelo` FOREIGN KEY (`id_modelo`) REFERENCES `modelos` (`id_modelo`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vehiculos`
--

LOCK TABLES `vehiculos` WRITE;
/*!40000 ALTER TABLE `vehiculos` DISABLE KEYS */;
/*!40000 ALTER TABLE `vehiculos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ventas`
--

DROP TABLE IF EXISTS `ventas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ventas` (
  `id_venta` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `id_vehiculo` int(11) DEFAULT NULL,
  `id_financiera` int(11) DEFAULT NULL,
  `plazo` int(11) DEFAULT NULL,
  `id_metodo` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  PRIMARY KEY (`id_venta`),
  UNIQUE KEY `unique_id_vehiculo` (`id_vehiculo`),
  KEY `fk_financieras` (`id_financiera`),
  KEY `fk_metodos_pago` (`id_metodo`),
  CONSTRAINT `fk_financieras` FOREIGN KEY (`id_financiera`) REFERENCES `financieras` (`id_financiera`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_metodos_pago` FOREIGN KEY (`id_metodo`) REFERENCES `metodos_pago` (`id_metodo`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `fk_vehiculos` FOREIGN KEY (`id_vehiculo`) REFERENCES `vehiculos` (`id_vehiculo`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ventas`
--

LOCK TABLES `ventas` WRITE;
/*!40000 ALTER TABLE `ventas` DISABLE KEYS */;
/*!40000 ALTER TABLE `ventas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Temporary table structure for view `vista_clientes`
--

DROP TABLE IF EXISTS `vista_clientes`;
/*!50001 DROP VIEW IF EXISTS `vista_clientes`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8mb4;
/*!50001 CREATE VIEW `vista_clientes` AS SELECT
 1 AS `movil`,
  1 AS `client_id`,
  1 AS `nombre`,
  1 AS `direccion`,
  1 AS `cp`,
  1 AS `email`,
  1 AS `telefono`,
  1 AS `cif`,
  1 AS `fecha`,
  1 AS `user_id`,
  1 AS `estado`,
  1 AS `imagen`,
  1 AS `terminos`,
  1 AS `email_marketing`,
  1 AS `subvencionado`,
  1 AS `fecha_nacimiento`,
  1 AS `sms_habilitado`,
  1 AS `felicitado`,
  1 AS `peluqueria`,
  1 AS `tipo`,
  1 AS `sexo`,
  1 AS `emails`,
  1 AS `descuento`,
  1 AS `codigo`,
  1 AS `id_sector`,
  1 AS `linkedin`,
  1 AS `instagram`,
  1 AS `tiktok`,
  1 AS `x`,
  1 AS `facebook`,
  1 AS `forma_juridica`,
  1 AS `nombre_juridico`,
  1 AS `cif_juridico`,
  1 AS `domicilio_fiscal`,
  1 AS `activo`,
  1 AS `codigo_tramitador`,
  1 AS `id_poblacion`,
  1 AS `codigo_gestor`,
  1 AS `codigo_contable`,
  1 AS `web`,
  1 AS `grupos`,
  1 AS `sms_enviados` */;
SET character_set_client = @saved_cs_client;

--
-- Temporary table structure for view `vista_clientes_2`
--

DROP TABLE IF EXISTS `vista_clientes_2`;
/*!50001 DROP VIEW IF EXISTS `vista_clientes_2`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8mb4;
/*!50001 CREATE VIEW `vista_clientes_2` AS SELECT
 1 AS `movil`,
  1 AS `client_id`,
  1 AS `nombre`,
  1 AS `direccion`,
  1 AS `cp`,
  1 AS `email`,
  1 AS `telefono`,
  1 AS `cif`,
  1 AS `fecha`,
  1 AS `user_id`,
  1 AS `estado`,
  1 AS `imagen`,
  1 AS `terminos`,
  1 AS `email_marketing`,
  1 AS `subvencionado`,
  1 AS `fecha_nacimiento`,
  1 AS `sms_habilitado`,
  1 AS `felicitado`,
  1 AS `peluqueria`,
  1 AS `tipo`,
  1 AS `sexo`,
  1 AS `emails`,
  1 AS `descuento`,
  1 AS `codigo`,
  1 AS `id_sector`,
  1 AS `linkedin`,
  1 AS `instagram`,
  1 AS `tiktok`,
  1 AS `x`,
  1 AS `facebook`,
  1 AS `forma_juridica`,
  1 AS `nombre_juridico`,
  1 AS `cif_juridico`,
  1 AS `domicilio_fiscal`,
  1 AS `activo`,
  1 AS `codigo_tramitador`,
  1 AS `id_poblacion`,
  1 AS `codigo_gestor`,
  1 AS `codigo_contable`,
  1 AS `web`,
  1 AS `grupos`,
  1 AS `sms_enviados` */;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `zonas`
--

DROP TABLE IF EXISTS `zonas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `zonas` (
  `id_zona` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `id_cliente` int(11) NOT NULL,
  PRIMARY KEY (`id_zona`),
  KEY `id_cliente` (`id_cliente`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `zonas`
--

LOCK TABLES `zonas` WRITE;
/*!40000 ALTER TABLE `zonas` DISABLE KEYS */;
/*!40000 ALTER TABLE `zonas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Final view structure for view `vista_clientes`
--

/*!50001 DROP VIEW IF EXISTS `vista_clientes`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `vista_clientes` AS select `c`.`movil` AS `movil`,`c`.`client_id` AS `client_id`,`c`.`nombre` AS `nombre`,`c`.`direccion` AS `direccion`,`c`.`cp` AS `cp`,`c`.`email` AS `email`,`c`.`telefono` AS `telefono`,`c`.`cif` AS `cif`,`c`.`fecha` AS `fecha`,`c`.`user_id` AS `user_id`,`c`.`estado` AS `estado`,`c`.`imagen` AS `imagen`,`c`.`terminos` AS `terminos`,`c`.`email_marketing` AS `email_marketing`,`c`.`subvencionado` AS `subvencionado`,`c`.`fecha_nacimiento` AS `fecha_nacimiento`,`c`.`sms_habilitado` AS `sms_habilitado`,`c`.`felicitado` AS `felicitado`,`c`.`peluqueria` AS `peluqueria`,`c`.`tipo` AS `tipo`,`c`.`sexo` AS `sexo`,`c`.`emails` AS `emails`,`c`.`descuento` AS `descuento`,`c`.`codigo` AS `codigo`,`c`.`id_sector` AS `id_sector`,`c`.`linkedin` AS `linkedin`,`c`.`instagram` AS `instagram`,`c`.`tiktok` AS `tiktok`,`c`.`x` AS `x`,`c`.`facebook` AS `facebook`,`c`.`forma_juridica` AS `forma_juridica`,`c`.`nombre_juridico` AS `nombre_juridico`,`c`.`cif_juridico` AS `cif_juridico`,`c`.`domicilio_fiscal` AS `domicilio_fiscal`,`c`.`activo` AS `activo`,`c`.`codigo_tramitador` AS `codigo_tramitador`,`c`.`id_poblacion` AS `id_poblacion`,`c`.`codigo_gestor` AS `codigo_gestor`,`c`.`codigo_contable` AS `codigo_contable`,`c`.`web` AS `web`,nullif(json_arrayagg(if(`g`.`id_grupo` is not null,json_object('id_grupo',`g`.`id_grupo`,'nombre',`g`.`nombre`),NULL)),'[null]') AS `grupos`,nullif(json_arrayagg(if(`s`.`id_sms` is not null,json_object('id_sms',`s`.`id_sms`,'fecha_envio',`s`.`fecha_envio`,'estado',`s`.`estado`,'cuerpo',`s`.`cuerpo`,'fecha_programado',`s`.`fecha_programado`,'tipo',`s`.`tipo`),NULL)),'[null]') AS `sms_enviados` from (((`clientes` `c` left join `grupo_cliente` `gc` on(`c`.`client_id` = `gc`.`client_id`)) left join `grupos` `g` on(`gc`.`id_grupo` = `g`.`id_grupo`)) left join `sms` `s` on(`c`.`client_id` = `s`.`client_id`)) group by `c`.`movil`,`c`.`client_id`,`c`.`nombre`,`c`.`direccion`,`c`.`cp`,`c`.`email`,`c`.`telefono`,`c`.`cif`,`c`.`fecha`,`c`.`user_id`,`c`.`estado`,`c`.`imagen`,`c`.`terminos`,`c`.`email_marketing`,`c`.`subvencionado`,`c`.`fecha_nacimiento`,`c`.`sms_habilitado`,`c`.`felicitado`,`c`.`peluqueria`,`c`.`tipo`,`c`.`sexo`,`c`.`emails`,`c`.`descuento`,`c`.`codigo`,`c`.`id_sector`,`c`.`linkedin`,`c`.`instagram`,`c`.`tiktok`,`c`.`x`,`c`.`facebook`,`c`.`forma_juridica`,`c`.`nombre_juridico`,`c`.`cif_juridico`,`c`.`domicilio_fiscal`,`c`.`activo`,`c`.`codigo_tramitador`,`c`.`id_poblacion`,`c`.`codigo_gestor`,`c`.`codigo_contable`,`c`.`web` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `vista_clientes_2`
--

/*!50001 DROP VIEW IF EXISTS `vista_clientes_2`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `vista_clientes_2` AS select `c`.`movil` AS `movil`,`c`.`client_id` AS `client_id`,`c`.`nombre` AS `nombre`,`c`.`direccion` AS `direccion`,`c`.`cp` AS `cp`,`c`.`email` AS `email`,`c`.`telefono` AS `telefono`,`c`.`cif` AS `cif`,`c`.`fecha` AS `fecha`,`c`.`user_id` AS `user_id`,`c`.`estado` AS `estado`,`c`.`imagen` AS `imagen`,`c`.`terminos` AS `terminos`,`c`.`email_marketing` AS `email_marketing`,`c`.`subvencionado` AS `subvencionado`,`c`.`fecha_nacimiento` AS `fecha_nacimiento`,`c`.`sms_habilitado` AS `sms_habilitado`,`c`.`felicitado` AS `felicitado`,`c`.`peluqueria` AS `peluqueria`,`c`.`tipo` AS `tipo`,`c`.`sexo` AS `sexo`,`c`.`emails` AS `emails`,`c`.`descuento` AS `descuento`,`c`.`codigo` AS `codigo`,`c`.`id_sector` AS `id_sector`,`c`.`linkedin` AS `linkedin`,`c`.`instagram` AS `instagram`,`c`.`tiktok` AS `tiktok`,`c`.`x` AS `x`,`c`.`facebook` AS `facebook`,`c`.`forma_juridica` AS `forma_juridica`,`c`.`nombre_juridico` AS `nombre_juridico`,`c`.`cif_juridico` AS `cif_juridico`,`c`.`domicilio_fiscal` AS `domicilio_fiscal`,`c`.`activo` AS `activo`,`c`.`codigo_tramitador` AS `codigo_tramitador`,`c`.`id_poblacion` AS `id_poblacion`,`c`.`codigo_gestor` AS `codigo_gestor`,`c`.`codigo_contable` AS `codigo_contable`,`c`.`web` AS `web`,coalesce(json_arrayagg(case when `g`.`id_grupo` is not null then json_object('id_grupo',`g`.`id_grupo`,'nombre',`g`.`nombre`) else NULL end),'[]') AS `grupos`,coalesce(json_arrayagg(case when `s`.`id_sms` is not null then json_object('id_sms',`s`.`id_sms`,'tipo',`s`.`tipo`,'fecha_envio',`s`.`fecha_envio`,'estado',`s`.`estado`,'cuerpo',`s`.`cuerpo`,'fecha_programado',`s`.`fecha_programado`) else NULL end),'[]') AS `sms_enviados` from (((`clientes` `c` left join `grupo_cliente` `gc` on(`c`.`client_id` = `gc`.`client_id`)) left join `grupos` `g` on(`gc`.`id_grupo` = `g`.`id_grupo`)) left join `sms` `s` on(`c`.`client_id` = `s`.`client_id`)) group by `c`.`movil`,`c`.`client_id`,`c`.`nombre`,`c`.`direccion`,`c`.`cp`,`c`.`email`,`c`.`telefono`,`c`.`cif`,`c`.`fecha`,`c`.`user_id`,`c`.`estado`,`c`.`imagen`,`c`.`terminos`,`c`.`email_marketing`,`c`.`subvencionado`,`c`.`fecha_nacimiento`,`c`.`sms_habilitado`,`c`.`felicitado`,`c`.`peluqueria`,`c`.`tipo`,`c`.`sexo`,`c`.`emails`,`c`.`descuento`,`c`.`codigo`,`c`.`id_sector`,`c`.`linkedin`,`c`.`instagram`,`c`.`tiktok`,`c`.`x`,`c`.`facebook`,`c`.`forma_juridica`,`c`.`nombre_juridico`,`c`.`cif_juridico`,`c`.`domicilio_fiscal`,`c`.`activo`,`c`.`codigo_tramitador`,`c`.`id_poblacion`,`c`.`codigo_gestor`,`c`.`codigo_contable`,`c`.`web` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-05-21 12:24:05
