<?php



include "utils.php";



$dbConn = connect($db);



if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    if (isset($_GET['q'])) {
        
        $sql = $dbConn->prepare("ALTER TABLE clientes 
MODIFY COLUMN codigo INT;
");

       
      

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->execute());

        exit();

    }
    if (isset($_GET['copia'])) {

        // Crear un respaldo de la base de datos

        $backup = createDatabaseBackup($dbConn, $db);



        if ($backup) {

            header("HTTP/1.1 200 OK");

            echo json_encode($backup);

        } else {

            header("HTTP/1.1 500 Internal Server Error");

            echo json_encode($backup);

        }

        exit();

    } else {

        // Mostrar lista de bancos

        $sql = $dbConn->prepare("SELECT * FROM backups");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetchAll());

        exit();

    }

}



function createDatabaseBackup($dbConn, $db) {

    $host = $db['host'];

    $user = $db['username'];

    $password = $db['password'];

    $database = $db['db'];



    // Fecha en formato `Y-m-d`

    $fecha = date("Y-m-d");



    // Crear una carpeta temporal

    $tempDir = "backups/temp";

    if (!file_exists($tempDir) && !mkdir($tempDir, 0777, true)) {

        return ["error" => "No se pudo crear la carpeta temporal $tempDir"];

    }



    // Ruta temporal del archivo de respaldo

    $tempFile = "$tempDir/backup_temp.sql";



    // Comando para generar el backup y capturar errores

    $errorFile = "$tempDir/error.log";

    $command = "mysqldump  --host=$host --user=$user --password=$password $database > $tempFile 2> $errorFile";



    system($command, $output);



    // Verificar si el backup falló

    if ($output !== 0 || !file_exists($tempFile)) {

        $errorMessage = file_exists($errorFile) ? file_get_contents($errorFile) : "Error desconocido al ejecutar mysqldump";

        return ["error" => "Error al generar el backup", "detalle" => trim($errorMessage)];

    }



    // Insertar en la base de datos solo si el backup fue exitoso

    try {

        $sql = "INSERT INTO backups (fecha) VALUES (:fecha)";

        $stmt = $dbConn->prepare($sql);

        $stmt->bindParam(':fecha', $fecha);

        $stmt->execute();

        $id_backup = $dbConn->lastInsertId();

    } catch (PDOException $e) {

        return ["error" => "Error al insertar en la base de datos", "detalle" => $e->getMessage()];

    }



    // Mover el archivo a la carpeta definitiva

    $backupDir = "backups/$id_backup";

    if (!file_exists($backupDir) && !mkdir($backupDir, 0777, true)) {

        return ["error" => "No se pudo crear la carpeta de backup $backupDir"];

    }



    $backupFile = "$backupDir/backup_$id_backup.sql";

    if (!rename($tempFile, $backupFile)) {

        return ["error" => "No se pudo mover el archivo de backup", "detalle" => "De $tempFile a $backupFile"];

    }



    return ["success" => "Backup creado con éxito", "file" => $backupFile, "id" => $id_backup];

}





header("HTTP/1.1 400 Bad Request");