<?php



include "utils.php";



$dbConn = connect($db);
// Permitir acceso desde cualquier origen (puedes cambiar "*" por tu dominio específico)
header("Access-Control-Allow-Origin: *");

// Permitir los métodos que se pueden usar en la solicitud
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");

// Permitir los encabezados que el cliente puede enviar
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

// Si es una solicitud OPTIONS, no procesar más, solo devolver las cabeceras
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    header('HTTP/1.1 200 OK');
    exit();
}


/*

listar todos los posts o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_grupo'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM grupos where id_grupo=:id_grupo");

        $sql->bindValue(':id_grupo', $_GET['id_grupo']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();

    } else {

        //Mostrar lista de post

        $sql = $dbConn->prepare("SELECT * FROM grupos");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");



        echo json_encode($sql->fetchAll());

        exit();

    }

}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (isset($_POST["user"]) && isset($_POST["password"])) {
        $email = $_POST["user"];
        $password = $_POST["password"];
    
        // Buscar el usuario por el correo electrónico
        $sql = "SELECT * FROM users WHERE user_email = :email LIMIT 1";
        $stmt = $dbConn->prepare($sql);
        $stmt->bindValue(':email', $email);
        $stmt->execute();
    
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
        if ($user) {
            // Verificar la contraseña con bcrypt
            if (password_verify($password, $user['user_password'])) {
                unset($user['user_password']); // No enviar la contraseña en la respuesta
                header("HTTP/1.1 200 OK");
                echo json_encode(["user" => $user]); // Responder con los datos del usuario
                exit();
            }
        }
    
        // Si la contraseña no coincide o el usuario no existe
        header("HTTP/1.1 401 Unauthorized");
        echo json_encode(["error" => "Usuario o contraseña incorrectos"]);
        exit();
    }
    
    

    if (isset($_POST["id_grupo_agregar"]) && isset($_POST["client_ids_agregar"])) {

        $id_grupo = $_POST["id_grupo_agregar"];

        $client_ids = json_decode($_POST['client_ids_agregar'], true);



        foreach ($client_ids as $client_id) {

            $sql = "INSERT INTO grupo_cliente

        (id_grupo,client_id)

        VALUES

        (:id_grupo,:client_id)";



            $statement = $dbConn->prepare($sql);



            $statement->bindValue(':id_grupo', $id_grupo);

            $statement->bindValue(':client_id', $client_id);

            $statement->execute();



        }







        header("HTTP/1.1 200 OK");

        echo json_encode(1);

        exit();



    }

    if (isset($_POST["id_grupo_remover"]) && isset($_POST["client_ids_remover"])) {

        $id_grupo = $_POST["id_grupo_remover"];

        $client_ids = json_decode($_POST['client_ids_remover'], true);



        foreach ($client_ids as $client_id) {

            $sql = "DELETE FROM grupo_cliente where client_id =:client_id AND id_grupo = :id_grupo";



            $statement = $dbConn->prepare($sql);



            $statement->bindValue(':client_id', $client_id);

            $statement->bindValue(':id_grupo', $id_grupo);

            $statement->execute();



        }







        header("HTTP/1.1 200 OK");

        echo json_encode(1);

        exit();



    }

}



if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    if (isset($_GET["id_grupo"])) {

        $id = $_GET['id_grupo'];

        $statement = $dbConn->prepare("DELETE FROM grupo_cliente where id_grupo =:id");

        $statement->bindValue(':id', $id);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        exit();

    }



    if (isset($_GET["id"])) {

        $id = $_GET['id'];

        $statement = $dbConn->prepare("DELETE FROM grupos where id_grupo =:id");

        $statement->bindValue(':id', $id);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        exit();

    }

}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

}



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");