<?php



include "utils.php";



$dbConn = connect($db);



/*

listar todos los posts o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['codigo'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT apartados.*, 

       medidas.nombre AS nombre_medida, 

       igic.porcentaje,

       apartados.stock - IFNULL(afm.cantidad_total, 0) AS stock_disponible

FROM apartados

LEFT JOIN medidas ON apartados.id_medida = medidas.id_medida

LEFT JOIN igic ON apartados.id_igic = igic.id_igic

LEFT JOIN (

    SELECT afm.codigo, 

           SUM(CAST(SUBSTRING_INDEX(COALESCE(afr.cantidad, afm.cantidad), ' ', 1) AS UNSIGNED)) AS cantidad_total

    FROM apartado_factura_manual afm

    LEFT JOIN apartado_factura_rectificada afr ON afm.id_apartado_factura_manual = afr.id_apartado_factura_manual

    GROUP BY afm.codigo

) afm ON apartados.codigo = afm.codigo

where apartados.codigo=:codigo

ORDER BY apartados.apartado_id DESC ");

        $sql->bindValue(':codigo', $_GET['codigo']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();
    }

    if (isset($_GET['apartado_id'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT apartados.*, 

       medidas.nombre AS nombre_medida, 

       igic.porcentaje,

       apartados.stock - IFNULL(afm.cantidad_total, 0) AS stock_disponible

FROM apartados

LEFT JOIN medidas ON apartados.id_medida = medidas.id_medida

LEFT JOIN igic ON apartados.id_igic = igic.id_igic

LEFT JOIN (

    SELECT afm.codigo, 

           SUM(CAST(SUBSTRING_INDEX(COALESCE(afr.cantidad, afm.cantidad), ' ', 1) AS UNSIGNED)) AS cantidad_total

    FROM apartado_factura_manual afm

    LEFT JOIN apartado_factura_rectificada afr ON afm.id_apartado_factura_manual = afr.id_apartado_factura_manual

    GROUP BY afm.codigo

) afm ON apartados.codigo = afm.codigo

where apartado_id=:apartado_id

ORDER BY apartados.apartado_id DESC ");

        $sql->bindValue(':apartado_id', $_GET['apartado_id']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();
    }

    if (isset($_GET["apartados_factura"])) {





        //Mostrar lista de post

        $sql = $dbConn->prepare("SELECT afm.*, 

       CAST(SUBSTRING_INDEX(COALESCE(afr.cantidad, afm.cantidad), ' ', 1) AS UNSIGNED) AS cantidad_final,

       fm.numero,

       fm.fecha,
c.nombre AS nombre_cliente,
       afr.id_factura_rectificada,

       fr.numero AS numero_factura_rectificada,
 CASE 
           WHEN fm.clase = 'Albaranes' THEN a.numero 
           ELSE 'Sin albarán asociado' 
       END AS numero_albaran_asociado
FROM apartado_factura_manual afm

LEFT JOIN apartado_factura_rectificada afr ON afm.id_apartado_factura_manual = afr.id_apartado_factura_manual

LEFT JOIN factura_manual fm ON afm.id_factura_manual = fm.id_factura_manual
LEFT JOIN albaranes a ON afm.codigo = a.id_albaran
LEFT JOIN clientes c ON fm.client_id = c.client_id
LEFT JOIN facturas_rectificadas fr ON afr.id_factura_rectificada = fr.id_factura_rectificada;");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");



        echo json_encode($sql->fetchAll());

        exit();
    } else {

        //Mostrar lista de post

        $sql = $dbConn->prepare("SELECT apartados.*, 

       medidas.nombre AS nombre_medida, 

       igic.porcentaje,

       apartados.stock - IFNULL(afm.cantidad_total, 0) AS stock_disponible

FROM apartados

LEFT JOIN medidas ON apartados.id_medida = medidas.id_medida

LEFT JOIN igic ON apartados.id_igic = igic.id_igic

LEFT JOIN (

    SELECT afm.codigo, 

           SUM(CAST(SUBSTRING_INDEX(COALESCE(afr.cantidad, afm.cantidad), ' ', 1) AS UNSIGNED)) AS cantidad_total

    FROM apartado_factura_manual afm

    LEFT JOIN apartado_factura_rectificada afr ON afm.id_apartado_factura_manual = afr.id_apartado_factura_manual

    GROUP BY afm.codigo

) afm ON apartados.codigo = afm.codigo

ORDER BY apartados.apartado_id DESC");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");



        echo json_encode($sql->fetchAll());

        exit();
    }
}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {



    if (





        isset($_POST["ean"]) &&

        isset($_POST["id_familia"]) &&

        isset($_POST["id_subfamilia"]) &&

        isset($_POST["id_igic"]) &&

        isset($_POST["id_ubicacion"]) &&



        isset($_POST["titulo"]) &&

        isset($_POST["descripcion"]) &&

        isset($_POST["cantidad"]) &&

        isset($_POST["precio_unitario"]) &&

        isset($_POST["id_medida"]) &&

        isset($_POST["codigo"]) &&

        isset($_POST["numero_lote"]) &&

        isset($_POST["fecha_caducidad"]) &&

        isset($_POST["precio_coste"]) &&

        isset($_POST["stock"]) &&

        isset($_POST["fecha"])

    ) {









        foreach ($_POST as $key => $value) {

            $value = ($value == "") ? null : $value;



            $value = ($value == "No") ? null : $value;

            $$key = $value;
        }







        if (isset($_POST["id_apartado"])) {

            $id_apartado = $_POST["id_apartado"];

            $sqlCheckCode = "SELECT COUNT(*) FROM apartados WHERE codigo = :codigo";

            $statementCheckCode = $dbConn->prepare($sqlCheckCode);

            $statementCheckCode->bindValue(':codigo', $codigo);

            $statementCheckCode->execute();

            $count = $statementCheckCode->fetchColumn();



            if ($count > 0) {

                // El código ya existe, ahora verificar si es el mismo apartado (en caso de actualización)

                if (isset($_POST["id_apartado"])) {

                    $id_apartado = $_POST["id_apartado"];

                    $sqlCheckSameApartado = "SELECT COUNT(*) FROM apartados WHERE codigo = :codigo AND apartado_id = :id_apartado";

                    $statementCheckSameApartado = $dbConn->prepare($sqlCheckSameApartado);

                    $statementCheckSameApartado->bindValue(':codigo', $codigo);

                    $statementCheckSameApartado->bindValue(':id_apartado', $id_apartado);

                    $statementCheckSameApartado->execute();

                    $countSameApartado = $statementCheckSameApartado->fetchColumn();



                    if ($countSameApartado > 0) {

                        // Es el mismo apartado, no hay problema

                    } else {

                        // El código existe pero no es el mismo apartado, retorna 0

                        header("HTTP/1.1 200 OK");

                        echo json_encode(0);

                        exit();
                    }
                } else {

                    // No es una actualización, retorna 0

                    header("HTTP/1.1 200 OK");

                    echo json_encode(0);

                    exit();
                }
            }



            $sql = "UPDATE apartados SET titulo = :titulo ,

                                fecha_caducidad = :fecha_caducidad ,

                            numero_lote = :numero_lote ,

                            descripcion = :descripcion ,

                            cantidad = :cantidad ,

                            precio_unitario = :precio_unitario,

                            fecha = :fecha,

                            id_medida = :id_medida,

                            codigo = :codigo,

                            precio_coste = :precio_coste,

                        ean = :ean,

                        id_familia = :id_familia,

                        id_subfamilia = :id_subfamilia,

                        id_igic = :id_igic,

                            id_ubicacion = :id_ubicacion,

                            stock = :stock

                                                                    

                            WHERE apartado_id = :id_apartado";

            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':id_apartado', $id_apartado);
        } else {

            $sqlCheckCode = "SELECT COUNT(*) FROM apartados WHERE codigo = :codigo";

            $statementCheckCode = $dbConn->prepare($sqlCheckCode);

            $statementCheckCode->bindValue(':codigo', $codigo);

            $statementCheckCode->execute();

            $count = $statementCheckCode->fetchColumn();



            if ($count > 0) {

                // El código ya existe, retorna 0

                header("HTTP/1.1 200 OK");

                echo json_encode(0);

                exit();
            }

            $sql = "INSERT INTO apartados (stock, fecha_caducidad,numero_lote,ean,id_familia,id_subfamilia,id_igic,id_ubicacion,codigo,precio_coste,descripcion,titulo,cantidad,precio_unitario,fecha,id_medida) 

            VALUES (:stock,:fecha_caducidad,:numero_lote,:ean,:id_familia,:id_subfamilia,:id_igic,:id_ubicacion,:codigo,:precio_coste,:descripcion,:titulo,:cantidad,:precio_unitario,:fecha,:id_medida)";

            $statement = $dbConn->prepare($sql);
        }



        $statement->bindValue(':stock', $stock);

        $statement->bindValue(':fecha', $fecha);



        $statement->bindValue(':fecha_caducidad', $fecha_caducidad);

        $statement->bindValue(':numero_lote', $numero_lote);

        $statement->bindValue(':titulo', $titulo);

        $statement->bindValue(':descripcion', $descripcion);

        $statement->bindValue(':cantidad', $cantidad);

        $statement->bindValue(':precio_unitario', $precio_unitario);

        $statement->bindValue(':fecha', $fecha);

        $statement->bindValue(':id_medida', $id_medida);

        $statement->bindValue(':codigo', $codigo);

        $statement->bindValue(':precio_coste', $precio_coste);

        $statement->bindValue(':ean', $ean);

        $statement->bindValue(':id_familia', $id_familia);

        $statement->bindValue(':id_subfamilia', $id_subfamilia);

        $statement->bindValue(':id_igic', $id_igic);

        $statement->bindValue(':id_ubicacion', $id_ubicacion);

        $statement->execute();
        if (!isset($id_apartado)) {
            $id_apartado = $dbConn->lastInsertId();
        }
        
        $sqlGet = "SELECT * FROM apartados WHERE apartado_id = :id_apartado";
        $getStatement = $dbConn->prepare($sqlGet);
        $getStatement->bindValue(':id_apartado', $id_apartado);
        $getStatement->execute();
        $apar = $getStatement->fetch(PDO::FETCH_ASSOC);
        $object = [

            'id' => $id_apartado,

            'titulo' => $titulo,

            'descripcion' => $descripcion,

            'cantidad' => $cantidad,
            'codigo' => $apar["codigo"],

            'precio_unitario' => $precio_unitario,

            'fecha' => $fecha,

            'id_medida' => $id_medida

        ];



        header("HTTP/1.1 200 OK");

        echo json_encode($object);

        exit();
    } elseif (isset($_POST['import_apartados'])) {

        $jsonData = $_POST['import_apartados'];
        $apartados = json_decode($jsonData, true);
        $todoCorrecto = true;

        try {
            if (json_last_error() === JSON_ERROR_NONE && is_array($apartados)) {
                foreach ($apartados as $apartado) {

                    foreach ($apartado as $key => $value) {
                        $value = ($value === "" || $value === null) ? null : $value;

                        $$key = $value;
                    }
                    $stock = ($stock == null) ? 0 : $stock;
                    $id_familia = NULL;
                    $id_subfamilia = NULL;
                    $id_igic = NULL;
                    $id_ubicacion = NULL;
                    $id_medida = NULL;
                    $fecha_caducidad = NULL;
                    $fecha = date('Y-m-d');

                    $exists = false;

                    if ($codigo !== null) {
                        // Comprobamos si el código ya existe en la tabla
                        $checkSql = "SELECT COUNT(*) FROM apartados WHERE codigo = :codigo";
                        $checkStmt = $dbConn->prepare($checkSql);
                        $checkStmt->bindValue(':codigo', $codigo);
                        $checkStmt->execute();
                        $exists = $checkStmt->fetchColumn() > 0;
                    }

                    if ($codigo !== null && $exists) {
                        // Hacer UPDATE si el código existe
                        $sql = "UPDATE apartados SET 
                                titulo = :titulo,
                                fecha_caducidad = :fecha_caducidad,
                                numero_lote = :numero_lote,
                                descripcion = :descripcion,
                                cantidad = :cantidad,
                                precio_unitario = :precio_unitario,
                                fecha = :fecha,
                                id_medida = :id_medida,
                                codigo = :codigo,
                                precio_coste = :precio_coste,
                                ean = :ean,
                                id_familia = :id_familia,
                                id_subfamilia = :id_subfamilia,
                                id_igic = :id_igic,
                                id_ubicacion = :id_ubicacion,
                                stock = :stock
                                WHERE codigo = :codigo";
                        $statement = $dbConn->prepare($sql);
                        $statement->bindValue(':codigo', $codigo);
                    } else {
                        // Hacer INSERT si el código no existe o es null
                        $sql = "INSERT INTO apartados (
                                    stock, fecha_caducidad, numero_lote, ean, id_familia,
                                    id_subfamilia, id_igic, id_ubicacion, codigo,
                                    precio_coste, descripcion, titulo, cantidad,
                                    precio_unitario, fecha, id_medida
                                ) VALUES (
                                    :stock, :fecha_caducidad, :numero_lote, :ean, :id_familia,
                                    :id_subfamilia, :id_igic, :id_ubicacion, :codigo,
                                    :precio_coste, :descripcion, :titulo, :cantidad,
                                    :precio_unitario, :fecha, :id_medida
                                )";
                        $statement = $dbConn->prepare($sql);
                    }

                    // Bind de todos los valores
                    $statement->bindValue(':stock', $stock);
                    $statement->bindValue(':fecha', $fecha);
                    $statement->bindValue(':fecha_caducidad', $fecha_caducidad);
                    $statement->bindValue(':numero_lote', $numero_lote);
                    $statement->bindValue(':titulo', $titulo);
                    $statement->bindValue(':descripcion', $descripcion);
                    $statement->bindValue(':cantidad', $cantidad);
                    $statement->bindValue(':precio_unitario', $precio_unitario);
                    $statement->bindValue(':id_medida', $id_medida);
                    $statement->bindValue(':codigo', $codigo);
                    $statement->bindValue(':precio_coste', $precio_coste);
                    $statement->bindValue(':ean', $ean);
                    $statement->bindValue(':id_familia', $id_familia);
                    $statement->bindValue(':id_subfamilia', $id_subfamilia);
                    $statement->bindValue(':id_igic', $id_igic);
                    $statement->bindValue(':id_ubicacion', $id_ubicacion);

                    if (!$statement->execute()) {
                        $todoCorrecto = false;
                        break;
                    }
                }

                if ($todoCorrecto) {
                    header("HTTP/1.1 200 OK");
                    echo json_encode(['status' => 'success', 'message' => 'Todos los apartados se han agregado correctamente']);
                } else {
                    header("HTTP/1.1 200 OK");
                    echo json_encode(['status' => 'error', 'message' => 'Error al agregar uno o más apartados']);
                }
            } else {
                header("HTTP/1.1 400 Bad Request");
                echo json_encode(['status' => 'error', 'message' => 'Datos JSON inválidos o formato incorrecto']);
            }
        } catch (PDOException $e) {
            header("HTTP/1.1 500 Internal Server Error");
            echo json_encode(['status' => 'error', 'message' => 'Error de base de datos: ' . $e->getMessage()]);
        } catch (Exception $e) {
            header("HTTP/1.1 500 Internal Server Error");
            echo json_encode(['status' => 'error', 'message' => 'Error: ' . $e->getMessage()]);
        }

        exit();
    }
}



//Borrar

if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    $id = $_GET['id'];

    $statement = $dbConn->prepare("DELETE FROM apartados where apartado_id=:id");

    $statement->bindValue(':id', $id);

    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();
}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();
}



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");