<?php

include "utils.php";



$dbConn = connect($db);

/*
  listar todos los posts o solo uno
 */
if ($_SERVER['REQUEST_METHOD'] == 'GET')
  {
  if (isset($_GET["id_miembro2"]))
    {

    //Mostrar un post
    $sql = $dbConn->prepare("SELECT
    anomalia.*,
    users.user_full_name AS nombre
FROM
    anomalia
JOIN
    fichajes ON fichajes.id_fichaje = anomalia.id_fichaje
JOIN
    miembro_equipo ON fichajes.id_miembro = miembro_equipo.id_miembro
JOIN
    users ON miembro_equipo.user_id = users.user_id
    WHERE fichajes.id_miembro = :id_miembro;");
    $sql->bindValue(':id_miembro', $_GET['id_miembro2']);
    $sql->execute();
    $anomalias = $sql->fetchAll(PDO::FETCH_OBJ);

    header("HTTP/1.1 200 OK");
    echo json_encode($anomalias);
    exit();

    }
  if (isset($_GET['id_anomalia']))
    {
    //Mostrar un post
    $sql = $dbConn->prepare("SELECT * FROM anomalia where id_anomalia=:id_anomalia");
    $sql->bindValue(':id_anomalia', $_GET['id_anomalia']);
    $sql->execute();
    header("HTTP/1.1 200 OK");
    echo json_encode($sql->fetch(PDO::FETCH_ASSOC));
    exit();
    } else
    {
    if (isset($_GET['fecha_i']) && isset($_GET['fecha_f']))
      {
      $fecha_i = $_GET['fecha_i'];
      $fecha_f = $_GET['fecha_f'];
      $sql = $dbConn->prepare("SELECT
      fichajes.*,
      users.user_full_name AS nombre
  FROM
      fichajes
  JOIN
      miembro_equipo ON fichajes.id_miembro = miembro_equipo.id_miembro
  JOIN
      users ON miembro_equipo.user_id = users.user_id
      WHERE DATE_FORMAT(fecha, '%Y-%m-%d') BETWEEN :fecha_i AND :fecha_f;");
      $sql->bindValue(':fecha_i', $fecha_i);
      $sql->bindValue(':fecha_f', $fecha_f);
      } else
      {
      $sql = $dbConn->prepare("SELECT
      anomalia.*,
      users.user_full_name AS nombre
  FROM
      anomalia
  JOIN
      fichajes ON fichajes.id_fichaje = anomalia.id_fichaje
  JOIN
      miembro_equipo ON fichajes.id_miembro = miembro_equipo.id_miembro
  JOIN
      users ON miembro_equipo.user_id = users.user_id;");


      }
    $sql->execute();
    $sql->setFetchMode(PDO::FETCH_ASSOC);
    $anomalias = $sql->fetchAll(PDO::FETCH_OBJ);

    header("HTTP/1.1 200 OK");
    // echo var_dump($sql->fetchAll());
    echo json_encode($anomalias);

    exit();
    }
  }

// Crear un nuevo post
if ($_SERVER['REQUEST_METHOD'] == 'POST')
  {
  $input = $_POST;
  $sql = "INSERT INTO posts
          (title, status, content, user_id)
          VALUES
          (:title, :status, :content, :user_id)";
  $statement = $dbConn->prepare($sql);
  bindAllValues($statement, $input);
  $statement->execute();
  $postId = $dbConn->lastInsertId();
  if ($postId)
    {
    $input['id'] = $postId;
    header("HTTP/1.1 200 OK");
    echo json_encode($input);
    exit();
    }
  }

//Borrar
if ($_SERVER['REQUEST_METHOD'] == 'DELETE')
  {
  $id = $_GET['id'];
  $statement = $dbConn->prepare("DELETE FROM anomalia where id_anomalia =:id");
  $statement->bindValue(':id', $id);
  $statement->execute();
  header("HTTP/1.1 200 OK");
  echo $id;
  exit();
  }

//Actualizar
if ($_SERVER['REQUEST_METHOD'] == 'PUT')
  {
  $input = $_GET;
  $postId = $input['id'];
  $fields = getParams($input);

  $sql = "
          UPDATE posts
          SET $fields
          WHERE id='$postId'
           ";

  $statement = $dbConn->prepare($sql);
  bindAllValues($statement, $input);

  $statement->execute();
  header("HTTP/1.1 200 OK");
  exit();
  }


//En caso de que ninguna de las opciones anteriores se haya ejecutado
header("HTTP/1.1 400 Bad Request");

?>