<?php

include "utils.php";

$dbConn = connect($db);

/*
listar todos los posts o solo uno
*/
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    if (isset($_GET['id_curso'])) {
        $sql = $dbConn->prepare("SELECT c.*, COALESCE(a.denominacion, 'Ninguna acción') AS nombre
        FROM cursos c
        LEFT JOIN acciones a ON a.numero_aaff = c.numero_aaff
        WHERE c.id_curso = :id_curso;
        ");
        $sql->bindValue(':id_curso', $_GET['id_curso']);
        $sql->execute();
        $curso = $sql->fetch(PDO::FETCH_ASSOC);


        //Mostrar un post
        $sql = $dbConn->prepare("SELECT c.*, COALESCE(a.denominacion, 'Ninguna acción') AS nombre,
        gc.estado AS estado_inscripcion
        FROM alumnos c
        INNER JOIN alumno_curso gc ON c.id_alumno = gc.id_alumno
        INNER JOIN cursos g ON gc.id_curso = g.id_curso
        LEFT JOIN acciones a ON a.numero_aaff = g.numero_aaff
        WHERE gc.id_curso = :id_curso;");
        $sql->bindValue(':id_curso', $_GET['id_curso']);
        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);

        $clientes = $sql->fetchAll(PDO::FETCH_OBJ);
        foreach ($clientes as $cliente) {
            $clientID = $cliente->id_alumno;
            $sql = "SELECT g.*, COALESCE(a.denominacion, 'Ninguna acción') AS nombre,
            gc.estado AS estado_inscripcion
            FROM cursos g
            INNER JOIN alumno_curso gc ON g.id_curso = gc.id_curso
            LEFT JOIN acciones a ON a.numero_aaff = g.numero_aaff
            WHERE gc.id_alumno = :id_alumno;
            ";
            $stmt = $dbConn->prepare($sql);
            $stmt->bindParam(':id_alumno', $clientID, PDO::PARAM_INT);
            $stmt->execute();
            // Obtener el resultado como un objeto
            $cursos = $stmt->fetchAll(PDO::FETCH_OBJ);
            $cliente->cursos = $cursos;
        }


        header("HTTP/1.1 200 OK");
        echo json_encode($clientes);
        exit();
    }
    if (isset($_GET['id_alumno_archivos'])) {
        $id_alumno = $_GET["id_alumno_archivos"];
        $images = glob('../alumnos/' . $id_alumno . '/archivos/*.{png,jpg,pdf}', GLOB_BRACE);
        $fileObjects = array();

        foreach ($images as $image) {
            $fileInfo = pathinfo($image);
            $fileObject = new stdClass(); // Crear un objeto vacío para almacenar los datos
            $fileObject->url = $image; // Almacenar la URL del archivo
            $fileObject->extension = $fileInfo['extension']; // Almacenar la extensión del archivo
            $fileObject->nombre = $fileInfo['basename']; // Almacenar la extensión del archivo

            $fileObjects[] = $fileObject; // Agregar el objeto al arreglo
        }
        header("HTTP/1.1 200 OK");
        echo json_encode($fileObjects);
        exit();
    }
    if (isset($_GET['id_alumno'])) {
        $id_alumno = $_GET['id_alumno'];
        $sql = $dbConn->prepare("SELECT * FROM alumnos where id_alumno=:id_alumno");
        $sql->bindValue(':id_alumno', $id_alumno);
        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        $alumno = $sql->fetch(PDO::FETCH_OBJ);
        $sql = "SELECT g.*, COALESCE(a.denominacion, 'Ninguna acción') AS nombre,
        gc.estado AS estado_inscripcion
        FROM cursos g
        INNER JOIN alumno_curso gc ON g.id_curso = gc.id_curso
        LEFT JOIN acciones a ON a.numero_aaff = g.numero_aaff
        WHERE gc.id_alumno = :id_alumno;";
        $stmt = $dbConn->prepare($sql);
        $stmt->bindParam(':id_alumno', $id_alumno, PDO::PARAM_INT);
        $stmt->execute();
        // Obtener el resultado como un objeto
        $cursos = $stmt->fetchAll(PDO::FETCH_OBJ);
        $alumno->cursos = $cursos;

        header("HTTP/1.1 200 OK");
        echo json_encode($alumno);
        exit();
    } if (isset($_GET['id_alumno_curso'])) {
        $id_alumno_curso = $_GET['id_alumno_curso'];
        $sql = $dbConn->prepare("SELECT * FROM alumno_curso where id_alumno_curso=:id_alumno_curso");
        $sql->bindValue(':id_alumno_curso', $id_alumno_curso);
        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        $alumno_curso = $sql->fetch(PDO::FETCH_OBJ);

        $id_alumno =  $alumno_curso->id_alumno;
        $id_curso =  $alumno_curso->id_curso;
        $sql = "SELECT g.*, COALESCE(a.denominacion, 'Ninguna acción') AS nombre
        FROM cursos g
      
        LEFT JOIN acciones a ON a.numero_aaff = g.numero_aaff
        WHERE g.id_curso = :id_curso;";
        $stmt = $dbConn->prepare($sql);
        $stmt->bindParam(':id_curso', $id_curso, PDO::PARAM_INT);
        $stmt->execute();
        // Obtener el resultado como un objeto
        $curso = $stmt->fetch(PDO::FETCH_OBJ);
        $alumno_curso->curso = $curso;

        $sql = "SELECT * FROM alumnos WHERE id_alumno = :id_alumno;";
        $stmt = $dbConn->prepare($sql);
        $stmt->bindParam(':id_alumno', $id_alumno, PDO::PARAM_INT);
        $stmt->execute();
        // Obtener el resultado como un objeto
        $alumno = $stmt->fetch(PDO::FETCH_OBJ);
        $alumno_curso->alumno = $alumno;

        header("HTTP/1.1 200 OK");
        echo json_encode($alumno_curso);
        exit();
    } else {
        //Mostrar lista de post
        $sql = $dbConn->prepare("SELECT * FROM alumnos");
        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        $clientes = $sql->fetchAll(PDO::FETCH_OBJ);
        foreach ($clientes as $cliente) {
            $clientID = $cliente->id_alumno;
            $sql = "SELECT g.*, COALESCE(a.denominacion, 'Ninguna acción') AS nombre,
            gc.estado AS estado_inscripcion, gc.id_alumno_curso AS id_alumno_curso
            FROM cursos g
            INNER JOIN alumno_curso gc ON g.id_curso = gc.id_curso
            LEFT JOIN acciones a ON a.numero_aaff = g.numero_aaff
            WHERE gc.id_alumno = :clientID";
            $stmt = $dbConn->prepare($sql);
            $stmt->bindParam(':clientID', $clientID, PDO::PARAM_INT);
            $stmt->execute();
            // Obtener el resultado como un objeto
            $cursos = $stmt->fetchAll(PDO::FETCH_OBJ);
            $cliente->cursos = $cursos;
        }

        header("HTTP/1.1 200 OK");
        // echo var_dump($sql->fetchAll());
        echo json_encode($clientes);

        exit();
    }
}

// Crear un nuevo post
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (
        isset($_POST["id_alumno_archivo"]) && isset($_FILES['archivo']) && isset($_POST['extension'])
        && isset($_POST['nombre'])
    ) {
        $nombre = $_POST["nombre"];
        $extension = $_POST["extension"];
        $id_alumno = $_POST["id_alumno_archivo"];
        $archivo = $_FILES['archivo'];
        $baseUrl = ($_SERVER['HTTPS'] ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/';
        $rutaArchivoTemporal = isset($_FILES['archivo']) ? $_FILES['archivo']['tmp_name'] : null;
        $Archivo = '../alumnos/' . $id_alumno . '/archivos/' . $nombre . '.' . $extension;
        if (file_exists($Archivo)) {

            header("HTTP/1.1 200 OK");
            echo 0;
            exit();
        } else {
            if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal)) {
                move_uploaded_file($rutaArchivoTemporal, $Archivo);
            }
            header("HTTP/1.1 200 OK");
            exit();
        }
    }
    if (
        isset($_POST["nif"])
        && isset($_POST["niss"])
        && isset($_POST["nombre"])
        && isset($_POST["apellidos"])
        && isset($_POST["fecha_nacimiento"])
        && isset($_POST["domicilio"])
        && isset($_POST["codigo_postal"])
        && isset($_POST["municipio"])
        && isset($_POST["discapacitado"])
        && isset($_POST["sexo"])
        && isset($_POST["estudios"])
        && isset($_POST["telefono"])
        && isset($_POST["email"])
        && isset($_POST["fecha_incorporacion"])
        && isset($_POST["iban"])
        && isset($_POST["colectivo"])
        && isset($_POST["categoria"])
        && isset($_POST["area_funcional"])
        && isset($_POST["entidad_trabajo_actual"])
        && isset($_POST["es_pyme"])
        && isset($_POST["sector_convenio"])
        && isset($_POST["razon_social"])
        && isset($_POST["cif_empresa"])
        && isset($_POST["num_inscripcion_seguridad_social"])
        && isset($_POST["datos_centro_trabajo"])
        && isset($_POST["domicilio_trabajo"])
        && isset($_POST["codigo_postal_trabajo"])
        && isset($_POST["municipio_trabajo"])
        && isset($_POST["situacion_laboral"])
        && isset($_POST["programa_prepara"])
        && isset($_POST["programa_activacion"])
        && isset($_POST["oficina_empleo"])
        && isset($_POST["fecha_demanda"])
    ) {

        foreach ($_POST as $key => $value) {
            $value = ($value == "true") ? 1 : $value;
            $value = ($value == "false") ? 0 : $value;
            $value = ($value === "") ? null : $value;
            $$key = $value;
        }

        $sqlVerificar = "SELECT COUNT(*) as count, id_alumno FROM alumnos WHERE nif = :nif";
        $statementVerificar = $dbConn->prepare($sqlVerificar);
        $statementVerificar->bindValue(':nif', $nif);

        $statementVerificar->execute();
        $resultadoVerificar = $statementVerificar->fetch(PDO::FETCH_ASSOC);



        if (isset($_POST["id_alumno"])) {
            $id_alumno = $_POST["id_alumno"];

            $sql = "UPDATE alumnos SET 
              nif = :nif,
              niss = :niss,
              nombre = :nombre,
              apellidos = :apellidos,
              fecha_nacimiento = :fecha_nacimiento,
              domicilio = :domicilio,
              codigo_postal = :codigo_postal,
              municipio = :municipio,
              discapacitado = :discapacitado,
              sexo = :sexo,
              estudios = :estudios,
              telefono = :telefono,
              email = :email,
              fecha_incorporacion = :fecha_incorporacion,
              iban = :iban,
              colectivo = :colectivo,
              categoria = :categoria,
              area_funcional = :area_funcional,
              entidad_trabajo_actual = :entidad_trabajo_actual,
              es_pyme = :es_pyme,
              sector_convenio = :sector_convenio,
              razon_social = :razon_social,
              cif_empresa = :cif_empresa,
              num_inscripcion_seguridad_social = :num_inscripcion_seguridad_social,
              datos_centro_trabajo = :datos_centro_trabajo,
              domicilio_trabajo = :domicilio_trabajo,
              codigo_postal_trabajo = :codigo_postal_trabajo,
              municipio_trabajo = :municipio_trabajo,
              situacion_laboral = :situacion_laboral,
              programa_prepara = :programa_prepara,
              programa_activacion = :programa_activacion,
              oficina_empleo = :oficina_empleo,
              fecha_demanda = :fecha_demanda
            WHERE id_alumno = :id_alumno";

            $statement = $dbConn->prepare($sql);
            $statement->bindValue(':id_alumno', $id_alumno);
        } else {
            if ($resultadoVerificar['count'] > 0) {
                // El nombre ya está en uso, mostrar mensaje de error

                $id_alumno = $resultadoVerificar['id_alumno'];
                $sql = "UPDATE alumnos SET 
              nif = :nif,
              niss = :niss,
              nombre = :nombre,
              apellidos = :apellidos,
              fecha_nacimiento = :fecha_nacimiento,
              domicilio = :domicilio,
              codigo_postal = :codigo_postal,
              municipio = :municipio,
              discapacitado = :discapacitado,
              sexo = :sexo,
              estudios = :estudios,
              telefono = :telefono,
              email = :email,
              fecha_incorporacion = :fecha_incorporacion,
              iban = :iban,
              colectivo = :colectivo,
              categoria = :categoria,
              area_funcional = :area_funcional,
              entidad_trabajo_actual = :entidad_trabajo_actual,
              es_pyme = :es_pyme,
              sector_convenio = :sector_convenio,
              razon_social = :razon_social,
              cif_empresa = :cif_empresa,
              num_inscripcion_seguridad_social = :num_inscripcion_seguridad_social,
              datos_centro_trabajo = :datos_centro_trabajo,
              domicilio_trabajo = :domicilio_trabajo,
              codigo_postal_trabajo = :codigo_postal_trabajo,
              municipio_trabajo = :municipio_trabajo,
              situacion_laboral = :situacion_laboral,
              programa_prepara = :programa_prepara,
              programa_activacion = :programa_activacion,
              oficina_empleo = :oficina_empleo,
              fecha_demanda = :fecha_demanda
            WHERE id_alumno = :id_alumno";

                $statement = $dbConn->prepare($sql);
                $statement->bindValue(':id_alumno', $id_alumno);
            } else {
                $sql = "INSERT INTO alumnos
                (nif, niss, nombre, apellidos, fecha_nacimiento, domicilio, codigo_postal, municipio, discapacitado,
                 sexo, estudios, telefono, email, fecha_incorporacion, iban,
                 colectivo, categoria, area_funcional, entidad_trabajo_actual, es_pyme, sector_convenio, razon_social,
                 cif_empresa, num_inscripcion_seguridad_social, datos_centro_trabajo, domicilio_trabajo, codigo_postal_trabajo,
                 municipio_trabajo, situacion_laboral, programa_prepara, programa_activacion, oficina_empleo, fecha_demanda)
                VALUES
                (:nif, :niss, :nombre, :apellidos, :fecha_nacimiento, :domicilio, :codigo_postal, :municipio, :discapacitado,
                 :sexo, :estudios, :telefono, :email, :fecha_incorporacion, :iban,
                 :colectivo, :categoria, :area_funcional, :entidad_trabajo_actual, :es_pyme, :sector_convenio, :razon_social,
                 :cif_empresa, :num_inscripcion_seguridad_social, :datos_centro_trabajo, :domicilio_trabajo, :codigo_postal_trabajo,
                 :municipio_trabajo, :situacion_laboral, :programa_prepara, :programa_activacion, :oficina_empleo, :fecha_demanda)";

                $statement = $dbConn->prepare($sql);
            }
        }

        $statement->bindValue(':nif', $nif);
        $statement->bindValue(':niss', $niss);
        $statement->bindValue(':nombre', $nombre);
        $statement->bindValue(':apellidos', $apellidos);
        $statement->bindValue(':fecha_nacimiento', $fecha_nacimiento);
        $statement->bindValue(':domicilio', $domicilio);
        $statement->bindValue(':codigo_postal', $codigo_postal);
        $statement->bindValue(':municipio', $municipio);
        $statement->bindValue(':discapacitado', $discapacitado);
        $statement->bindValue(':sexo', $sexo);
        $statement->bindValue(':estudios', $estudios);
        $statement->bindValue(':telefono', $telefono);
        $statement->bindValue(':email', $email);
        $statement->bindValue(':fecha_incorporacion', $fecha_incorporacion);
        $statement->bindValue(':iban', $iban);
        $statement->bindValue(':colectivo', $colectivo);
        $statement->bindValue(':categoria', $categoria);
        $statement->bindValue(':area_funcional', $area_funcional);
        $statement->bindValue(':entidad_trabajo_actual', $entidad_trabajo_actual);
        $statement->bindValue(':es_pyme', $es_pyme);
        $statement->bindValue(':sector_convenio', $sector_convenio);
        $statement->bindValue(':razon_social', $razon_social);
        $statement->bindValue(':cif_empresa', $cif_empresa);
        $statement->bindValue(':num_inscripcion_seguridad_social', $num_inscripcion_seguridad_social);
        $statement->bindValue(':datos_centro_trabajo', $datos_centro_trabajo);
        $statement->bindValue(':domicilio_trabajo', $domicilio_trabajo);
        $statement->bindValue(':codigo_postal_trabajo', $codigo_postal_trabajo);
        $statement->bindValue(':municipio_trabajo', $municipio_trabajo);
        $statement->bindValue(':situacion_laboral', $situacion_laboral);
        $statement->bindValue(':programa_prepara', $programa_prepara);
        $statement->bindValue(':programa_activacion', $programa_activacion);
        $statement->bindValue(':oficina_empleo', $oficina_empleo);
        $statement->bindValue(':fecha_demanda', $fecha_demanda);

        $statement->execute();

        if (isset($_POST["id_alumno"])) {
            $id_alumno = $_POST["id_alumno"];

            
        } else {
            if ($resultadoVerificar['count'] > 0) {
                // El nombre ya está en uso, mostrar mensaje de error

                $id_alumno = $resultadoVerificar['id_alumno'];
            } else {

                $id_alumno = $dbConn->lastInsertId();
                $carpetaNuevaAlumno = '../alumnos/' . $id_alumno;
                $carpetaArchivosAlumno = '../alumnos/' . $id_alumno . '/archivos';
                mkdir($carpetaNuevaAlumno, 0777, true);
                mkdir($carpetaArchivosAlumno, 0777, true);
            }
        }

        $input["id_alumno"] = $id_alumno;

        header("HTTP/1.1 200 OK");
        echo json_encode($input);
        exit();
    }

    if (isset($_POST["nif_agregar"]) 
    && isset($_POST["numero_grupo_agregar"]) 
    && isset($_POST["numero_aaff_agregar"])) {
        $nif= $_POST["nif_agregar"];
        $numero_grupo = $_POST["numero_grupo_agregar"];
        $numero_aaff = $_POST["numero_aaff_agregar"];
      

        $sql = "INSERT INTO alumno_curso (id_alumno, id_curso)
        SELECT a.id_alumno, c.id_curso
        FROM alumnos a
        JOIN cursos c ON c.numero_aaff = :numero_aaff AND c.numero_grupo = :numero_grupo
        WHERE a.nif = :nif
        LIMIT 1;";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':nif', $nif);
        $statement->bindValue(':numero_grupo', $numero_grupo);
        $statement->bindValue(':numero_aaff', $numero_aaff);
        $statement->execute();

        $postId = $dbConn->lastInsertId();

        $input['id'] = $postId;
       
        header("HTTP/1.1 200 OK");
        echo json_encode($input);
        exit();
    }


    if (
        isset($_POST["id_alumno_atributo"])
        && isset($_POST["valor"])
        && isset($_POST["atributo"])
    ) {
        $id_alumno_atributo = $_POST["id_alumno_atributo"];
        $valor = $_POST["valor"];
        $atributo = $_POST["atributo"];
        if ($valor === '') {
            $valor = null;
        }
        $sql = "UPDATE alumnos SET $atributo = :valor WHERE id_alumno = :id_alumno_atributo";
        $statement = $dbConn->prepare($sql);
        $statement->bindValue(':id_alumno_atributo', $id_alumno_atributo);
        $statement->bindValue(':valor', $valor);

        $statement->execute();

        $input["id"] = $id_alumno_atributo;
        $input["valor"] = $valor;
        $input["atributo"] = $atributo;

        header("HTTP/1.1 200 OK");
        echo json_encode($input);
        exit();
    }
}

//Borrar
if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {
    if (isset($_GET['id'])) {
        $id = $_GET['id'];
        $statement = $dbConn->prepare("DELETE FROM alumnos where id_alumno = :id");
        $statement->bindValue(':id', $id);
        $statement->execute();
        header("HTTP/1.1 200 OK");
        $carpetaEliminar = '../alumnos/' . $id;
        eliminarCarpeta($carpetaEliminar);
        exit();
    }
    if (isset($_GET['url'])) {
        $url = "." . $_GET['url'];
        header("HTTP/1.1 200 OK");
        unlink($url);
        exit();
    }
    if (isset($_GET["nif"])) {
        $nif = $_GET['nif'];
        $statement = $dbConn->prepare("DELETE FROM alumno_curso 
        WHERE id_alumno = (
            SELECT id_alumno
            FROM alumnos
            WHERE nif = :nif
            LIMIT 1
        );");
        $statement->bindValue(':nif', $nif);
        $statement->execute();
        header("HTTP/1.1 200 OK");
        exit();
    }
}

function eliminarCarpeta($rutaCarpeta)
{
    // Obtener una lista de archivos y subcarpetas dentro de la carpeta
    $archivos = glob($rutaCarpeta . '/*');

    // Eliminar cada archivo encontrado
    foreach ($archivos as $archivo) {
        if (is_file($archivo)) {
            unlink($archivo);
        } elseif (is_dir($archivo)) {
            eliminarCarpeta($archivo);
        }
    }

    // Eliminar la carpeta
    if (is_dir($rutaCarpeta)) {
        rmdir($rutaCarpeta);
    }
}

//En caso de que ninguna de las opciones anteriores se haya ejecutado
header("HTTP/1.1 400 Bad Request");