<?php

include "utils.php";

$dbConn = connect($db);

/*
listar todos los posts o solo uno
 */
if ($_SERVER['REQUEST_METHOD'] == 'GET')
    {
    if (isset($_GET['id_alergeno']))
        {
        //Mostrar un post
        $sql = $dbConn->prepare("SELECT * FROM alergenos where id_alergeno=:id_alergeno");
        $sql->bindValue(':id_alergeno', $_GET['id_alergeno']);
        $sql->execute();
        header("HTTP/1.1 200 OK");
        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));
        exit();
        }
    if (isset($_GET['id_curso_fotos']))
        {
        $id_curso = $_GET["id_curso_fotos"];
        $images = glob('../cursos/' . $id_curso . '/*.{png}', GLOB_BRACE);
        header("HTTP/1.1 200 OK");
        echo json_encode($images);
        exit();
        } else
        {
        //Mostrar lista de post
        $sql = $dbConn->prepare("SELECT * FROM alergenos");
        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        $clientes = $sql->fetchAll(PDO::FETCH_OBJ);
        foreach ($clientes as $cliente)
            {
            $clientID = $cliente->id_alergeno;
            $sql = "SELECT g.id_alumno
            FROM alumnos g
            INNER JOIN alergeno_alumno gc ON g.id_alumno = gc.id_alumno
            WHERE gc.id_alergeno = :clientID";
            $stmt = $dbConn->prepare($sql);
            $stmt->bindParam(':clientID', $clientID, PDO::PARAM_INT);
            $stmt->execute();
            // Obtener el resultado como un objeto
            $cursos = $stmt->fetchAll(PDO::FETCH_OBJ);
            $cliente->alumnos = $cursos;
            }

        header("HTTP/1.1 200 OK");
        // echo var_dump($sql->fetchAll());
        echo json_encode($clientes);

        exit();
        }
    }

// Crear un nuevo post
if ($_SERVER['REQUEST_METHOD'] == 'POST')
    {
    if (isset($_POST["nombre"]))
        {

        $nombre = $_POST["nombre"];
        $sqlVerificar = "SELECT COUNT(*) as count FROM alergenos WHERE nombre = :nombre";
        $statementVerificar = $dbConn->prepare($sqlVerificar);
        $statementVerificar->bindValue(':nombre', $nombre);
        $statementVerificar->execute();
        $resultadoVerificar = $statementVerificar->fetch(PDO::FETCH_ASSOC);

        if ($resultadoVerificar['count'] > 0 && !isset($_POST["id_alergeno"]))
            {
            // El nombre ya está en uso, mostrar mensaje de error

            echo 0;
            exit();
            } elseif ($resultadoVerificar['count'] > 0 && isset($_POST["id_alergeno"]) && $_POST["nombre_viejo"] != $_POST["nombre"])
            {

            echo 0;
            exit();
            }


        if (isset($_POST["id_alergeno"]))
            {
            $id_alergeno = $_POST["id_alergeno"];
            $codigo = ($_POST["codigo"] != "0") ? $_POST["codigo"] : null;
            $baseUrl = ($_SERVER['HTTPS'] ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/';
            $rutaArchivoTemporal = isset($_FILES['icono']) ? $_FILES['icono']['tmp_name'] : null;
            $caracteres = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
            $longitud = 10;
            $cadenaAleatoria = substr(str_shuffle($caracteres), 0, $longitud);
            $Archivo = '../assets/images/alergenos/' . $cadenaAleatoria . '.svg';

            if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal))
                {
                if ($codigo != null)
                    {
                    $ArchivoEliminar = '../assets/images/alergenos/' . $codigo . '.svg';
                    unlink($ArchivoEliminar);
                    }
                move_uploaded_file($rutaArchivoTemporal, $Archivo);
                } else
                {
                if ($codigo != null)
                    {
                    $cadenaAleatoria = $codigo;
                    } else
                    {
                    $cadenaAleatoria = null;
                    }

                }


            $sql = "UPDATE alergenos SET 
            nombre = :nombre,
            icono = :icono
            WHERE id_alergeno = :id_alergeno";
            $statement = $dbConn->prepare($sql);
            $statement->bindValue(':id_alergeno', $id_alergeno);

            } else
            {
            $baseUrl = ($_SERVER['HTTPS'] ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/';
            $rutaArchivoTemporal = isset($_FILES['icono']) ? $_FILES['icono']['tmp_name'] : null;
            $caracteres = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
            $longitud = 10;
            $cadenaAleatoria = substr(str_shuffle($caracteres), 0, $longitud);
            $Archivo = '../assets/images/alergenos/' . $cadenaAleatoria . '.svg';

            if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal))
                {

                move_uploaded_file($rutaArchivoTemporal, $Archivo);
                } else
                {
                $cadenaAleatoria = null;
                }

            $sql = "INSERT INTO alergenos
                (nombre,icono)
                VALUES
                (:nombre,:icono)";
            $statement = $dbConn->prepare($sql);
            }




        $statement->bindValue(':icono', $cadenaAleatoria);
        $statement->bindValue(':nombre', $nombre);
        $statement->execute();
        if (isset($_POST["id_alergeno"]))
            {
            $postId = $_POST["id_alergeno"];

            } else
            {
            $postId = $dbConn->lastInsertId();
            }

        $input['id'] = $postId;
        $input['nombre'] = $nombre;
        $input['icono'] = $Archivo;
        header("HTTP/1.1 200 OK");
        echo json_encode($input);
        exit();

        }
    if (isset($_POST["id_alergeno_marcar"]) && isset($_POST["id_alumno_marcar"]) && isset($_POST["checked"]))
        {
        $id_alergeno = $_POST["id_alergeno_marcar"];
        $id_alumno = $_POST["id_alumno_marcar"];
        $checked = $_POST["checked"];

        if ($checked != 'true')
            {
            $statement = $dbConn->prepare("DELETE FROM alergeno_alumno where id_alergeno =:id_alergeno AND id_alumno = :id_alumno");
            $statement->bindValue(':id_alergeno', $id_alergeno);
            $statement->bindValue(':id_alumno', $id_alumno);
            $statement->execute();
            } else
            {

            $sql = "INSERT INTO alergeno_alumno
        (id_alergeno,id_alumno)
        VALUES
        (:id_alergeno,:id_alumno)";

            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':id_alumno', $id_alumno);
            $statement->bindValue(':id_alergeno', $id_alergeno);
            $statement->execute();
            }



        $input['id_alergeno'] = $id_alergeno;
        $input['id_alumno'] = $id_alumno;
        header("HTTP/1.1 200 OK");
        echo json_encode($input);
        exit();

        }
    if (isset($_POST["id_curso_foto"]) && isset($_FILES['foto']))
        {
        $id_curso = $_POST["id_curso_foto"];
        $foto = $_FILES['foto'];
        $baseUrl = ($_SERVER['HTTPS'] ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/';
        $rutaArchivoTemporal = isset($_FILES['foto']) ? $_FILES['foto']['tmp_name'] : null;
        $caracteres = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $longitud = 10;
        $cadenaAleatoria = substr(str_shuffle($caracteres), 0, $longitud);

        $Archivo = '../cursos/' . $id_curso . '/' . $cadenaAleatoria . '.png';

        if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal))
            {

            move_uploaded_file($rutaArchivoTemporal, $Archivo);
            }
        header("HTTP/1.1 200 OK");
        exit();
        }


    }

if ($_SERVER['REQUEST_METHOD'] == 'DELETE')
    {
    if (isset($_GET["id_curso"]))
        {
        $id = $_GET['id_curso'];
        $statement = $dbConn->prepare("DELETE FROM alumno_curso where id_curso =:id");
        $statement->bindValue(':id', $id);
        $statement->execute();
        header("HTTP/1.1 200 OK");
        exit();
        }

    if (isset($_GET["url"]))
        {
        $url = $_GET['url'];
        $carpetaEliminar = '.' . $url;

        header("HTTP/1.1 200 OK");
        unlink($carpetaEliminar);
        echo $carpetaEliminar;
        exit();
        }
    if (isset($_GET["id"]) && isset($_GET["codigo"]))
        {
        $id = $_GET['id'];
        $codigo = $_GET['codigo'];
        $statement = $dbConn->prepare("DELETE FROM alergenos where id_alergeno =:id");
        $statement->bindValue(':id', $id);
        $statement->execute();

        if ($codigo != "0")
            {
            $carpetaEliminar = '../assets/images/alergenos/' . $codigo . '.svg';
            unlink($carpetaEliminar);
            }
        header("HTTP/1.1 200 OK");
        exit();
        }
    }


function eliminarCarpeta($rutaCarpeta)
    {
    // Obtener una lista de archivos y subcarpetas dentro de la carpeta
    $archivos = glob($rutaCarpeta . '/*');

    // Eliminar cada archivo encontrado
    foreach ($archivos as $archivo)
        {
        if (is_file($archivo))
            {
            unlink($archivo);
            } elseif (is_dir($archivo))
            {
            eliminarCarpeta($archivo);
            }
        }

    // Eliminar la carpeta
    if (is_dir($rutaCarpeta))
        {
        rmdir($rutaCarpeta);

        }
    }

//En caso de que ninguna de las opciones anteriores se haya ejecutado
header("HTTP/1.1 400 Bad Request");