<?php



include "utils.php";



$dbConn = connect($db);



/*

listar todos los posts o solo uno

*/
$personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);
if ($_SERVER['REQUEST_METHOD'] == 'GET') {



    if (isset($_GET['id_albaran'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM albaranes where id_albaran=:id_albaran");

        $sql->bindValue(':id_albaran', $_GET['id_albaran']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();

    }

    elseif (isset($_GET['dias'])) {



        $dias = json_decode($_GET['dias']);

        $recursos = array();



        foreach ($dias as $fecha_formato) {



            $sql = "SELECT COUNT(*) as cantidad  FROM albaranes WHERE DATE(fecha) = :fecha AND estado = 'Pendiente'";

            // Preparar la consulta SQL utilizando PDO

            $stmt = $dbConn->prepare($sql);

            $stmt->bindValue(':fecha', $fecha_formato, PDO::PARAM_STR);

            $stmt->execute();

            $row = $stmt->fetch(PDO::FETCH_ASSOC);

            $cantidad_pendientes = $row['cantidad'];

            $sql = "SELECT COUNT(*) as cantidad  FROM albaranes WHERE DATE(fecha) = :fecha AND estado = 'Aceptado'";

            // Preparar la consulta SQL utilizando PDO

            $stmt = $dbConn->prepare($sql);

            $stmt->bindValue(':fecha', $fecha_formato, PDO::PARAM_STR);

            $stmt->execute();

            $row = $stmt->fetch(PDO::FETCH_ASSOC);

            $cantidad_aceptados = $row['cantidad'];

            $sql = "SELECT COUNT(*) as cantidad  FROM albaranes WHERE DATE(fecha) = :fecha AND estado = 'Rechazado'";

            // Preparar la consulta SQL utilizando PDO

            $stmt = $dbConn->prepare($sql);

            $stmt->bindValue(':fecha', $fecha_formato, PDO::PARAM_STR);

            $stmt->execute();

            $row = $stmt->fetch(PDO::FETCH_ASSOC);

            $cantidad_rechazados = $row['cantidad'];



            // Crear un objeto con la fecha y la cantidad de facturas y agregarlo al arreglo $facturas_por_dia

            $objeto = array("dia" => $fecha_formato, "cantidad_pendientes" => $cantidad_pendientes, "cantidad_aceptados" => $cantidad_aceptados, "cantidad_rechazados" => $cantidad_rechazados);

            array_push($recursos, $objeto);

        }

        // Devolver los resultados en formato JSON

        header('Content-Type: application/json');

        echo json_encode($recursos);

        exit();

    }

    elseif (isset($_GET['programados'])) {



        $sql = "SELECT p.*, c.nombre

            FROM albaranes p 

            JOIN clientes c ON p.id_cliente = c.client_id

            WHERE p.programado IS NOT NULL;";

        $stmt = $dbConn->prepare($sql);



        // Obtener clientes potenciales





        $stmt->execute();

        $albaranes = $stmt->fetchAll(PDO::FETCH_OBJ);



        // Devolver objeto de clientes

        header("HTTP/1.1 200 OK");

        echo json_encode($albaranes);

        exit();

    }

    elseif (isset($_GET['fecha_i']) && isset($_GET['fecha_i'])) {

        $fecha_i = $_GET['fecha_i'];

        $fecha_f = $_GET['fecha_f'];

        $sql = "SELECT p.*, c.nombre

            FROM albaranes p 

            JOIN clientes c ON p.id_cliente = c.client_id

            WHERE DATE_FORMAT(p.fecha, '%Y-%m-%d') BETWEEN :fecha_i AND :fecha_f";

        $stmt = $dbConn->prepare($sql);



        // Obtener clientes potenciales





        $stmt->bindParam(':fecha_i', $fecha_i);

        $stmt->bindParam(':fecha_f', $fecha_f);

        $stmt->execute();

        $albaranes = $stmt->fetchAll(PDO::FETCH_OBJ);



        // Devolver objeto de clientes

        header("HTTP/1.1 200 OK");

        echo json_encode($albaranes);

        exit();

    }

    elseif (isset($_GET['client_id'])) {

        $sql = $dbConn->prepare("SELECT p.*, c.nombre, COALESCE(o.nombre, 'Ninguna obra') AS nombre_obra, COALESCE(s.nombre, 'Ningun sector') AS nombre_sector, COALESCE(f.nombre, 'Ninguna fase') AS nombre_fase

            FROM albaranes p 

     JOIN clientes c ON p.id_cliente = c.client_id

     LEFT JOIN obras o ON o.id_obra = p.id_obra

     LEFT JOIN sectores s ON s.id_sector = p.id_sector

     LEFT JOIN fases f ON f.id_fase = p.id_fase

     WHERE p.id_cliente = :client_id");

        $sql->bindValue(':client_id', $_GET['client_id']);

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");



        echo json_encode($sql->fetchAll());

        exit();

    }elseif (isset($_GET['crear_factura'])) {

        $sql = $dbConn->prepare("SELECT 

                c.*, 

                x.cif, 

                x.email,

                z.numero,

             

                CASE 

                    WHEN c.id_cliente IS NULL THEN 'Ningún cliente seleccionado'

                    ELSE x.nombre 

                END AS nombre_cliente

        FROM albaranes c 

       

        LEFT JOIN clientes x ON c.id_cliente = x.client_id

        LEFT JOIN factura_manual z ON c.invoice_id = z.id_factura_manual

        WHERE c.invoice_id IS NULL");

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetchAll(PDO::FETCH_ASSOC));

        exit();
    }

    
    else {

        //Mostrar lista de post

        $sql = $dbConn->prepare("SELECT 
        p.*,
        c.nombre,
        COALESCE(o.nombre, 'Ninguna obra') AS nombre_obra,
         COALESCE(s.nombre, 'Ningun sector') AS nombre_sector,
          COALESCE(f.nombre, 'Ninguna fase') AS nombre_fase,
      
          COALESCE(z.numero, 'Ninguna factura asociada') AS numero_factura

       FROM albaranes p 

JOIN clientes c ON p.id_cliente = c.client_id

LEFT JOIN obras o ON o.id_obra = p.id_obra

LEFT JOIN sectores s ON s.id_sector = p.id_sector
  LEFT JOIN factura_manual z ON p.invoice_id = z.id_factura_manual
LEFT JOIN fases f ON f.id_fase = p.id_fase");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");



        echo json_encode($sql->fetchAll());

        exit();

    }

}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_GET['crear_factura'])) {

        $output = array();

        $output['status'] = false;

        $razon_social = $_POST['data']['razon_social'];

        if (is_null($razon_social) || empty($razon_social)) {

            $output['msg'] = 'Debe proporcionar una razón social válida';

            echo json_encode($output);

            exit;
        }



        $cif = $_POST['data']['cif'];

        if (is_null($cif) || empty($cif)) {

            $output['msg'] = 'Debe proporcionar un CIF/NIF válido';

            echo json_encode($output);

            exit;
        }



        $email = $_POST['data']['email'];

        if (is_null($email) || empty($email)) {

            $output['msg'] = 'Debe proporcionar un email válido';

            echo json_encode($output);

            exit;
        }



        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {

            $output['msg'] = 'Formato de email no válido';

            echo json_encode($output);

            exit;
        }



        $email = $_POST['data']['email'];

        if (is_null($email) || empty($email)) {

            $output['msg'] = 'Debe proporcionar un email válido';

            echo json_encode($output);

            exit;
        }



        $numero = $_POST['data']['numero'];

        if (is_null($numero) || empty($numero)) {

            $output['msg'] = 'Debe proporcionar un número de factura válida';

            echo json_encode($output);

            exit;
        }



        $direccion = $_POST['data']['direccion'];

        if (is_null($direccion) || empty($direccion)) {

            $output['msg'] = 'Debe proporcionar una dirección válida';

            echo json_encode($output);

            exit;
        }



        $titulo = $_POST['data']['titulo'];

        if (is_null($titulo) || empty($titulo)) {

            $output['msg'] = 'Debe proporcionar una dirección válida';

            echo json_encode($output);

            exit;
        }



        $telefono = $_POST['data']['telefono'];

        if (is_null($telefono) || empty($telefono)) {

            $output['msg'] = 'Debe proporcionar un teléfono válido';

            echo json_encode($output);

            exit;
        }



        $cp = $_POST['data']['cp'];

        if (is_null($cp) || empty($cp)) {

            $output['msg'] = 'Debe proporcionar un código postal válido';

            echo json_encode($output);

            exit;
        }
        $id_cliente = $_POST['data']['client_id'];
        if (is_null($id_cliente) || empty($id_cliente) || $id_cliente == "No") {

            $output['msg'] = 'Debe seleccionar un cliente';

            echo json_encode($output);

            exit;
        }

        if (count($_POST['data']['tickets']) == 0) {

            $output['msg'] = 'Debe seleccionar al menos un albarán';

            echo json_encode($output);

            exit;
        }



        $tickets_ids_txt = '';

        foreach ($_POST['data']['tickets'] as $key => $value) {

            $tickets_ids_txt .= $value . ',';
        }



        $tickets_ids_txt = substr($tickets_ids_txt, 0, -1);



        $sql = $dbConn->prepare("SELECT * FROM albaranes WHERE id_albaran IN(" . $tickets_ids_txt . ")");

        $sql->execute();

        $tickets_row = $sql->fetchAll(PDO::FETCH_ASSOC);



        $subtotal = 0.00;

        $impuestos = 0.00;

        $total = 0.00;

        $id_cliente = '';

        $igic_per = 0;

        foreach ($tickets_row as $key => $value) {

            

            $subtotal += $value['importe'];
        

            $total += $value['importe_final'];

          
        }



        

        
        



        $sql = "INSERT INTO factura_manual 

        (numero, fecha, direccion, importe, estado, email, imagen, nombre, cif, cp, telefono, client_id, titulo, tipo, impuesto, clase)

        VALUES

        (:numero, :fecha, :direccion, :importe, :estado, :email, :imagen, :nombre, :cif, :cp, :telefono, :client_id, :titulo, :tipo, :impuesto, :clase)";



        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':numero', $numero);

        $statement->bindValue(':fecha', date('Y-m-d'));

        $statement->bindValue(':direccion', $direccion);

        $statement->bindValue(':importe', $subtotal);

        $statement->bindValue(':estado', 'Pendiente');

        $statement->bindValue(':email', $email);

        $statement->bindValue(':imagen', htmlentities($personalizacion['url_logo_superior'], ENT_QUOTES));

        $statement->bindValue(':nombre', $razon_social);

        $statement->bindValue(':cif', $cif);

        $statement->bindValue(':cp', $cp);

        $statement->bindValue(':telefono', $telefono);

        $statement->bindValue(':client_id', $_POST['data']['client_id']);

        $statement->bindValue(':titulo', $titulo);

        $statement->bindValue(':tipo', 'Particular');

        $statement->bindValue(':impuesto', NULL);
        $statement->bindValue(':clase', "Albaranes");
        $statement->execute();



        $postId = $dbConn->lastInsertId();



 $personalizacion["numeracion_facturas"] = intval($personalizacion["numeracion_facturas"]) + 1;
 $new_json_data = json_encode($personalizacion, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
        if (file_put_contents($file_path, $new_json_data)) {

            $output = ['status' => true, 'message' => 'Actualización exitosa'];

        } else {

            $output = ['status' => false, 'message' => 'Error al escribir en el archivo JSON'];

        }

      


        $sql = "UPDATE albaranes SET invoice_id = :invoice_id WHERE id_albaran IN(" . $tickets_ids_txt . ")";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':invoice_id', $postId);



        $statement->execute();



        foreach ($tickets_row as $key => $value) {

            /**

             * Insertar lineas de la factura

             */

            $sql = "INSERT INTO apartado_factura_manual 

            (cantidad, titulo, descripcion, precio_unitario,id_factura_manual, codigo, igic)

            VALUES

            (:cantidad, :titulo, :descripcion, :precio_unitario, :id_factura_manual, :codigo, :igic)";



            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':cantidad', '1');

            $statement->bindValue(':titulo', 'Albarán nº ' . $value['numero']);

            $statement->bindValue(':descripcion', '');

            $statement->bindValue(':precio_unitario', $value['importe']);

            $statement->bindValue(':id_factura_manual', $postId);

            $statement->bindValue(':codigo', $value['id_albaran']);

            $statement->bindValue(':igic', (($value['importe_final'] - $value['importe']) / $value['importe']) * 100);

            $statement->execute();
        }



        $output['msg'] = 'Factura creada correctamente';

        $output['status'] = true;

        echo json_encode($output);

        exit;
    }
    elseif (isset($_POST["programado"]) && isset($_POST["id_albaran_editar_envio"])) {



        $programado = ($_POST["programado"] != "No") ? $_POST["programado"] : null;

        $id_albaran = $_POST["id_albaran_editar_envio"];



        $sql = "UPDATE albaranes SET programado = :programado WHERE id_albaran = :id_albaran";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':id_albaran', $id_albaran);

        $statement->bindValue(':programado', $programado);



        $statement->execute();

        $object = [

            'id' => $id_albaran,

            'programado' => $programado,



        ];



        header("HTTP/1.1 200 OK");

        echo json_encode($object);

        exit();

    }



    elseif (isset($_POST["aceptado"]) && isset($_POST["id_albaran"])) {



        $aceptado = $_POST["aceptado"];

        $id_albaran = $_POST["id_albaran"];



        $sql = "UPDATE albaranes SET estado = :aceptado WHERE id_albaran = :id_albaran";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':id_albaran', $id_albaran);

        $statement->bindValue(':aceptado', $aceptado);



        $statement->execute();

        $object = [

            'id' => $id_albaran,

            'aceptado' => $aceptado,



        ];



        header("HTTP/1.1 200 OK");

        echo "Presupuesto " . $aceptado;

        exit();

    }



    elseif (

        isset($_POST["estado"])

        && isset($_POST["fecha"])

        && isset($_POST["cif"])

        && isset($_POST["cp"])

        && isset($_POST["domicilio"])

        && isset($_POST["telefono"])

        && isset($_POST["email"])

        && isset($_POST["tipo"])

        && isset($_POST["id_usuario"])

        && isset($_POST["id_obra"])

        && isset($_POST["id_sector"])

        && isset($_POST["id_fase"])

        && isset($_POST["importe_final"])

        && isset($_POST["importe"])

        && isset($_POST["detallado"])

        && isset($_POST["titulo"])

        && isset($_POST["id_cliente"])

        && isset($_POST["condiciones"])

        && isset($_POST["numero"])



        && isset($_POST["irpf"])

        && isset($_POST["nota_interna"])

        && isset($_POST["nota_externa"])

        && isset($_POST["programado"])

        && isset($_POST["imagen"])

        && isset($_POST["lugar"])

        && isset($_POST["fechas"])

        && isset($_POST["id_albaran"])

    ) {



        try {

            $imagen = $_POST["imagen"];

            $nota_interna = $_POST["nota_interna"];

            $nota_externa = $_POST["nota_externa"];

            $estado = $_POST["estado"];

            $fecha = $_POST["fecha"];

            $cif = $_POST["cif"];

            $cp = $_POST["cp"];

            $domicilio = $_POST["domicilio"];

            $telefono = $_POST["telefono"];

            $email = $_POST["email"];

            $tipo = $_POST["tipo"];

            $id_usuario = $_POST["id_usuario"];

            $id_obra = $_POST["id_obra"];

            $id_sector = $_POST["id_sector"];

            $id_fase = $_POST["id_fase"];

            $importe_final = $_POST["importe_final"];

            $importe = $_POST["importe"];

            $detallado = $_POST["detallado"];

            $titulo = $_POST["titulo"];

            $id_cliente = $_POST["id_cliente"];

            $condiciones = $_POST["condiciones"];

            $numero = $_POST["numero"];



            $irpf = $_POST["irpf"];



            $programado = $_POST["programado"];

            foreach ($_POST as $key => $value) {

                $value = ($value == "null") ? null : $value;

                $value = ($value == "") ? null : $value;

                $value = ($value == "No") ? null : $value;

                $$key = $value;

            }



            if ($id_albaran != null) {





                $sql = "UPDATE albaranes SET 

            estado = :estado

            ,fecha = :fecha

            ,cif = :cif

            ,cp = :cp

            ,domicilio = :domicilio

            ,telefono = :telefono

            ,email = :email

            ,tipo = :tipo

            ,id_usuario = :id_usuario

            ,id_obra = :id_obra

            ,id_sector = :id_sector

            ,id_fase = :id_fase

            ,importe_final = :importe_final

            ,importe = :importe

            ,detallado = :detallado

            ,titulo = :titulo

            ,id_cliente = :id_cliente

            ,condiciones = :condiciones

            ,numero = :numero

           

            ,irpf = :irpf

            

            ,nota_interna = :nota_interna

            ,nota_externa = :nota_externa

            ,imagen = :imagen

             ,programado = :programado

             ,lugar = :lugar

             ,fechas = :fechas

            

             WHERE id_albaran = :id_albaran";

                $statement = $dbConn->prepare($sql);

                $statement->bindValue(':id_albaran', $id_albaran);

            } else {



                $sql = "INSERT INTO albaranes

        (estado

        ,fecha

         ,lugar

         ,fechas

        ,cif

        ,cp

        ,domicilio

        ,telefono

        ,email

        ,tipo

        ,id_usuario

        ,id_obra

        ,id_sector

        ,id_fase

        ,importe_final

        ,importe

        ,detallado

        ,titulo

        ,id_cliente

        ,condiciones

        ,numero

       

        ,irpf

       

        ,nota_interna

        ,nota_externa

        ,imagen

         ,programado

        )

        VALUES

        (:estado

        ,:fecha

        ,:lugar

         ,:fechas

        ,:cif

        ,:cp

        ,:domicilio

        ,:telefono

        ,:email

        ,:tipo

        ,:id_usuario

        ,:id_obra

        ,:id_sector

        ,:id_fase

        ,:importe_final

        ,:importe

        ,:detallado

        ,:titulo

        ,:id_cliente

        ,:condiciones

        ,:numero

        

        ,:irpf

       

        ,:nota_interna

        ,:nota_externa

        ,:imagen

        ,:programado

        )";
$estado = "Aceptado";
                $statement = $dbConn->prepare($sql);

            }

            $statement->bindValue(':lugar', $lugar);

            $statement->bindValue(':fechas', $fechas);

            $statement->bindValue(':imagen', $imagen);

            $statement->bindValue(':programado', $programado);

            $statement->bindValue(':estado', $estado);

            $statement->bindValue(':fecha', $fecha);

            $statement->bindValue(':cif', $cif);

            $statement->bindValue(':cp', $cp);

            $statement->bindValue(':domicilio', $domicilio);

            $statement->bindValue(':telefono', $telefono);

            $statement->bindValue(':email', $email);

            $statement->bindValue(':tipo', $tipo);

            $statement->bindValue(':id_usuario', $id_usuario);

            $statement->bindValue(':id_obra', $id_obra);

            $statement->bindValue(':id_sector', $id_sector);

            $statement->bindValue(':id_fase', $id_fase);

            $statement->bindValue(':importe_final', $importe_final);

            $statement->bindValue(':importe', $importe);

            $statement->bindValue(':detallado', $detallado);

            $statement->bindValue(':titulo', $titulo);

            $statement->bindValue(':id_cliente', $id_cliente);

            $statement->bindValue(':condiciones', $condiciones);

            $statement->bindValue(':numero', $numero);



            $statement->bindValue(':irpf', $irpf);



            $statement->bindValue(':nota_interna', $nota_interna);

            $statement->bindValue(':nota_externa', $nota_externa);

            $statement->execute();

            if ($id_albaran == null) {

                $id_albaran = $dbConn->lastInsertId();

                $personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);

                $personalizacion["numeracion_albaranes"] = intval($personalizacion["numeracion_albaranes"]) + 1;

                $personalizacionEncoded = json_encode($personalizacion, JSON_PRETTY_PRINT);

                file_put_contents('../personalizacion.json', $personalizacionEncoded);

            }



            header("HTTP/1.1 200 OK");

            echo json_encode($id_albaran);

            exit();

        } catch (PDOException $e) {

            // Manejar el error

            header("HTTP/1.1 500 Internal Server Error");

            echo "Error al ejecutar la consulta: " . $e->getMessage();

            exit();

        }

    }



}



//Borrar

if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    $id = $_GET['id'];

    $statement = $dbConn->prepare("DELETE FROM albaranes where id_albaran =:id");

    $statement->bindValue(':id', $id);

    $statement->execute();

    $statement = $dbConn->prepare("SELECT COUNT(*) AS cantidad_albaranes

    FROM albaranes");



    $statement->execute();



    header("HTTP/1.1 200 OK");

    echo json_encode($statement->fetch(PDO::FETCH_ASSOC));

    exit();

}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

}



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");