<?php

include "utils.php";

$dbConn = connect($db);

/*
listar todos los posts o solo uno
 */
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    if (isset($_GET['id_metodo'])) {
        //Mostrar un post
        $sql = $dbConn->prepare("SELECT * FROM metodos_pago where id_metodo=:id_metodo");
        $sql->bindValue(':id_metodo', $_GET['id_metodo']);
        $sql->execute();
        header("HTTP/1.1 200 OK");
        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));
        exit();
    } else {
        //Mostrar lista de post
        $sql = $dbConn->prepare("SELECT a.*, u.user_full_name
        FROM actividad a
        JOIN users u ON a.user_id = u.user_id;
        ");
        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetchAll());
        exit();
    }
}

// Crear un nuevo post
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST["actividades"])) {

        $actividades = $_POST["actividades"];
        foreach ($actividades as $a) {
            $user_id = $a["user_id"];
            $fecha = $a["fecha"];
            $ip = $a["ip"];
            $actividad = $a["actividad"];
            $sql = "INSERT INTO actividad (user_id,fecha,ip,actividad) VALUES (:user_id,:fecha,:ip,:actividad)";
            $statement = $dbConn->prepare($sql);
            $statement->bindValue(':user_id', $user_id);
            $statement->bindValue(':fecha', $fecha);
            $statement->bindValue(':ip', $ip);
            $statement->bindValue(':actividad', $actividad);
            $statement->execute();
        }
        header("HTTP/1.1 200 OK");
        echo "Actividades agegadas.";
        exit();
    }
}

//Borrar
if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {
    $id_actividad_eliminar = $_GET['id_actividad_eliminar'];
    $statement = $dbConn->prepare("DELETE FROM actividad where id_actividad=:id_actividad_eliminar");
    $statement->bindValue(':id_actividad_eliminar', $id_actividad_eliminar);
    $statement->execute();
    header("HTTP/1.1 200 OK");
    exit();
}

//Actualizar
if ($_SERVER['REQUEST_METHOD'] == 'PUT') {
    $input = $_GET;
    $postId = $input['id'];
    $fields = getParams($input);

    $sql = "
          UPDATE posts
          SET $fields
          WHERE id='$postId'
           ";

    $statement = $dbConn->prepare($sql);
    bindAllValues($statement, $input);

    $statement->execute();
    header("HTTP/1.1 200 OK");
    exit();
}

//En caso de que ninguna de las opciones anteriores se haya ejecutado
header("HTTP/1.1 400 Bad Request");