<?php

include "../core/configuration.php";

class TableData
{
    private $_db;

    public function __construct()
    {
        try {
            $host = DB_SERVER;
            $database = DB_NAME;
            $user = DB_USERNAME;
            $passwd = DB_PASSWORD;

            $this->_db = new PDO(
                'mysql:host=' . $host . ';dbname=' . $database,
                $user,
                $passwd,
                array(
                    PDO::ATTR_PERSISTENT => true,
                    PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES utf8'
                )
            );
        } catch (PDOException $e) {
            error_log("Failed to connect to database: " . $e->getMessage());
        }
    }

    public function get($table, $index_column, $columns)
    {
        // Paging
        $sLimit = "";
        if (isset($_GET['start']) && $_GET['length'] != '-1') {
            $sLimit = "LIMIT " . intval($_GET['start']) . ", " . intval($_GET['length']);
        }

        // Ordering
        $sOrder = "";
        if (isset($_GET['order'])) {
            $sOrder = "ORDER BY  ";
            foreach ($_GET['order'] as $order) {
                $columnIdx = intval($order['column']);
                $sortDir = (strcasecmp($order['dir'], 'ASC') == 0) ? 'ASC' : 'DESC';
                $sOrder .= "`" . $columns[$columnIdx] . "` " . $sortDir . ", ";
            }
            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == "ORDER BY") {
                $sOrder = "";
            }
        }

        // Filtering
        $sWhere = "";
        $params = [];

        if (isset($_GET['search']['value']) && $_GET['search']['value'] != "") {
            $sWhere = "WHERE (";
            foreach ($columns as $i => $column) {
                if ($_GET['columns'][$i]['searchable'] == "true") {
                    $sWhere .= "`" . $column . "` LIKE :search OR ";
                }
            }
            $sWhere = substr_replace($sWhere, "", -3);
            $sWhere .= ')';
        }

        foreach ($columns as $i => $column) {
            if (isset($_GET['columns'][$i]) && isset($_GET['columns'][$i]['searchable']) && $_GET['columns'][$i]['searchable'] == "true") {
                if (!empty($_GET['columns'][$i]['search']['value'])) {
                    $sWhere .= ($sWhere == "" ? "WHERE " : " AND ");
                    $sWhere .= "`" . $column . "` LIKE :search" . $i . " ";
                    $params[':search' . $i] = '%' . $_GET['columns'][$i]['search']['value'] . '%';
                }
            }
        }
        

        // Filtering by id_grupo
        if (isset($_GET['id_grupo']) && $_GET['id_grupo'] != "No") {
            if ($sWhere == "") {
                $sWhere = "WHERE ";
            } else {
                $sWhere .= " AND ";
            }
            $sWhere .= "`client_id` IN (SELECT `client_id` FROM `grupo_cliente` WHERE `id_grupo` = :id_grupo) ";
            $params[':id_grupo'] = $_GET['id_grupo'];
        }

        if (isset($_GET['activo']) && $_GET['activo'] != "Todos") {
            if ($sWhere == "") {
                $sWhere = "WHERE ";
            } else {
                $sWhere .= " AND ";
            }
            $sWhere .= "`activo` = :activo ";
            $params[':activo'] = $_GET['activo'];
        }
        if (isset($_GET['terminos']) && $_GET['terminos'] != "No") {
            if ($sWhere == "") {
                $sWhere = "WHERE ";
            } else {
                $sWhere .= " AND ";
            }
            $sWhere .= "`terminos` = :terminos ";
            $params[':terminos'] = $_GET['terminos'];
        }
        if (isset($_GET['sexo']) && $_GET['sexo'] != "Todos") {
            if ($sWhere == "") {
                $sWhere = "WHERE ";
            } else {
                $sWhere .= " AND ";
            }
            $sWhere .= "`sexo` = :sexo ";
            $params[':sexo'] = $_GET['sexo'];
        }
        if (isset($_GET['id_poblacion']) && $_GET['id_poblacion'] != "No") {
            if ($sWhere == "") {
                $sWhere = "WHERE ";
            } else {
                $sWhere .= " AND ";
            }
            $sWhere .= "`id_poblacion` = :id_poblacion ";
            $params[':id_poblacion'] = $_GET['id_poblacion'];
        }
        if (isset($_GET['email']) && $_GET['email'] == "1") {
            if ($sWhere == "") {
                $sWhere = "WHERE ";
            } else {
                $sWhere .= " AND ";
            }
            $sWhere .= "`email` IS NOT NULL";
        }

        if (isset($_GET['edad_minima']) && $_GET['edad_minima'] != "No" && isset($_GET['edad_maxima']) && $_GET['edad_maxima'] != "No") {
            $edad_minima = intval($_GET['edad_minima']);
            $edad_maxima = intval($_GET['edad_maxima']);
            $fecha_minima = date('Y-m-d', strtotime('-' . $edad_minima . ' years'));
            $fecha_maxima = date('Y-m-d', strtotime('-' . $edad_maxima . ' years'));

            if ($sWhere == "") {
                $sWhere = "WHERE ";
            } else {
                $sWhere .= " AND ";
            }
            $sWhere .= "`fecha_nacimiento` BETWEEN :fecha_maxima AND :fecha_minima AND `fecha_nacimiento` IS NOT NULL ";
            $params[':fecha_maxima'] = $fecha_maxima;
            $params[':fecha_minima'] = $fecha_minima;
        }
        // Filtering by estado_cliente
        if (isset($_GET['estado_cliente'])) {
            if ($_GET['estado_cliente'] == 'Aceptado') {
                if ($sWhere == "") {
                    $sWhere = "WHERE ";
                } else {
                    $sWhere .= " AND ";
                }
                $sWhere .= "`client_id` IN (SELECT `id_cliente` FROM `presupuestos` WHERE `estado` = 'Aceptado') ";
            } elseif ($_GET['estado_cliente'] == 'Potencial') {
                if ($sWhere == "") {
                    $sWhere = "WHERE ";
                } else {
                    $sWhere .= " AND ";
                }
                $sWhere .= "`client_id` NOT IN (SELECT `id_cliente` FROM `presupuestos` WHERE `estado` = 'Aceptado') ";
            }
        }
      
        if (isset($_GET['cp_minimo']) && $_GET['cp_minimo'] != "No" && isset($_GET['cp_maximo']) && $_GET['cp_maximo'] != "No") {
            $cp_minimo = intval($_GET['cp_minimo']);
            $cp_maximo = intval($_GET['cp_maximo']);

            // Verificar que el CP mínimo sea menor que el CP máximo
            if ($cp_minimo > $cp_maximo) {
                // No devuelve resultados si el rango es inválido
                $params[':cp_minimo'] = $cp_minimo;
                $params[':cp_maximo'] = $cp_maximo;
            } else {
                if ($sWhere == "") {
                    $sWhere = "WHERE ";
                } else {
                    $sWhere .= " AND ";
                }
                // Filtramos por el rango de CP
                $sWhere .= "`cp` BETWEEN :cp_minimo AND :cp_maximo";
                $params[':cp_minimo'] = $cp_minimo;
                $params[':cp_maximo'] = $cp_maximo;
            }
        }
 

        // Filtering by id_grupo_no
        if (isset($_GET['id_grupo_no'])) {
            if ($sWhere == "") {
                $sWhere = "WHERE ";
            } else {
                $sWhere .= " AND ";
            }
            $sWhere .= "`client_id` NOT IN (SELECT `client_id` FROM `grupo_cliente` WHERE `id_grupo` = :id_grupo_no) ";
            $params[':id_grupo_no'] = $_GET['id_grupo_no'];
        }

        // SQL queries get data to display
        $sQuery = "SELECT SQL_CALC_FOUND_ROWS `" . str_replace(" , ", " ", implode("`, `", $columns)) . "` FROM `" . $table . "` " . $sWhere . " " . $sOrder . " " . $sLimit;
        $statement = $this->_db->prepare($sQuery);
        $r = $sQuery;
        // Bind parameters
        if (isset($_GET['search']['value']) && $_GET['search']['value'] != "") {
            $statement->bindValue(':search', '%' . $_GET['search']['value'] . '%', PDO::PARAM_STR);
        }
        foreach ($params as $key => $value) {
            $statement->bindValue($key, $value, PDO::PARAM_STR);
        }

        $statement->execute();
        $rResult = $statement->fetchAll(PDO::FETCH_ASSOC);



        $iFilteredTotal = current($this->_db->query('SELECT FOUND_ROWS()')->fetch());

        // Get total number of rows in table
        $sQuery = "SELECT COUNT(`" . $index_column . "`) FROM `" . $table . "`";
        $iTotal = current($this->_db->query($sQuery)->fetch());


        $sQueryFilteredIds = "SELECT `" . $index_column . "` FROM `" . $table . "` " . $sWhere;
        $statementFilteredIds = $this->_db->prepare($sQueryFilteredIds);

        // Reutilizamos los parámetros ya preparados
        foreach ($params as $key => $value) {
            $statementFilteredIds->bindValue($key, $value, PDO::PARAM_STR);
        }

        $statementFilteredIds->execute();
        $filteredIds = $statementFilteredIds->fetchAll(PDO::FETCH_COLUMN); // Devuelve una lista de IDs


 // New query to count clients with terminos = 1
 $terminosQuery = "SELECT COUNT(*) FROM `" . $table . "` WHERE `email_marketing` = 1 AND `email` IS NOT NULL";
 $terminosCount = current($this->_db->query($terminosQuery)->fetch());

        // Incluir los IDs en el resultado final
        $output = array(
            "draw" => intval($_GET['draw']),
            "recordsTotal" => $iTotal,
            "recordsFiltered" => $iFilteredTotal,
            "data" => array(),
            "terminosCount" => $terminosCount, 
            "filteredIds" => $filteredIds, // Aquí se añaden los IDs filtrados
            "query" => $r
        );
        // Return array of values
        foreach ($rResult as $aRow) {
            $row = array();
            foreach ($columns as $column) {
                $row[$column] = $aRow[$column];
            }
            $output['data'][] = $row;
        }

        echo json_encode($output);
    }
}

header('Pragma: no-cache');
header('Cache-Control: no-store, no-cache, must-revalidate');
// Create instance of TableData class
$table_data = new TableData();